/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.sql.calcite.expression.DirectOperatorConversion;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.builtin.MultiValueStringOperatorConversions;
import org.apache.druid.sql.calcite.expression.builtin.TimeParseOperatorConversion;
import org.apache.druid.sql.calcite.planner.CalciteRulesManager;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.CatalogResolver;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.DruidRexExecutor;
import org.apache.druid.sql.calcite.planner.DruidTypeSystem;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.PlannerToolbox;
import org.apache.druid.sql.calcite.schema.DruidSchema;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.schema.NamedDruidSchema;
import org.apache.druid.sql.calcite.schema.NamedViewSchema;
import org.apache.druid.sql.calcite.schema.ViewSchema;
import org.apache.druid.sql.calcite.table.RowSignatures;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.hook.DruidHookDispatcher;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Test;

public class DruidRexExecutorTest
extends InitializedNullHandlingTest {
    private static final SqlOperator OPERATOR = OperatorConversions.operatorBuilder((String)StringUtils.toUpperCase((String)"hyper_unique")).operandTypes(new SqlTypeFamily[]{SqlTypeFamily.ANY}).requiredOperandCount(0).returnTypeInference(opBinding -> RowSignatures.makeComplexType((RelDataTypeFactory)opBinding.getTypeFactory(), (ColumnType)ColumnType.ofComplex((String)"hyperUnique"), (boolean)true)).functionCategory(SqlFunctionCategory.USER_DEFINED_FUNCTION).build();
    private static final PlannerToolbox PLANNER_TOOLBOX = new PlannerToolbox(new DruidOperatorTable(Collections.emptySet(), (Set)ImmutableSet.of((Object)new DirectOperatorConversion(OPERATOR, "hyper_unique"))), CalciteTests.createExprMacroTable(), CalciteTests.getJsonMapper(), new PlannerConfig(), new DruidSchemaCatalog((SchemaPlus)EasyMock.createMock(SchemaPlus.class), (Map)ImmutableMap.of((Object)"druid", (Object)new NamedDruidSchema((DruidSchema)EasyMock.createMock(DruidSchema.class), "druid"), (Object)"view", (Object)new NamedViewSchema((ViewSchema)EasyMock.createMock(ViewSchema.class)))), CalciteTests.createJoinableFactoryWrapper(), CatalogResolver.NULL_RESOLVER, "druid", new CalciteRulesManager((Set)ImmutableSet.of()), CalciteTests.TEST_AUTHORIZER_MAPPER, AuthConfig.newBuilder().build(), new DruidHookDispatcher());
    private static final PlannerContext PLANNER_CONTEXT = PlannerContext.create((PlannerToolbox)PLANNER_TOOLBOX, (String)"SELECT 1", null, Collections.emptyMap(), null);
    private final RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)new JavaTypeFactoryImpl());
    private final RelDataTypeFactory typeFactory = new SqlTypeFactoryImpl((RelDataTypeSystem)DruidTypeSystem.INSTANCE);

    @Test
    public void testLongsReduced() {
        RexNode call = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, new RexNode[]{this.rexBuilder.makeLiteral((Object)new BigDecimal(10L), this.typeFactory.createSqlType(SqlTypeName.BIGINT), true), this.rexBuilder.makeLiteral((Object)new BigDecimal(3L), this.typeFactory.createSqlType(SqlTypeName.BIGINT), true)});
        DruidRexExecutor rexy = new DruidRexExecutor(PLANNER_CONTEXT);
        ArrayList reduced = new ArrayList();
        rexy.reduce(this.rexBuilder, (List)ImmutableList.of((Object)call), reduced);
        Assert.assertEquals((long)1L, (long)reduced.size());
        Assert.assertEquals((Object)SqlKind.LITERAL, (Object)((RexNode)reduced.get(0)).getKind());
        Assert.assertEquals((Object)new BigDecimal(30L), (Object)((RexLiteral)reduced.get(0)).getValue());
    }

    @Test
    public void testCastDateReduced() {
        RexNode call = this.rexBuilder.makeCall(this.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.DATE), (SqlOperator)SqlStdOperatorTable.CAST, Collections.singletonList(this.rexBuilder.makeLiteral("2010-01-01")));
        DruidRexExecutor rexy = new DruidRexExecutor(PLANNER_CONTEXT);
        ArrayList reduced = new ArrayList();
        rexy.reduce(this.rexBuilder, (List)ImmutableList.of((Object)call), reduced);
        Assert.assertEquals((long)1L, (long)reduced.size());
        Assert.assertEquals((Object)SqlKind.LITERAL, (Object)((RexNode)reduced.get(0)).getKind());
        Assert.assertEquals((Object)this.rexBuilder.makeDateLiteral(Calcites.jodaToCalciteDateString((DateTime)DateTimes.of((String)"2010-01-01"), (DateTimeZone)DateTimeZone.UTC)), reduced.get(0));
    }

    @Test
    public void testTimeParseReduced() {
        RexNode call = this.rexBuilder.makeCall(new TimeParseOperatorConversion().calciteOperator(), new RexNode[]{this.rexBuilder.makeLiteral("2010-01-01T02:03:04Z")});
        DruidRexExecutor rexy = new DruidRexExecutor(PLANNER_CONTEXT);
        ArrayList reduced = new ArrayList();
        rexy.reduce(this.rexBuilder, (List)ImmutableList.of((Object)call), reduced);
        Assert.assertEquals((long)1L, (long)reduced.size());
        Assert.assertEquals((Object)SqlKind.LITERAL, (Object)((RexNode)reduced.get(0)).getKind());
        Assert.assertEquals((Object)Calcites.jodaToCalciteTimestampLiteral((RexBuilder)this.rexBuilder, (DateTime)DateTimes.of((String)"2010-01-01T02:03:04Z"), (DateTimeZone)DateTimeZone.UTC, (int)3), reduced.get(0));
    }

    @Test
    public void testTimeParseUnparseableReduced() {
        RexNode call = this.rexBuilder.makeCall(new TimeParseOperatorConversion().calciteOperator(), new RexNode[]{this.rexBuilder.makeLiteral("not a timestamp")});
        DruidRexExecutor rexy = new DruidRexExecutor(PLANNER_CONTEXT);
        ArrayList reduced = new ArrayList();
        rexy.reduce(this.rexBuilder, (List)ImmutableList.of((Object)call), reduced);
        Assert.assertEquals((long)1L, (long)reduced.size());
        Assert.assertEquals((Object)SqlKind.LITERAL, (Object)((RexNode)reduced.get(0)).getKind());
        Assert.assertTrue((boolean)RexLiteral.isNullLiteral((RexNode)((RexNode)reduced.get(0))));
    }

    @Test
    public void testComplexNotReduced() {
        DruidRexExecutor rexy = new DruidRexExecutor(PLANNER_CONTEXT);
        RexNode call = this.rexBuilder.makeCall(OPERATOR, new RexNode[0]);
        ArrayList reduced = new ArrayList();
        rexy.reduce(this.rexBuilder, (List)ImmutableList.of((Object)call), reduced);
        Assert.assertEquals((long)1L, (long)reduced.size());
        Assert.assertEquals((Object)SqlKind.OTHER_FUNCTION, (Object)((RexNode)reduced.get(0)).getKind());
        Assert.assertEquals((Object)CalciteTestBase.makeExpression(ColumnType.ofComplex((String)"hyperUnique"), "hyper_unique()"), (Object)Expressions.toDruidExpression((PlannerContext)PLANNER_CONTEXT, (RowSignature)RowSignature.builder().build(), (RexNode)((RexNode)reduced.get(0))));
    }

    @Test
    public void testArrayOfDoublesReduction() {
        DruidRexExecutor rexy = new DruidRexExecutor(PLANNER_CONTEXT);
        ArrayList reduced = new ArrayList();
        BasicSqlType basicSqlType = new BasicSqlType((RelDataTypeSystem)DruidTypeSystem.INSTANCE, SqlTypeName.DECIMAL);
        ArraySqlType arraySqlType = new ArraySqlType((RelDataType)basicSqlType, false);
        ImmutableList elements = ImmutableList.of((Object)BigDecimal.valueOf(50.12), (Object)BigDecimal.valueOf(12.1));
        RexNode literal = this.rexBuilder.makeLiteral((Object)elements, (RelDataType)arraySqlType, true);
        rexy.reduce(this.rexBuilder, (List)ImmutableList.of((Object)literal), reduced);
        Assert.assertEquals((long)1L, (long)reduced.size());
        Assert.assertEquals((Object)DruidExpression.ofExpression((ColumnType)ColumnType.DOUBLE_ARRAY, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"array"), (List)ImmutableList.of((Object)DruidExpression.ofLiteral((ColumnType)ColumnType.DOUBLE, (String)"50.12"), (Object)DruidExpression.ofLiteral((ColumnType)ColumnType.DOUBLE, (String)"12.1"))), (Object)Expressions.toDruidExpression((PlannerContext)PLANNER_CONTEXT, (RowSignature)RowSignature.empty(), (RexNode)((RexNode)reduced.get(0))));
    }

    @Test
    public void testArrayOfLongsReduction() {
        DruidRexExecutor rexy = new DruidRexExecutor(PLANNER_CONTEXT);
        ArrayList reduced = new ArrayList();
        BasicSqlType basicSqlType = new BasicSqlType((RelDataTypeSystem)DruidTypeSystem.INSTANCE, SqlTypeName.INTEGER);
        ArraySqlType arraySqlType = new ArraySqlType((RelDataType)basicSqlType, false);
        ImmutableList elements = ImmutableList.of((Object)BigDecimal.valueOf(50L), (Object)BigDecimal.valueOf(12L));
        RexNode literal = this.rexBuilder.makeLiteral((Object)elements, (RelDataType)arraySqlType, true);
        rexy.reduce(this.rexBuilder, (List)ImmutableList.of((Object)literal), reduced);
        Assert.assertEquals((long)1L, (long)reduced.size());
        Assert.assertEquals((Object)DruidExpression.ofExpression((ColumnType)ColumnType.LONG_ARRAY, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"array"), (List)ImmutableList.of((Object)DruidExpression.ofLiteral((ColumnType)ColumnType.LONG, (String)"50"), (Object)DruidExpression.ofLiteral((ColumnType)ColumnType.LONG, (String)"12"))), (Object)Expressions.toDruidExpression((PlannerContext)PLANNER_CONTEXT, (RowSignature)RowSignature.empty(), (RexNode)((RexNode)reduced.get(0))));
    }

    @Test
    public void testMultiValueStringNotReduced() {
        DruidRexExecutor rexy = new DruidRexExecutor(PLANNER_CONTEXT);
        RexNode call = this.rexBuilder.makeCall((SqlOperator)MultiValueStringOperatorConversions.StringToMultiString.SQL_FUNCTION, new RexNode[]{this.rexBuilder.makeLiteral("a,b,c"), this.rexBuilder.makeLiteral(",")});
        ArrayList reduced = new ArrayList();
        rexy.reduce(this.rexBuilder, (List)ImmutableList.of((Object)call), reduced);
        Assert.assertEquals((long)1L, (long)reduced.size());
        Assert.assertEquals((Object)SqlKind.OTHER_FUNCTION, (Object)((RexNode)reduced.get(0)).getKind());
        Assert.assertEquals((Object)DruidExpression.ofExpression((ColumnType)ColumnType.STRING, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"string_to_array"), (List)ImmutableList.of((Object)DruidExpression.ofStringLiteral((String)"a,b,c"), (Object)DruidExpression.ofStringLiteral((String)","))), (Object)Expressions.toDruidExpression((PlannerContext)PLANNER_CONTEXT, (RowSignature)RowSignature.builder().build(), (RexNode)((RexNode)reduced.get(0))));
    }
}

