/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexNode;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.ExpressionTestHelper;
import org.apache.druid.sql.calcite.expression.builtin.TimeFormatOperatorConversion;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TimeFormatOperatorConversionTest
extends CalciteTestBase {
    private static final RowSignature ROW_SIGNATURE = RowSignature.builder().add("t", ColumnType.LONG).build();
    private static final Map<String, Object> BINDINGS = ImmutableMap.builder().put((Object)"t", (Object)DateTimes.of((String)"2000-02-03T04:05:06").getMillis()).build();
    private TimeFormatOperatorConversion target;
    private ExpressionTestHelper testHelper;

    @BeforeEach
    public void setUp() {
        this.target = new TimeFormatOperatorConversion();
        this.testHelper = new ExpressionTestHelper(ROW_SIGNATURE, BINDINGS);
    }

    @Test
    public void testConversionToUTC() {
        this.testExpression("2000-02-03 04:05:06", "timestamp_format(\"t\",'yyyy-MM-dd HH:mm:ss','UTC')", "yyyy-MM-dd HH:mm:ss", "UTC");
    }

    @Test
    public void testConversionWithDefaultShouldUseUTC() {
        this.testExpression("2000-02-03 04:05:06", "timestamp_format(\"t\",'yyyy-MM-dd HH:mm:ss','UTC')", "yyyy-MM-dd HH:mm:ss", null);
    }

    @Test
    public void testConversionToTimezone() {
        this.testExpression("2000-02-02 20:05:06", "timestamp_format(\"t\",'yyyy-MM-dd HH:mm:ss','America/Los_Angeles')", "yyyy-MM-dd HH:mm:ss", "America/Los_Angeles");
    }

    @Test
    public void testConversionToUnknownTimezoneShouldThrowException() {
        Assertions.assertThrows(IAE.class, () -> this.testExpression("2000-02-02 20:05:06", "timestamp_format(\"t\",'yyyy-MM-dd HH:mm:ss','America/NO_TZ')", "yyyy-MM-dd HH:mm:ss", "America/NO_TZ"));
    }

    private void testExpression(String expectedResult, String expectedExpression, String format, @Nullable String timezone) {
        ImmutableList.Builder exprsBuilder = ImmutableList.builder().add((Object)this.testHelper.makeInputRef("t")).add((Object)this.testHelper.makeLiteral(format));
        if (timezone != null) {
            exprsBuilder.add((Object)this.testHelper.makeLiteral(timezone));
        }
        this.testHelper.testExpressionString(this.target.calciteOperator(), (List<? extends RexNode>)exprsBuilder.build(), TimeFormatOperatorConversionTest.makeExpression(expectedExpression), expectedResult);
    }
}

