/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import org.apache.druid.sql.calcite.QueryTestRunner;

public class QueryVerification {
    public static QueryResultsVerifierFactory ofResults(QueryResultsVerifier verifier) {
        return new QueryResultsVerifierFactory(verifier);
    }

    public static class QueryResultsVerifierFactory
    implements QueryTestRunner.QueryVerifyStepFactory {
        private final QueryResultsVerifier verifier;

        public QueryResultsVerifierFactory(QueryResultsVerifier verifier) {
            this.verifier = verifier;
        }

        @Override
        public QueryTestRunner.QueryVerifyStep make(QueryTestRunner.BaseExecuteQuery execStep) {
            return () -> {
                for (QueryTestRunner.QueryResults queryResults : execStep.results()) {
                    try {
                        this.verifier.verifyResults(queryResults);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Exception during verification!", e);
                    }
                }
            };
        }
    }

    public static interface QueryResultsVerifier {
        public void verifyResults(QueryTestRunner.QueryResults var1) throws Exception;
    }
}

