/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.TestInsertQueryMaker;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.run.EngineFeature;
import org.apache.druid.sql.calcite.run.QueryMaker;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.run.SqlEngines;
import org.apache.druid.sql.calcite.table.RowSignatures;
import org.apache.druid.sql.destination.IngestDestination;

public class IngestionTestSqlEngine
implements SqlEngine {
    public static final IngestionTestSqlEngine INSTANCE = new IngestionTestSqlEngine();

    private IngestionTestSqlEngine() {
    }

    public String name() {
        return "ingestion-test";
    }

    public void validateContext(Map<String, Object> queryContext) {
    }

    public RelDataType resultTypeForSelect(RelDataTypeFactory typeFactory, RelDataType validatedRowType, Map<String, Object> queryContext) {
        throw new UnsupportedOperationException();
    }

    public RelDataType resultTypeForInsert(RelDataTypeFactory typeFactory, RelDataType validatedRowType, Map<String, Object> queryContext) {
        return typeFactory.createStructType((List)ImmutableList.of((Object)typeFactory.createSqlType(SqlTypeName.VARCHAR), (Object)typeFactory.createSqlType(SqlTypeName.OTHER)), (List)ImmutableList.of((Object)"dataSource", (Object)"signature"));
    }

    public boolean featureAvailable(EngineFeature feature) {
        switch (feature) {
            case CAN_SELECT: 
            case ALLOW_BINDABLE_PLAN: 
            case TIMESERIES_QUERY: 
            case TOPN_QUERY: 
            case TIME_BOUNDARY_QUERY: 
            case SCAN_NEEDS_SIGNATURE: 
            case UNNEST: 
            case GROUPBY_IMPLICITLY_SORTS: 
            case WINDOW_FUNCTIONS: 
            case WINDOW_LEAF_OPERATOR: {
                return false;
            }
            case CAN_INSERT: 
            case CAN_REPLACE: 
            case READ_EXTERNAL_DATA: 
            case WRITE_EXTERNAL_DATA: 
            case SCAN_ORDER_BY_NON_TIME: 
            case ALLOW_BROADCAST_RIGHTY_JOIN: 
            case ALLOW_TOP_LEVEL_UNION_ALL: {
                return true;
            }
        }
        throw SqlEngines.generateUnrecognizedFeatureException((String)IngestionTestSqlEngine.class.getSimpleName(), (EngineFeature)feature);
    }

    public QueryMaker buildQueryMakerForSelect(RelRoot relRoot, PlannerContext plannerContext) {
        throw new UnsupportedOperationException();
    }

    public QueryMaker buildQueryMakerForInsert(IngestDestination destination, RelRoot relRoot, PlannerContext plannerContext) {
        RowSignature signature = RowSignatures.fromRelDataType((List)relRoot.validatedRowType.getFieldNames(), (RelDataType)relRoot.validatedRowType);
        return new TestInsertQueryMaker(destination, signature);
    }
}

