/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class CalciteTableAppendTest
extends BaseCalciteQueryTest {
    @Test
    public void testUnion() {
        this.testBuilder().sql("select dim1,null as dim4 from foo union all select dim1,dim4 from numfoo").expectedQueries((List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource("foo").intervals(CalciteTableAppendTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "v0"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).virtualColumns(new VirtualColumn[]{CalciteTableAppendTest.expressionVirtualColumn("v0", "null", null)}).build(), (Object)Druids.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteTableAppendTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "dim4"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{"", null}, (Object)new Object[]{"10.1", null}, (Object)new Object[]{"2", null}, (Object)new Object[]{"1", null}, (Object)new Object[]{"def", null}, (Object)new Object[]{"abc", null}, (Object)new Object[]{"", "a"}, (Object)new Object[]{"10.1", "a"}, (Object)new Object[]{"2", "a"}, (Object)new Object[]{"1", "b"}, (Object)new Object[]{"def", "b"}, (Object)new Object[]{"abc", "b"}, (Object[])new Object[0][])).run();
    }

    @Test
    public void testAppend2() {
        this.testBuilder().sql("select dim1,dim4,dbl1,f1 from TABLE(APPEND('foo','numfoo')) u").expectedQuery((Query<?>)Druids.newScanQueryBuilder().dataSource((DataSource)CalciteTableAppendTest.unionDataSource("foo", "numfoo")).intervals(CalciteTableAppendTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "dim4", "dbl1", "f1"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.DOUBLE, ColumnType.FLOAT}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()).expectedResults(BaseCalciteQueryTest.ResultMatchMode.RELAX_NULLS, (List<Object[]>)ImmutableList.of((Object)new Object[]{"", null, null, null}, (Object)new Object[]{"10.1", null, null, null}, (Object)new Object[]{"2", null, null, null}, (Object)new Object[]{"1", null, null, null}, (Object)new Object[]{"def", null, null, null}, (Object)new Object[]{"abc", null, null, null}, (Object)new Object[]{"", "a", 1.0, Float.valueOf(1.0f)}, (Object)new Object[]{"10.1", "a", 1.7, Float.valueOf(0.1f)}, (Object)new Object[]{"2", "a", 0.0, Float.valueOf(0.0f)}, (Object)new Object[]{"1", "b", null, null}, (Object)new Object[]{"def", "b", null, null}, (Object)new Object[]{"abc", "b", null, null}, (Object[])new Object[0][])).expectedLogicalPlan("LogicalProject(exprs=[[$1, $8, $11, $13]])\n  LogicalTableScan(table=[[APPEND]])\n").run();
    }

    @Test
    public void testAppendSameTableMultipleTimes() {
        this.testBuilder().sql("select dim1,dim4,dbl1,f1 from TABLE(APPEND('foo','numfoo','foo')) u where dim1='2'").expectedQuery((Query<?>)Druids.newScanQueryBuilder().dataSource((DataSource)CalciteTableAppendTest.unionDataSource("foo", "numfoo", "foo")).intervals(CalciteTableAppendTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "dim4", "dbl1", "f1"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.DOUBLE, ColumnType.FLOAT}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).filters(CalciteTableAppendTest.equality("dim1", "2", ColumnType.STRING)).build()).expectedResults(BaseCalciteQueryTest.ResultMatchMode.RELAX_NULLS, (List<Object[]>)ImmutableList.of((Object)new Object[]{"2", null, null, null}, (Object)new Object[]{"2", null, null, null}, (Object)new Object[]{"2", "a", 0.0, Float.valueOf(0.0f)})).run();
    }

    @Test
    public void testAppendtSingleTableIsValid() {
        this.testBuilder().sql("select dim1 from TABLE(APPEND('foo')) u").expectedQuery((Query<?>)Druids.newScanQueryBuilder().dataSource((DataSource)CalciteTableAppendTest.unionDataSource("foo")).intervals(CalciteTableAppendTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"10.1"}, (Object)new Object[]{"2"}, (Object)new Object[]{"1"}, (Object)new Object[]{"def"}, (Object)new Object[]{"abc"})).run();
    }

    @Test
    public void testAppendCompatibleColumns() {
        this.testBuilder().sql("select dim3 from TABLE(APPEND('foo','foo2')) u").expectedQuery((Query<?>)Druids.newScanQueryBuilder().dataSource((DataSource)CalciteTableAppendTest.unionDataSource("foo", "foo2")).intervals(CalciteTableAppendTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim3"}).columnTypes(new ColumnType[]{ColumnType.STRING}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()).expectedResults(BaseCalciteQueryTest.ResultMatchMode.RELAX_NULLS, (List<Object[]>)ImmutableList.of((Object)new Object[]{"11"}, (Object)new Object[]{"12"}, (Object)new Object[]{"10"}, (Object)new Object[]{"[\"a\",\"b\"]"}, (Object)new Object[]{"[\"b\",\"c\"]"}, (Object)new Object[]{"d"}, (Object)new Object[]{""}, (Object)new Object[]{null}, (Object)new Object[]{null})).run();
    }

    @Test
    public void testAppendNoTableIsInvalid() {
        try {
            this.testBuilder().sql("select dim1 from TABLE(APPEND()) u").run();
            Assert.fail((String)"query execution should fail");
        }
        catch (DruidException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteTableAppendTest.invalidSqlIs("No match found for function signature APPEND() (line [1], column [24])"));
        }
    }

    @Test
    public void testAppendtInvalidIntegerArg() {
        try {
            this.testBuilder().sql("select dim1 from TABLE(APPEND('foo',111)) u").run();
            Assert.fail((String)"query execution should fail");
        }
        catch (DruidException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteTableAppendTest.invalidSqlIs("All arguments to APPEND should be literal strings. Argument #2 is not string (line [1], column [37])"));
        }
    }

    @Test
    public void testAppendtNullArg() {
        try {
            this.testBuilder().sql("select dim1 from TABLE(APPEND('foo',null)) u").run();
            Assert.fail((String)"query execution should fail");
        }
        catch (DruidException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteTableAppendTest.invalidSqlIs("All arguments to APPEND should be literal strings. Argument #2 is not string (line [1], column [37])"));
        }
    }

    @Test
    public void testAppendtNonExistentTable() {
        try {
            this.testBuilder().sql("select dim1 from TABLE(APPEND('foo','nonexistent')) u").run();
            Assert.fail((String)"query execution should fail");
        }
        catch (DruidException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteTableAppendTest.invalidSqlIs("Table [nonexistent] not found (line [1], column [37])"));
        }
    }

    @Test
    public void testAppendCTE() {
        try {
            this.testBuilder().sql("with t0 as (select * from foo) select dim3 from TABLE(APPEND('t0','foo')) u").run();
            Assert.fail((String)"query execution should fail");
        }
        catch (DruidException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteTableAppendTest.invalidSqlIs("Table [t0] not found (line [1], column [62])"));
        }
    }
}

