/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.LazySequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DefaultQueryConfig;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.server.QueryLaningStrategy;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.log.TestRequestLogger;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.server.scheduling.HiLoQueryLaningStrategy;
import org.apache.druid.server.scheduling.ManualQueryPrioritizationStrategy;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.sql.DirectStatement;
import org.apache.druid.sql.HttpStatement;
import org.apache.druid.sql.PreparedStatement;
import org.apache.druid.sql.SqlLifecycleManager;
import org.apache.druid.sql.SqlQueryPlus;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.SqlToolbox;
import org.apache.druid.sql.calcite.planner.CalciteRulesManager;
import org.apache.druid.sql.calcite.planner.CatalogResolver;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.planner.PrepareResult;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.hook.DruidHookDispatcher;
import org.apache.druid.sql.http.SqlQuery;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SqlStatementTest {
    private static QueryRunnerFactoryConglomerate conglomerate;
    private static SpecificSegmentsQuerySegmentWalker walker;
    private static Closer resourceCloser;
    @ClassRule
    public static TemporaryFolder temporaryFolder;
    private TestRequestLogger testRequestLogger;
    private ListeningExecutorService executorService;
    private SqlStatementFactory sqlStatementFactory;
    private final DefaultQueryConfig defaultQueryConfig = new DefaultQueryConfig((Map)ImmutableMap.of((Object)"DEFAULT_KEY", (Object)"DEFAULT_VALUE"));

    @BeforeClass
    public static void setUpClass() throws Exception {
        resourceCloser = Closer.create();
        conglomerate = QueryStackTests.createQueryRunnerFactoryConglomerate((Closer)resourceCloser);
        QueryScheduler scheduler = new QueryScheduler(5, ManualQueryPrioritizationStrategy.INSTANCE, (QueryLaningStrategy)new HiLoQueryLaningStrategy(Integer.valueOf(40)), new ServerConfig()){

            public <T> Sequence<T> run(Query<?> query, Sequence<T> resultSequence) {
                return super.run(query, (Sequence)new LazySequence(() -> resultSequence));
            }
        };
        walker = CalciteTests.createMockWalker(conglomerate, temporaryFolder.newFolder(), scheduler);
        resourceCloser.register((Closeable)walker);
    }

    @AfterClass
    public static void tearDownClass() throws IOException {
        resourceCloser.close();
    }

    @Before
    public void setUp() {
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)8, (String)"test_sql_resource_%s"));
        PlannerConfig plannerConfig = PlannerConfig.builder().build();
        DruidSchemaCatalog rootSchema = CalciteTests.createMockRootSchema(conglomerate, walker, plannerConfig, CalciteTests.TEST_AUTHORIZER_MAPPER);
        DruidOperatorTable operatorTable = CalciteTests.createOperatorTable();
        ExprMacroTable macroTable = CalciteTests.createExprMacroTable();
        this.testRequestLogger = new TestRequestLogger();
        JoinableFactoryWrapper joinableFactoryWrapper = CalciteTests.createJoinableFactoryWrapper();
        PlannerFactory plannerFactory = new PlannerFactory(rootSchema, operatorTable, macroTable, plannerConfig, CalciteTests.TEST_AUTHORIZER_MAPPER, CalciteTests.getJsonMapper(), "druid", new CalciteRulesManager((Set)ImmutableSet.of()), joinableFactoryWrapper, CatalogResolver.NULL_RESOLVER, new AuthConfig(), new DruidHookDispatcher());
        this.sqlStatementFactory = new SqlStatementFactory(new SqlToolbox((SqlEngine)CalciteTests.createMockSqlEngine((QuerySegmentWalker)walker, conglomerate), plannerFactory, (ServiceEmitter)new NoopServiceEmitter(), (RequestLogger)this.testRequestLogger, QueryStackTests.DEFAULT_NOOP_SCHEDULER, this.defaultQueryConfig, new SqlLifecycleManager()));
    }

    @After
    public void tearDown() throws Exception {
        this.executorService.shutdownNow();
        this.executorService.awaitTermination(2L, TimeUnit.SECONDS);
    }

    HttpServletRequest request(boolean ok) {
        HttpServletRequest req = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        EasyMock.expect((Object)req.getAttribute("Druid-Authentication-Result")).andReturn((Object)CalciteTests.REGULAR_USER_AUTH_RESULT).anyTimes();
        EasyMock.expect((Object)req.getRemoteAddr()).andReturn(null).once();
        EasyMock.expect((Object)req.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)req.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        EasyMock.expect((Object)req.getAttribute("Druid-Authentication-Result")).andReturn((Object)CalciteTests.REGULAR_USER_AUTH_RESULT).anyTimes();
        req.setAttribute("Druid-Authorization-Checked", (Object)ok);
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)req.getAttribute("Druid-Authentication-Result")).andReturn((Object)CalciteTests.REGULAR_USER_AUTH_RESULT).anyTimes();
        EasyMock.replay((Object[])new Object[]{req});
        return req;
    }

    private SqlQueryPlus queryPlus(String sql, AuthenticationResult authResult) {
        return SqlQueryPlus.builder((String)sql).auth(authResult).build();
    }

    @Test
    public void testDirectHappyPath() {
        SqlQueryPlus sqlReq = this.queryPlus("SELECT COUNT(*) AS cnt, 'foo' AS TheFoo FROM druid.foo", CalciteTests.REGULAR_USER_AUTH_RESULT);
        DirectStatement stmt = this.sqlStatementFactory.directStatement(sqlReq);
        DirectStatement.ResultSet resultSet = stmt.plan();
        Assert.assertTrue((boolean)resultSet.runnable());
        List results = resultSet.run().getResults().toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)6L, (Object)((Object[])results.get(0))[0]);
        Assert.assertEquals((Object)"foo", (Object)((Object[])results.get(0))[1]);
        Assert.assertSame((Object)stmt.reporter(), (Object)resultSet.reporter());
        Assert.assertSame((Object)stmt.resources(), (Object)resultSet.resources());
        Assert.assertSame((Object)stmt.query(), (Object)resultSet.query());
        Assert.assertFalse((boolean)resultSet.runnable());
        resultSet.close();
        stmt.close();
    }

    @Test
    public void testDirectPlanTwice() {
        SqlQueryPlus sqlReq = this.queryPlus("SELECT COUNT(*) AS cnt, 'foo' AS TheFoo FROM druid.foo", CalciteTests.REGULAR_USER_AUTH_RESULT);
        DirectStatement stmt = this.sqlStatementFactory.directStatement(sqlReq);
        stmt.plan();
        try {
            stmt.plan();
            Assert.fail();
        }
        catch (ISE e) {
            stmt.closeWithError((Throwable)e);
        }
    }

    @Test
    public void testDirectExecTwice() {
        SqlQueryPlus sqlReq = this.queryPlus("SELECT COUNT(*) AS cnt, 'foo' AS TheFoo FROM druid.foo", CalciteTests.REGULAR_USER_AUTH_RESULT);
        DirectStatement stmt = this.sqlStatementFactory.directStatement(sqlReq);
        DirectStatement.ResultSet resultSet = stmt.plan();
        resultSet.run();
        try {
            resultSet.run();
            Assert.fail();
        }
        catch (ISE e) {
            stmt.closeWithError((Throwable)e);
        }
    }

    @Test
    public void testDirectSyntaxError() {
        SqlQueryPlus sqlReq = this.queryPlus("SELECT COUNT(*) AS cnt, 'foo' AS", CalciteTests.REGULAR_USER_AUTH_RESULT);
        DirectStatement stmt = this.sqlStatementFactory.directStatement(sqlReq);
        try {
            stmt.execute();
            Assert.fail();
        }
        catch (DruidException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)DruidExceptionMatcher.invalidSqlInput().expectMessageContains("Incorrect syntax near the keyword 'AS' at line 1, column 31"));
        }
    }

    @Test
    public void testDirectValidationError() {
        SqlQueryPlus sqlReq = this.queryPlus("SELECT COUNT(*) AS cnt, 'foo' AS TheFoo FROM druid.bogus", CalciteTests.REGULAR_USER_AUTH_RESULT);
        DirectStatement stmt = this.sqlStatementFactory.directStatement(sqlReq);
        try {
            stmt.execute();
            Assert.fail();
        }
        catch (DruidException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)DruidExceptionMatcher.invalidSqlInput().expectMessageContains("Object 'bogus' not found within 'druid'"));
        }
    }

    @Test
    public void testDirectPermissionError() {
        SqlQueryPlus sqlReq = this.queryPlus("select count(*) from forbiddenDatasource", CalciteTests.REGULAR_USER_AUTH_RESULT);
        DirectStatement stmt = this.sqlStatementFactory.directStatement(sqlReq);
        try {
            stmt.execute();
            Assert.fail();
        }
        catch (ForbiddenException forbiddenException) {
            // empty catch block
        }
    }

    private SqlQuery makeQuery(String sql) {
        return new SqlQuery(sql, null, false, false, false, null, null);
    }

    @Test
    public void testHttpHappyPath() {
        HttpStatement stmt = this.sqlStatementFactory.httpStatement(this.makeQuery("SELECT COUNT(*) AS cnt, 'foo' AS TheFoo FROM druid.foo"), this.request(true));
        List results = stmt.execute().getResults().toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)6L, (Object)((Object[])results.get(0))[0]);
        Assert.assertEquals((Object)"foo", (Object)((Object[])results.get(0))[1]);
    }

    @Test
    public void testHttpSyntaxError() {
        HttpStatement stmt = this.sqlStatementFactory.httpStatement(this.makeQuery("SELECT COUNT(*) AS cnt, 'foo' AS"), this.request(true));
        try {
            stmt.execute();
            Assert.fail();
        }
        catch (DruidException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)DruidExceptionMatcher.invalidSqlInput().expectMessageContains("Incorrect syntax near the keyword 'AS' at line 1, column 31"));
        }
    }

    @Test
    public void testHttpValidationError() {
        HttpStatement stmt = this.sqlStatementFactory.httpStatement(this.makeQuery("SELECT COUNT(*) AS cnt, 'foo' AS TheFoo FROM druid.bogus"), this.request(true));
        try {
            stmt.execute();
            Assert.fail();
        }
        catch (DruidException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)DruidExceptionMatcher.invalidSqlInput().expectMessageContains("Object 'bogus' not found within 'druid'"));
        }
    }

    @Test
    public void testHttpPermissionError() {
        HttpStatement stmt = this.sqlStatementFactory.httpStatement(this.makeQuery("select count(*) from forbiddenDatasource"), this.request(false));
        try {
            stmt.execute();
            Assert.fail();
        }
        catch (ForbiddenException forbiddenException) {
            // empty catch block
        }
    }

    @Test
    public void testPreparedHappyPath() {
        SqlQueryPlus sqlReq = this.queryPlus("SELECT COUNT(*) AS cnt, 'foo' AS TheFoo FROM druid.foo", CalciteTests.REGULAR_USER_AUTH_RESULT);
        PreparedStatement stmt = this.sqlStatementFactory.preparedStatement(sqlReq);
        PrepareResult prepareResult = stmt.prepare();
        RelDataType rowType = prepareResult.getReturnedRowType();
        Assert.assertEquals((long)2L, (long)rowType.getFieldCount());
        List fields = rowType.getFieldList();
        Assert.assertEquals((Object)"cnt", (Object)((RelDataTypeField)fields.get(0)).getName());
        Assert.assertEquals((Object)"BIGINT", (Object)((RelDataTypeField)fields.get(0)).getType().toString());
        Assert.assertEquals((Object)"TheFoo", (Object)((RelDataTypeField)fields.get(1)).getName());
        Assert.assertEquals((Object)"CHAR(3)", (Object)((RelDataTypeField)fields.get(1)).getType().toString());
        for (int i = 0; i < 3; ++i) {
            List results = stmt.execute(Collections.emptyList()).execute().getResults().toList();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((Object)6L, (Object)((Object[])results.get(0))[0]);
            Assert.assertEquals((Object)"foo", (Object)((Object[])results.get(0))[1]);
        }
    }

    @Test
    public void testPrepareSyntaxError() {
        SqlQueryPlus sqlReq = this.queryPlus("SELECT COUNT(*) AS cnt, 'foo' AS", CalciteTests.REGULAR_USER_AUTH_RESULT);
        PreparedStatement stmt = this.sqlStatementFactory.preparedStatement(sqlReq);
        try {
            stmt.prepare();
            Assert.fail();
        }
        catch (DruidException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)DruidExceptionMatcher.invalidSqlInput().expectMessageContains("Incorrect syntax near the keyword 'AS' at line 1, column 31"));
        }
    }

    @Test
    public void testPrepareValidationError() {
        SqlQueryPlus sqlReq = this.queryPlus("SELECT COUNT(*) AS cnt, 'foo' AS TheFoo FROM druid.bogus", CalciteTests.REGULAR_USER_AUTH_RESULT);
        PreparedStatement stmt = this.sqlStatementFactory.preparedStatement(sqlReq);
        try {
            stmt.prepare();
            Assert.fail();
        }
        catch (DruidException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)DruidExceptionMatcher.invalidSqlInput().expectMessageContains("Object 'bogus' not found within 'druid'"));
        }
    }

    @Test
    public void testPreparePermissionError() {
        SqlQueryPlus sqlReq = this.queryPlus("select count(*) from forbiddenDatasource", CalciteTests.REGULAR_USER_AUTH_RESULT);
        PreparedStatement stmt = this.sqlStatementFactory.preparedStatement(sqlReq);
        try {
            stmt.prepare();
            Assert.fail();
        }
        catch (ForbiddenException forbiddenException) {
            // empty catch block
        }
    }

    @Test
    public void testIgnoredQueryContextParametersAreIgnored() {
        SqlQueryPlus sqlReq = SqlQueryPlus.builder((String)"select 1 + ?").context((Map)ImmutableMap.of((Object)"bySegment", (Object)"true")).auth(CalciteTests.REGULAR_USER_AUTH_RESULT).build();
        DirectStatement stmt = this.sqlStatementFactory.directStatement(sqlReq);
        Map context = stmt.context();
        Assert.assertEquals((long)2L, (long)context.size());
        Assert.assertTrue((boolean)context.containsKey("sqlQueryId"));
    }

    @Test
    public void testDefaultQueryContextIsApplied() {
        SqlQueryPlus sqlReq = SqlQueryPlus.builder((String)"select 1 + ?").context((Map)ImmutableMap.of((Object)"bySegment", (Object)"true")).auth(CalciteTests.REGULAR_USER_AUTH_RESULT).build();
        DirectStatement stmt = this.sqlStatementFactory.directStatement(sqlReq);
        Map context = stmt.context();
        Assert.assertEquals((long)2L, (long)context.size());
        for (String defaultContextKey : this.defaultQueryConfig.getContext().keySet()) {
            Assert.assertTrue((boolean)context.containsKey(defaultContextKey));
        }
    }

    static {
        temporaryFolder = new TemporaryFolder();
    }
}

