/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.quidem;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class DynamicComposite<T, E>
implements InvocationHandler {
    private final T base;
    private final E ext;
    private final Class<E> extClass;

    public static <T, E> T make(T base, Class<T> baseClass, E ext, Class<E> extClass) {
        return (T)Proxy.newProxyInstance(base.getClass().getClassLoader(), new Class[]{baseClass, extClass}, new DynamicComposite<T, E>(base, ext, extClass));
    }

    private DynamicComposite(T base, E ext, Class<E> extClass) {
        this.base = base;
        this.ext = ext;
        this.extClass = extClass;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == this.extClass) {
            return method.invoke(this.ext, args);
        }
        return method.invoke(this.base, args);
    }
}

