/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.quidem;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.hydromatic.quidem.CommandHandler;
import net.hydromatic.quidem.Quidem;
import org.apache.calcite.test.DiffTestCase;
import org.apache.calcite.util.Closer;
import org.apache.calcite.util.Util;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.quidem.DruidAvaticaTestDriver;
import org.apache.druid.quidem.DruidQuidemCommandHandler;
import org.apache.druid.quidem.DruidQuidemConnectionFactory;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class DruidQuidemTestBase {
    public static final String IQ_SUFFIX = ".iq";
    private static final String OVERWRITE_PROPERTY = "quidem.overwrite";
    private static final String PROPERTY_FILTER = "quidem.filter";
    private FileFilter filter = TrueFileFilter.INSTANCE;
    private DruidQuidemRunner druidQuidemRunner;

    public DruidQuidemTestBase() {
        Object filterStr = System.getProperty(PROPERTY_FILTER, null);
        if (filterStr != null) {
            if (!((String)filterStr).endsWith("*") && !((String)filterStr).endsWith(IQ_SUFFIX)) {
                filterStr = (String)filterStr + IQ_SUFFIX;
            }
            this.filter = new WildcardFileFilter((String)filterStr);
        }
        this.druidQuidemRunner = new DruidQuidemRunner();
    }

    protected CommandHandler createCommandHandler() {
        return Quidem.EMPTY_COMMAND_HANDLER;
    }

    @ParameterizedTest
    @MethodSource(value={"getFileNames"})
    public void test(String testFileName) throws Exception {
        File inFile = new File(this.getTestRoot(), testFileName);
        File outFile = new File(inFile.getParentFile(), inFile.getName() + ".out");
        this.druidQuidemRunner.run(inFile, outFile);
    }

    protected final List<String> getFileNames() throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        File testRoot = this.getTestRoot();
        if (!testRoot.exists()) {
            throw new FileNotFoundException(StringUtils.format((String)"testRoot [%s] doesn't exists!", (Object[])new Object[]{testRoot}));
        }
        for (File f : testRoot.listFiles(this::isTestIncluded)) {
            ret.add(f.getName());
        }
        if (ret.isEmpty()) {
            throw new IAE("There are no test cases in directory [%s] or there are no matches to filter [%s]", new Object[]{testRoot, this.filter});
        }
        Collections.sort(ret);
        return ret;
    }

    private boolean isTestIncluded(File f) {
        return !f.isDirectory() && f.getName().endsWith(IQ_SUFFIX) && this.filter.accept(f);
    }

    protected abstract File getTestRoot();

    @AfterAll
    public static void afterAll() {
        DruidAvaticaTestDriver.CONFIG_STORE.close();
    }

    public static class DruidQuidemRunner {
        public void run(File inFile) throws Exception {
            File outFile = new File(inFile.getParent(), inFile.getName() + ".out");
            this.run(inFile, outFile);
        }

        public void run(File inFile, File outFile) throws Exception {
            FileUtils.mkdirp((File)outFile.getParentFile());
            try (BufferedReader reader = Util.reader((File)inFile);
                 PrintWriter writer = Util.printWriter((File)outFile);
                 Closer closer = new Closer();){
                DruidQuidemConnectionFactory connectionFactory = new DruidQuidemConnectionFactory();
                Quidem.ConfigBuilder configBuilder = Quidem.configBuilder().withConnectionFactory((Quidem.ConnectionFactory)connectionFactory).withPropertyHandler((Quidem.PropertyHandler)connectionFactory).withCommandHandler((CommandHandler)new DruidQuidemCommandHandler());
                Quidem.Config config = configBuilder.withReader((Reader)reader).withWriter((Writer)writer).build();
                new Quidem(config).execute();
            }
            catch (Exception e) {
                throw new RE((Throwable)e, "Encountered exception while running [%s]", new Object[]{inFile});
            }
            String diff = DiffTestCase.diff((File)inFile, (File)outFile);
            if (!diff.isEmpty()) {
                if (DruidQuidemRunner.isOverwrite()) {
                    Files.copy((File)outFile, (File)inFile);
                } else {
                    Assertions.fail((String)("Files differ: " + outFile + " " + inFile + "\n" + diff));
                }
            }
        }

        public static boolean isOverwrite() {
            String property = System.getProperty(DruidQuidemTestBase.OVERWRITE_PROPERTY, "false");
            return property.length() == 0 || Boolean.valueOf(property) != false;
        }
    }
}

