/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.table;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.table.DruidTable;

public class LookupTable
extends DruidTable {
    private final DataSource dataSource;

    public LookupTable(LookupDataSource dataSource, RowSignature rowSignature) {
        super(rowSignature);
        this.dataSource = (DataSource)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public boolean isJoinable() {
        return true;
    }

    @Override
    public boolean isBroadcast() {
        return true;
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable table) {
        return LogicalTableScan.create((RelOptCluster)context.getCluster(), (RelOptTable)table, (List)context.getTableHints());
    }

    @Override
    public String toString() {
        return "LookupTable{dataSource=" + this.dataSource + ", rowSignature=" + this.getRowSignature() + '}';
    }
}

