/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule.logical;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mappings;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Value;

@Value.Enclosing
public class DruidAggregateRemoveRedundancyRule
extends RelOptRule
implements TransformationRule {
    private static final DruidAggregateRemoveRedundancyRule INSTANCE = new DruidAggregateRemoveRedundancyRule();

    private DruidAggregateRemoveRedundancyRule() {
        super(DruidAggregateRemoveRedundancyRule.operand(Aggregate.class, (RelOptRuleOperand)DruidAggregateRemoveRedundancyRule.operand(Project.class, (RelOptRuleOperandChildren)DruidAggregateRemoveRedundancyRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public static DruidAggregateRemoveRedundancyRule instance() {
        return INSTANCE;
    }

    public void onMatch(RelOptRuleCall call) {
        Project project;
        Aggregate aggregate = (Aggregate)call.rel(0);
        RelNode x = DruidAggregateRemoveRedundancyRule.apply(call, aggregate, project = (Project)call.rel(1));
        if (x != null) {
            call.transformTo(x);
            call.getPlanner().prune((RelNode)aggregate);
        }
    }

    public static @Nullable RelNode apply(RelOptRuleCall call, Aggregate aggregate, Project project) {
        Set interestingFields = RelOptUtil.getAllFields((Aggregate)aggregate);
        if (interestingFields.isEmpty()) {
            return null;
        }
        HashMap map = new HashMap();
        HashMap<RexNode, Integer> assignedRefForExpr = new HashMap<RexNode, Integer>();
        ArrayList<RexInputRef> newRexNodes = new ArrayList<RexInputRef>();
        Iterator iterator = interestingFields.iterator();
        while (iterator.hasNext()) {
            int source = (Integer)iterator.next();
            RexNode rex = (RexNode)project.getProjects().get(source);
            if (!assignedRefForExpr.containsKey(rex)) {
                RexInputRef newNode = new RexInputRef(source, rex.getType());
                assignedRefForExpr.put(rex, newRexNodes.size());
                newRexNodes.add(newNode);
            }
            map.put(source, assignedRefForExpr.get(rex));
        }
        if (newRexNodes.size() == project.getProjects().size()) {
            return null;
        }
        ImmutableBitSet newGroupSet = aggregate.getGroupSet().permute(map);
        ImmutableList newGroupingSets = null;
        if (aggregate.getGroupType() != Aggregate.Group.SIMPLE) {
            newGroupingSets = ImmutableBitSet.ORDERING.immutableSortedCopy((Iterable)Sets.newTreeSet((Iterable)ImmutableBitSet.permute((Iterable)aggregate.getGroupSets(), map)));
        }
        ImmutableList.Builder aggCalls = ImmutableList.builder();
        int sourceCount = aggregate.getInput().getRowType().getFieldCount();
        int targetCount = newRexNodes.size();
        Mappings.TargetMapping targetMapping = Mappings.target(map, (int)sourceCount, (int)targetCount);
        for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
            aggCalls.add((Object)aggregateCall.transform(targetMapping));
        }
        RelBuilder relBuilder = call.builder();
        relBuilder.push((RelNode)project);
        relBuilder.project(newRexNodes);
        Aggregate newAggregate = aggregate.copy(aggregate.getTraitSet(), relBuilder.build(), newGroupSet, (List)newGroupingSets, (List)aggCalls.build());
        relBuilder.push((RelNode)newAggregate);
        List newKeys = Util.transform((List)aggregate.getGroupSet().asList(), key -> (Integer)Objects.requireNonNull(map.get(key), () -> "no value found for key " + key + " in " + map));
        if (!newKeys.equals(newGroupSet.asList())) {
            ArrayList<Integer> posList = new ArrayList<Integer>();
            Iterator iterator2 = newKeys.iterator();
            while (iterator2.hasNext()) {
                int newKey = (Integer)iterator2.next();
                posList.add(newGroupSet.indexOf(newKey));
            }
            for (int i = newAggregate.getGroupCount(); i < newAggregate.getRowType().getFieldCount(); ++i) {
                posList.add(i);
            }
            relBuilder.project((Iterable)relBuilder.fields(posList));
        }
        return relBuilder.build();
    }
}

