/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.tools.RelBuilder;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.sql.calcite.expression.builtin.ConcatOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TextcatOperatorConversion;

public class FlattenConcatRule
extends RelOptRule
implements SubstitutionRule {
    public FlattenConcatRule() {
        super(FlattenConcatRule.operand(RelNode.class, (RelOptRuleOperandChildren)FlattenConcatRule.any()));
    }

    public void onMatch(RelOptRuleCall call) {
        FlattenConcatShuttle shuttle;
        RelNode oldNode = call.rel(0);
        RelNode newNode = oldNode.accept((RexShuttle)(shuttle = new FlattenConcatShuttle(oldNode.getCluster().getRexBuilder())));
        if (newNode != oldNode) {
            RelBuilder relBuilder = call.builder().push(newNode);
            relBuilder.convert(oldNode.getRowType(), false);
            call.transformTo(relBuilder.build());
            call.getPlanner().prune(oldNode);
        }
    }

    static boolean isStringConcat(RexNode rexNode) {
        if (SqlTypeFamily.STRING.contains(rexNode.getType()) && rexNode instanceof RexCall) {
            SqlOperator operator = ((RexCall)rexNode).getOperator();
            return ConcatOperatorConversion.SQL_FUNCTION.equals((Object)operator) || TextcatOperatorConversion.SQL_FUNCTION.equals((Object)operator) || SqlStdOperatorTable.CONCAT.equals((Object)operator);
        }
        return false;
    }

    static boolean isNonTrivialStringConcat(RexNode rexNode) {
        return FlattenConcatRule.isStringConcat(rexNode) && !RelOptUtil.InputFinder.bits((RexNode)rexNode).isEmpty();
    }

    private static class FlattenConcatShuttle
    extends RexShuttle {
        private final RexBuilder rexBuilder;

        public FlattenConcatShuttle(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public RexNode visitCall(RexCall call) {
            if (FlattenConcatRule.isNonTrivialStringConcat((RexNode)call)) {
                ArrayList<RexNode> newOperands = new ArrayList<RexNode>();
                for (RexNode operand : call.getOperands()) {
                    if (FlattenConcatRule.isNonTrivialStringConcat(operand)) {
                        RexNode visitedOperand = this.visitCall((RexCall)operand);
                        if (FlattenConcatRule.isStringConcat(visitedOperand)) {
                            newOperands.addAll(((RexCall)visitedOperand).getOperands());
                            continue;
                        }
                        newOperands.add(visitedOperand);
                        continue;
                    }
                    if (RexUtil.isNullLiteral((RexNode)operand, (boolean)true) && NullHandling.sqlCompatible()) {
                        return this.rexBuilder.makeNullLiteral(call.getType());
                    }
                    newOperands.add(operand);
                }
                if (!newOperands.equals(call.getOperands())) {
                    return this.rexBuilder.makeCall((SqlOperator)ConcatOperatorConversion.SQL_FUNCTION, newOperands);
                }
                return call;
            }
            return super.visitCall(call);
        }
    }
}

