/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.rules.FilterJoinRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.tools.RelBuilder;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.Pair;

public abstract class FilterJoinExcludePushToChildRule<C extends FilterJoinRule.Config>
extends FilterJoinRule<C> {
    public static final FilterJoinRule<FilterJoinRule.FilterIntoJoinRule.FilterIntoJoinRuleConfig> FILTER_ON_JOIN_EXCLUDE_PUSH_TO_CHILD = new FilterIntoJoinExcludePushToChildRule(FilterJoinRule.FilterIntoJoinRule.FilterIntoJoinRuleConfig.DEFAULT);

    FilterJoinExcludePushToChildRule(C config) {
        super(config);
    }

    protected void perform(RelOptRuleCall call, Filter filter, Join join) {
        List joinFilters = RelOptUtil.conjunctions((RexNode)join.getCondition());
        ImmutableList origJoinFilters = ImmutableList.copyOf((Collection)joinFilters);
        if (filter == null && joinFilters.isEmpty()) {
            return;
        }
        ArrayList<RexNode> aboveFilters = filter != null ? this.getConjunctions(filter) : new ArrayList();
        ImmutableList origAboveFilters = ImmutableList.copyOf(aboveFilters);
        JoinRelType joinType = join.getJoinType();
        if (!origAboveFilters.isEmpty() && join.getJoinType() != JoinRelType.INNER) {
            joinType = RelOptUtil.simplifyJoin((RelNode)join, (ImmutableList)origAboveFilters, (JoinRelType)joinType);
        }
        ArrayList leftFilters = new ArrayList();
        ArrayList rightFilters = new ArrayList();
        boolean filterPushed = false;
        if (FilterJoinExcludePushToChildRule.classifyFilters(aboveFilters, joinType, true, joinFilters)) {
            filterPushed = true;
        }
        this.validateJoinFilters(aboveFilters, joinFilters, join, joinType);
        if (joinFilters.size() == origJoinFilters.size() && Sets.newHashSet((Iterable)joinFilters).equals(Sets.newHashSet((Iterable)origJoinFilters))) {
            filterPushed = false;
        }
        if (joinType != JoinRelType.ANTI && FilterJoinExcludePushToChildRule.classifyFilters(joinFilters, joinType, false, joinFilters)) {
            filterPushed = true;
        }
        FilterJoinExcludePushToChildRule.removeRedundantIsNotNullFilters(joinFilters, joinType, NullHandling.sqlCompatible());
        if (!filterPushed && joinType == join.getJoinType() || joinFilters.isEmpty()) {
            return;
        }
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        RelBuilder relBuilder = call.builder();
        RelNode leftRel = relBuilder.push(join.getLeft()).filter(leftFilters).build();
        RelNode rightRel = relBuilder.push(join.getRight()).filter(rightFilters).build();
        ImmutableList fieldTypes = ImmutableList.builder().addAll((Iterable)RelOptUtil.getFieldTypeList((RelDataType)leftRel.getRowType())).addAll((Iterable)RelOptUtil.getFieldTypeList((RelDataType)rightRel.getRowType())).build();
        RexNode joinFilter = RexUtil.composeConjunction((RexBuilder)rexBuilder, (Iterable)RexUtil.fixUp((RexBuilder)rexBuilder, (List)joinFilters, (List)fieldTypes));
        if (joinFilter.isAlwaysTrue() && leftFilters.isEmpty() && rightFilters.isEmpty() && joinType == join.getJoinType()) {
            return;
        }
        Join newJoinRel = join.copy(join.getTraitSet(), joinFilter, leftRel, rightRel, joinType, join.isSemiJoinDone());
        call.getPlanner().onCopy((RelNode)join, (RelNode)newJoinRel);
        if (!leftFilters.isEmpty()) {
            call.getPlanner().onCopy((RelNode)filter, leftRel);
        }
        if (!rightFilters.isEmpty()) {
            call.getPlanner().onCopy((RelNode)filter, rightRel);
        }
        relBuilder.push((RelNode)newJoinRel);
        relBuilder.convert(join.getRowType(), false);
        relBuilder.filter((Iterable)RexUtil.fixUp((RexBuilder)rexBuilder, aboveFilters, (List)RelOptUtil.getFieldTypeList((RelDataType)relBuilder.peek().getRowType())));
        call.transformTo(relBuilder.build());
    }

    private List<RexNode> getConjunctions(Filter filter) {
        List conjunctions = RelOptUtil.conjunctions((RexNode)filter.getCondition());
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        for (int i = 0; i < conjunctions.size(); ++i) {
            RexNode node = (RexNode)conjunctions.get(i);
            if (!(node instanceof RexCall)) continue;
            conjunctions.set(i, RelOptUtil.collapseExpandedIsNotDistinctFromExpr((RexCall)((RexCall)node), (RexBuilder)rexBuilder));
        }
        return conjunctions;
    }

    private static boolean classifyFilters(List<RexNode> filters, JoinRelType joinType, boolean pushInto, List<RexNode> joinFilters) {
        ArrayList<RexNode> filtersToRemove = new ArrayList<RexNode>();
        for (RexNode filter : filters) {
            if (joinType.isOuterJoin() || !pushInto) continue;
            if (!joinFilters.contains(filter)) {
                joinFilters.add(filter);
            }
            filtersToRemove.add(filter);
        }
        if (!filtersToRemove.isEmpty()) {
            filters.removeAll(filtersToRemove);
        }
        return !filtersToRemove.isEmpty();
    }

    static void removeRedundantIsNotNullFilters(List<RexNode> joinFilters, JoinRelType joinType, boolean isSqlCompatible) {
        if (joinType != JoinRelType.INNER || !isSqlCompatible) {
            return;
        }
        ImmutableList.Builder isNotNullFiltersBuilder = ImmutableList.builder();
        ImmutableList.Builder equalityFiltersOperandBuilder = ImmutableList.builder();
        joinFilters.stream().filter(joinFilter -> joinFilter instanceof RexCall).forEach(joinFilter -> {
            List operands;
            if (joinFilter.isA(SqlKind.IS_NOT_NULL)) {
                isNotNullFiltersBuilder.add(joinFilter);
            } else if (joinFilter.isA(SqlKind.EQUALS) && (operands = ((RexCall)joinFilter).getOperands()).size() == 2 && operands.stream().noneMatch(Objects::isNull)) {
                equalityFiltersOperandBuilder.add((Object)new Pair(operands.get(0), operands.get(1)));
            }
        });
        ImmutableList equalityFilters = equalityFiltersOperandBuilder.build();
        ImmutableList.Builder removableFilters = ImmutableList.builder();
        for (RexNode isNotNullFilter : isNotNullFiltersBuilder.build()) {
            List operands = ((RexCall)isNotNullFilter).getOperands();
            boolean canDrop = false;
            for (Pair equalityFilterOperands : equalityFilters) {
                if ((equalityFilterOperands.lhs == null || !((RexNode)equalityFilterOperands.lhs).equals(operands.get(0))) && (equalityFilterOperands.rhs == null || !((RexNode)equalityFilterOperands.rhs).equals(operands.get(0)))) continue;
                canDrop = true;
                break;
            }
            if (!canDrop) continue;
            removableFilters.add((Object)isNotNullFilter);
        }
        joinFilters.removeAll((Collection<?>)removableFilters.build());
    }

    public static class FilterIntoJoinExcludePushToChildRule
    extends FilterJoinExcludePushToChildRule<FilterJoinRule.FilterIntoJoinRule.FilterIntoJoinRuleConfig> {
        public FilterIntoJoinExcludePushToChildRule(FilterJoinRule.FilterIntoJoinRule.FilterIntoJoinRuleConfig config) {
            super(config);
        }

        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            Join join = (Join)call.rel(1);
            this.perform(call, filter, join);
        }
    }
}

