/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.google.common.collect.Iterables;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.RelWriter;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.CannotBuildQueryException;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.PartialDruidQuery;

public abstract class DruidRel<T extends DruidRel<?>>
extends AbstractRelNode {
    private final PlannerContext plannerContext;

    protected DruidRel(RelOptCluster cluster, RelTraitSet traitSet, PlannerContext plannerContext) {
        super(cluster, traitSet);
        this.plannerContext = plannerContext;
    }

    @Nullable
    public abstract PartialDruidQuery getPartialDruidQuery();

    public QueryResponse<Object[]> runQuery() {
        return this.getPlannerContext().getQueryMaker().runQuery(this.toDruidQuery(false));
    }

    public abstract T withPartialQuery(PartialDruidQuery var1);

    public boolean isValidDruidQuery() {
        try {
            this.toDruidQueryForExplaining();
            return true;
        }
        catch (CannotBuildQueryException e) {
            return false;
        }
    }

    public abstract DruidQuery toDruidQuery(boolean var1);

    public abstract DruidQuery toDruidQueryForExplaining();

    public PlannerContext getPlannerContext() {
        return this.plannerContext;
    }

    public RelWriter explainTerms(RelWriter pw) {
        throw new UnsupportedOperationException();
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public abstract T asDruidConvention();

    public abstract Set<String> getDataSourceNames();

    public final RelNode unwrapLogicalPlan() {
        return this.accept((RelShuttle)new LogicalPlanUnwrapperShuttle());
    }

    private static class LogicalPlanUnwrapperShuttle
    extends RelShuttleImpl {
        private LogicalPlanUnwrapperShuttle() {
        }

        public RelNode visit(RelNode other) {
            return super.visit(this.visitNode(other));
        }

        private RelNode visitNode(RelNode other) {
            if (other instanceof RelSubset) {
                RelSubset subset = (RelSubset)other;
                return this.visitNode((RelNode)Iterables.getFirst((Iterable)subset.getRels(), null));
            }
            if (other instanceof DruidRel) {
                DruidRel druidRel = (DruidRel)other;
                return druidRel.getPartialDruidQuery().leafRel();
            }
            return other;
        }
    }
}

