/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.virtual.ListFilteredVirtualColumn;
import org.apache.druid.sql.calcite.expression.AliasedOperatorConversion;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.PostAggregatorVisitor;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayAppendOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayConcatOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayContainsOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayLengthOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayOffsetOfOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayOffsetOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayOrdinalOfOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayOrdinalOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayOverlapOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayPrependOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArraySliceOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ArrayToStringOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.StringToArrayOperatorConversion;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class MultiValueStringOperatorConversions {
    public static final SqlOperatorConversion CONTAINS = new Contains();
    public static final SqlOperatorConversion OVERLAP = new Overlap();

    private static List<DruidExpression> harmonizeNullsMvdArg0OperandList(List<DruidExpression> druidExpressions) {
        ArrayList newArgs;
        if (druidExpressions.get(0).isDirectColumnAccess()) {
            newArgs = Lists.newArrayListWithCapacity((int)2);
            newArgs.add(0, DruidExpression.ofFunctionCall(((DruidExpression)druidExpressions.get(0)).getDruidType(), "mv_harmonize_nulls", Collections.singletonList(druidExpressions.get(0))));
            newArgs.add(1, druidExpressions.get(1));
        } else {
            newArgs = druidExpressions;
        }
        return newArgs;
    }

    private MultiValueStringOperatorConversions() {
    }

    public static class FilterNone
    extends ListFilter {
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("MV_FILTER_NONE").operandTypeChecker(OperandTypes.sequence((String)"'MV_FILTER_NONE(string, array)'", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY})})).functionCategory(SqlFunctionCategory.STRING).returnTypeCascadeNullable(SqlTypeName.VARCHAR).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }

        @Override
        boolean isAllowList() {
            return false;
        }
    }

    public static class FilterOnly
    extends ListFilter {
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("MV_FILTER_ONLY").operandTypeChecker(OperandTypes.sequence((String)"'MV_FILTER_ONLY(string, array)'", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY})})).functionCategory(SqlFunctionCategory.STRING).returnTypeCascadeNullable(SqlTypeName.VARCHAR).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }

        @Override
        boolean isAllowList() {
            return true;
        }
    }

    private static abstract class ListFilter
    implements SqlOperatorConversion {
        private ListFilter() {
        }

        abstract boolean isAllowList();

        @Override
        @Nullable
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            RexCall call = (RexCall)rexNode;
            List<DruidExpression> druidExpressions = Expressions.toDruidExpressions(plannerContext, rowSignature, call.getOperands());
            if (druidExpressions == null || druidExpressions.size() != 2) {
                return null;
            }
            DruidExpression.ExpressionGenerator builder = args -> {
                StringBuilder expressionBuilder = this.isAllowList() ? new StringBuilder("filter((x) -> array_contains(") : new StringBuilder("filter((x) -> !array_contains(");
                expressionBuilder.append(((DruidExpression)args.get(1)).getExpression()).append(", x), ").append(((DruidExpression)args.get(0)).getExpression()).append(")");
                return expressionBuilder.toString();
            };
            Expr expr = plannerContext.parseExpression(druidExpressions.get(1).getExpression());
            if (druidExpressions.get(0).isSimpleExtraction() && expr.isLiteral()) {
                Object[] lit = expr.eval(InputBindings.nilBindings()).asArray();
                if (lit == null || lit.length == 0) {
                    return null;
                }
                HashSet literals = Sets.newHashSetWithExpectedSize((int)lit.length);
                for (Object o : lit) {
                    literals.add(Evals.asString((Object)o));
                }
                DruidExpression druidExpression = DruidExpression.ofVirtualColumn(Calcites.getColumnTypeForRelDataType(rexNode.getType()), builder, druidExpressions, (name, outputType, expression, macroTable) -> new ListFilteredVirtualColumn(name, ((DruidExpression)druidExpressions.get(0)).getSimpleExtraction().toDimensionSpec(((DruidExpression)druidExpressions.get(0)).getDirectColumn(), outputType), (Set)literals, Boolean.valueOf(this.isAllowList())));
                if (plannerContext.getJoinExpressionVirtualColumnRegistry() != null) {
                    String virtualColumnName = plannerContext.getJoinExpressionVirtualColumnRegistry().getOrCreateVirtualColumnForExpression(druidExpression, ColumnType.STRING);
                    return DruidExpression.ofColumn(ColumnType.STRING, virtualColumnName);
                }
                return druidExpression;
            }
            return DruidExpression.ofExpression(ColumnType.STRING, builder, druidExpressions);
        }
    }

    private static class Overlap
    extends ArrayOverlapOperatorConversion {
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("MV_OVERLAP").operandTypeChecker(OperandTypes.sequence((String)"'MV_OVERLAP(array, array)'", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})}), OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC})})})).returnTypeInference(ReturnTypes.BOOLEAN_NULLABLE).build();

        private Overlap() {
        }

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }

        @Override
        protected String getFilterExpression(List<DruidExpression> druidExpressions) {
            return super.getFilterExpression(MultiValueStringOperatorConversions.harmonizeNullsMvdArg0OperandList(druidExpressions));
        }

        @Override
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, druidExpressions -> {
                List newArgs = MultiValueStringOperatorConversions.harmonizeNullsMvdArg0OperandList(druidExpressions);
                return DruidExpression.ofFunctionCall(Calcites.getColumnTypeForRelDataType(rexNode.getType()), this.getDruidFunctionName(), newArgs);
            });
        }

        @Override
        @Nullable
        public DruidExpression toDruidExpressionWithPostAggOperands(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, PostAggregatorVisitor postAggregatorVisitor) {
            return OperatorConversions.convertCallWithPostAggOperands(plannerContext, rowSignature, rexNode, operands -> DruidExpression.ofFunctionCall(Calcites.getColumnTypeForRelDataType(rexNode.getType()), this.getDruidFunctionName(), MultiValueStringOperatorConversions.harmonizeNullsMvdArg0OperandList(operands)), postAggregatorVisitor);
        }
    }

    public static class OrdinalOf
    extends AliasedOperatorConversion {
        public OrdinalOf() {
            super(new ArrayOrdinalOfOperatorConversion(), "MV_ORDINAL_OF");
        }
    }

    public static class OffsetOf
    extends AliasedOperatorConversion {
        public OffsetOf() {
            super(new ArrayOffsetOfOperatorConversion(), "MV_OFFSET_OF");
        }
    }

    public static class Length
    extends AliasedOperatorConversion {
        public Length() {
            super(new ArrayLengthOperatorConversion(), "MV_LENGTH");
        }
    }

    public static class MultiStringToString
    extends AliasedOperatorConversion {
        public MultiStringToString() {
            super(new ArrayToStringOperatorConversion(), "MV_TO_STRING");
        }
    }

    public static class StringToMultiString
    extends StringToArrayOperatorConversion {
        public static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("STRING_TO_MV").operandTypeChecker(OperandTypes.sequence((String)"'STRING_TO_MV(string, expr)'", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})})).functionCategory(SqlFunctionCategory.STRING).returnTypeNullable(SqlTypeName.VARCHAR).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }
    }

    public static class Slice
    extends ArraySliceOperatorConversion {
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("MV_SLICE").operandTypeChecker(OperandTypes.or((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.sequence((String)"'MV_SLICE(expr, start)'", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC})}), OperandTypes.sequence((String)"'MV_SLICE(expr, start, end)'", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC})})})).functionCategory(SqlFunctionCategory.STRING).returnTypeNullable(SqlTypeName.VARCHAR).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }
    }

    public static class Ordinal
    extends ArrayOrdinalOperatorConversion {
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("MV_ORDINAL").operandTypeChecker(OperandTypes.sequence((String)"'MV_ORDINAL(array, expr)'", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC})})).functionCategory(SqlFunctionCategory.STRING).returnTypeNullable(SqlTypeName.VARCHAR).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }
    }

    public static class Offset
    extends ArrayOffsetOperatorConversion {
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("MV_OFFSET").operandTypeChecker(OperandTypes.sequence((String)"'MV_OFFSET(array, expr)'", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC})})).functionCategory(SqlFunctionCategory.STRING).returnTypeNullable(SqlTypeName.VARCHAR).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }
    }

    private static class Contains
    extends ArrayContainsOperatorConversion {
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("MV_CONTAINS").operandTypeChecker(OperandTypes.sequence((String)"'MV_CONTAINS(array, array)'", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})}), OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC})})})).returnTypeInference(ReturnTypes.BOOLEAN_NULLABLE).build();

        private Contains() {
        }

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }

        @Override
        protected String getFilterExpression(List<DruidExpression> druidExpressions) {
            return super.getFilterExpression(MultiValueStringOperatorConversions.harmonizeNullsMvdArg0OperandList(druidExpressions));
        }

        @Override
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, druidExpressions -> DruidExpression.ofFunctionCall(Calcites.getColumnTypeForRelDataType(rexNode.getType()), this.getDruidFunctionName(), MultiValueStringOperatorConversions.harmonizeNullsMvdArg0OperandList(druidExpressions)));
        }

        @Override
        @Nullable
        public DruidExpression toDruidExpressionWithPostAggOperands(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, PostAggregatorVisitor postAggregatorVisitor) {
            return OperatorConversions.convertCallWithPostAggOperands(plannerContext, rowSignature, rexNode, operands -> DruidExpression.ofFunctionCall(Calcites.getColumnTypeForRelDataType(rexNode.getType()), this.getDruidFunctionName(), MultiValueStringOperatorConversions.harmonizeNullsMvdArg0OperandList(operands)), postAggregatorVisitor);
        }
    }

    public static class Concat
    extends ArrayConcatOperatorConversion {
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("MV_CONCAT").operandTypeChecker(OperandTypes.sequence((String)"'MV_CONCAT(array, array)'", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})}), OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})})})).functionCategory(SqlFunctionCategory.STRING).returnTypeNullable(SqlTypeName.VARCHAR).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }
    }

    public static class Prepend
    extends ArrayPrependOperatorConversion {
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("MV_PREPEND").operandTypeChecker(OperandTypes.sequence((String)"'MV_PREPEND(expr, array)'", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}), OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})})})).functionCategory(SqlFunctionCategory.STRING).returnTypeNullable(SqlTypeName.VARCHAR).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }
    }

    public static class Append
    extends ArrayAppendOperatorConversion {
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("MV_APPEND").operandTypeChecker(OperandTypes.sequence((String)"'MV_APPEND(array, expr)'", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})})).functionCategory(SqlFunctionCategory.STRING).returnTypeNullable(SqlTypeName.VARCHAR).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }
    }
}

