/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class Aggregation {
    private final List<AggregatorFactory> aggregatorFactories;
    private final PostAggregator postAggregator;

    private Aggregation(List<AggregatorFactory> aggregatorFactories, PostAggregator postAggregator) {
        this.aggregatorFactories = (List)Preconditions.checkNotNull(aggregatorFactories, (Object)"aggregatorFactories");
        this.postAggregator = postAggregator;
        if (aggregatorFactories.isEmpty()) {
            Preconditions.checkArgument((postAggregator != null ? 1 : 0) != 0, (Object)"postAggregator must be present if there are no aggregators");
        }
        if (postAggregator == null) {
            Preconditions.checkArgument((aggregatorFactories.size() == 1 ? 1 : 0) != 0, (Object)"aggregatorFactories.size == 1");
        } else {
            Set dependentFields = postAggregator.getDependentFields();
            for (AggregatorFactory aggregatorFactory : aggregatorFactories) {
                if (dependentFields.contains(aggregatorFactory.getName())) continue;
                throw new IAE("Unused field[%s] in Aggregation", new Object[]{aggregatorFactory.getName()});
            }
        }
        String name = postAggregator != null ? postAggregator.getName() : ((AggregatorFactory)Iterables.getOnlyElement(aggregatorFactories)).getName();
        for (AggregatorFactory aggregatorFactory : aggregatorFactories) {
            if (aggregatorFactory.getName().startsWith(name)) continue;
            throw new IAE("Aggregator[%s] not prefixed under[%s]", new Object[]{aggregatorFactory.getName(), name});
        }
    }

    public static Aggregation create(AggregatorFactory aggregatorFactory) {
        return new Aggregation((List<AggregatorFactory>)ImmutableList.of((Object)aggregatorFactory), null);
    }

    public static Aggregation create(PostAggregator postAggregator) {
        return new Aggregation(Collections.emptyList(), postAggregator);
    }

    public static Aggregation create(List<AggregatorFactory> aggregatorFactories, PostAggregator postAggregator) {
        return new Aggregation(aggregatorFactories, postAggregator);
    }

    public List<String> getRequiredColumns() {
        HashSet columns = new HashSet();
        for (AggregatorFactory agg : this.aggregatorFactories) {
            columns.addAll(agg.requiredFields());
        }
        if (this.postAggregator != null) {
            columns.addAll(this.postAggregator.getDependentFields());
        }
        return ImmutableList.copyOf(columns);
    }

    public List<AggregatorFactory> getAggregatorFactories() {
        return this.aggregatorFactories;
    }

    @Nullable
    public PostAggregator getPostAggregator() {
        return this.postAggregator;
    }

    public String getOutputName() {
        return this.postAggregator != null ? this.postAggregator.getName() : ((AggregatorFactory)Iterables.getOnlyElement(this.aggregatorFactories)).getName();
    }

    public Aggregation filter(RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry, DimFilter filter) {
        if (filter == null) {
            return this;
        }
        if (this.postAggregator != null) {
            Set dependentFields = this.postAggregator.getDependentFields();
            HashSet<String> aggregatorNames = new HashSet<String>();
            for (AggregatorFactory aggregatorFactory : this.aggregatorFactories) {
                aggregatorNames.add(aggregatorFactory.getName());
            }
            for (String field : dependentFields) {
                if (aggregatorNames.contains(field)) continue;
                throw new ISE("Cannot filter an Aggregation that does not contain its inputs: %s", new Object[]{this});
            }
        }
        DimFilter baseOptimizedFilter = Filtration.create(filter).optimizeFilterOnly(virtualColumnRegistry.getFullRowSignature()).getDimFilter();
        ArrayList<AggregatorFactory> newAggregators = new ArrayList<AggregatorFactory>();
        for (AggregatorFactory agg : this.aggregatorFactories) {
            if (agg instanceof FilteredAggregatorFactory) {
                FilteredAggregatorFactory filteredAgg = (FilteredAggregatorFactory)agg;
                newAggregators.add((AggregatorFactory)new FilteredAggregatorFactory(filteredAgg.getAggregator(), Filtration.create((DimFilter)new AndDimFilter((List)ImmutableList.of((Object)filteredAgg.getFilter(), (Object)baseOptimizedFilter))).optimizeFilterOnly(virtualColumnRegistry.getFullRowSignature()).getDimFilter()));
                continue;
            }
            newAggregators.add((AggregatorFactory)new FilteredAggregatorFactory(agg, baseOptimizedFilter));
        }
        return new Aggregation(newAggregators, this.postAggregator);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Aggregation that = (Aggregation)o;
        return Objects.equals(this.aggregatorFactories, that.aggregatorFactories) && Objects.equals(this.postAggregator, that.postAggregator);
    }

    public int hashCode() {
        return Objects.hash(this.aggregatorFactories, this.postAggregator);
    }

    public String toString() {
        return "Aggregation{aggregatorFactories=" + this.aggregatorFactories + ", postAggregator=" + this.postAggregator + '}';
    }
}

