/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import com.google.common.annotations.VisibleForTesting;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.AbstractStatement;
import org.apache.druid.sql.SqlExecutionReporter;
import org.apache.druid.sql.SqlLifecycleManager;
import org.apache.druid.sql.SqlQueryPlus;
import org.apache.druid.sql.SqlRowTransformer;
import org.apache.druid.sql.SqlToolbox;
import org.apache.druid.sql.calcite.planner.DruidPlanner;
import org.apache.druid.sql.calcite.planner.PlannerResult;
import org.apache.druid.sql.calcite.planner.PrepareResult;

public class DirectStatement
extends AbstractStatement
implements SqlLifecycleManager.Cancelable {
    private static final Logger log = new Logger(DirectStatement.class);
    protected PrepareResult prepareResult;
    protected ResultSet resultSet;
    private volatile State state = State.START;

    public DirectStatement(SqlToolbox lifecycleToolbox, SqlQueryPlus queryPlus, String remoteAddress) {
        super(lifecycleToolbox, queryPlus, remoteAddress);
    }

    public DirectStatement(SqlToolbox lifecycleToolbox, SqlQueryPlus sqlRequest) {
        super(lifecycleToolbox, sqlRequest, null);
    }

    public QueryResponse<Object[]> execute() {
        return this.plan().run();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet plan() {
        if (this.state != State.START) {
            throw new ISE("Can plan a query only once.", new Object[0]);
        }
        long planningStartNanos = System.nanoTime();
        try (DruidPlanner planner = this.sqlToolbox.plannerFactory.createPlanner(this.sqlToolbox.engine, this.queryPlus.sql(), this.queryContext, this.hook);){
            this.validate(planner);
            this.authorize(planner, this.authorizer());
            this.sqlToolbox.sqlLifecycleManager.add(this.sqlQueryId(), this);
            this.transition(State.PREPARED);
            this.resultSet = this.createResultSet(this.createPlan(planner));
            this.prepareResult = planner.prepareResult();
            this.transition(State.PREPARED);
            this.reporter.planningTimeNanos(System.nanoTime() - planningStartNanos);
            ResultSet resultSet = this.resultSet;
            return resultSet;
        }
        catch (RelOptPlanner.CannotPlanException e) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.DEVELOPER).ofCategory(DruidException.Category.UNCATEGORIZED).build((Throwable)e, "Problem planning SQL query", new Object[0]);
        }
        catch (RuntimeException e) {
            this.state = State.FAILED;
            this.reporter.failed(e);
            throw e;
        }
        catch (AssertionError e) {
            this.state = State.FAILED;
            this.reporter.failed((Throwable)((Object)e));
            throw InvalidSqlInput.exception((Throwable)((Object)e), (String)"Calcite assertion violated: [%s]", (Object[])new Object[]{((Throwable)((Object)e)).getMessage()});
        }
    }

    @VisibleForTesting
    protected PlannerResult createPlan(DruidPlanner planner) {
        return planner.plan();
    }

    @VisibleForTesting
    protected ResultSet createResultSet(PlannerResult plannerResult) {
        return new ResultSet(plannerResult);
    }

    public PrepareResult prepareResult() {
        return this.prepareResult;
    }

    private void transition(State newState) {
        if (this.state == State.CANCELLED) {
            throw new QueryInterruptedException("Query cancelled", StringUtils.format((String)"Query is canceled [%s]", (Object[])new Object[]{this.sqlQueryId()}), null, null);
        }
        this.state = newState;
    }

    @Override
    public void cancel() {
        if (this.state == State.CLOSED) {
            return;
        }
        this.state = State.CANCELLED;
        CopyOnWriteArrayList<String> nativeQueryIds = this.plannerContext.getNativeQueryIds();
        for (String nativeQueryId : nativeQueryIds) {
            log.debug("Canceling native query [%s]", new Object[]{nativeQueryId});
            this.sqlToolbox.queryScheduler.cancelQuery(nativeQueryId);
        }
    }

    @Override
    public void close() {
        if (this.state != State.START && this.state != State.CLOSED) {
            super.close();
            this.state = State.CLOSED;
        }
    }

    @Override
    public void closeWithError(Throwable e) {
        if (this.state != State.START && this.state != State.CLOSED) {
            super.closeWithError(e);
            this.state = State.CLOSED;
        }
    }

    @Override
    public void closeQuietly() {
        this.sqlToolbox.sqlLifecycleManager.remove(this.sqlQueryId(), this);
        super.closeQuietly();
    }

    private static enum State {
        START,
        PREPARED,
        RAN,
        CANCELLED,
        FAILED,
        CLOSED;

    }

    public class ResultSet
    implements SqlLifecycleManager.Cancelable {
        private final PlannerResult plannerResult;

        public ResultSet(PlannerResult plannerResult) {
            this.plannerResult = plannerResult;
        }

        public SqlQueryPlus query() {
            return DirectStatement.this.queryPlus;
        }

        public boolean runnable() {
            return this.plannerResult != null && this.plannerResult.runnable();
        }

        public QueryResponse<Object[]> run() {
            try {
                DirectStatement.this.transition(State.RAN);
                return this.plannerResult.run();
            }
            catch (RuntimeException e) {
                DirectStatement.this.reporter.failed(e);
                throw e;
            }
        }

        public SqlRowTransformer createRowTransformer() {
            return new SqlRowTransformer(DirectStatement.this.plannerContext.getTimeZone(), this.plannerResult.rowType());
        }

        public SqlExecutionReporter reporter() {
            return DirectStatement.this.reporter;
        }

        @Override
        public Set<ResourceAction> resources() {
            return DirectStatement.this.resources();
        }

        @Override
        public void cancel() {
            DirectStatement.this.cancel();
        }

        public void close() {
            DirectStatement.this.close();
        }
    }
}

