/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.sql.http.ArrayWriter;
import org.apache.druid.sql.http.ResultFormat;

public class ArrayLinesWriter
implements ResultFormat.Writer {
    private final SerializerProvider serializers;
    private final JsonGenerator jsonGenerator;
    private final OutputStream outputStream;

    public ArrayLinesWriter(OutputStream outputStream, ObjectMapper jsonMapper) throws IOException {
        this.serializers = jsonMapper.getSerializerProviderInstance();
        this.outputStream = outputStream;
        this.jsonGenerator = jsonMapper.writer().getFactory().createGenerator(outputStream);
        this.jsonGenerator.setRootValueSeparator((SerializableString)new SerializedString("\n"));
    }

    @Override
    public void writeResponseStart() {
    }

    @Override
    public void writeResponseEnd() throws IOException {
        this.jsonGenerator.flush();
        this.outputStream.write(new byte[]{10, 10});
        this.outputStream.flush();
    }

    @Override
    public void writeHeader(RelDataType rowType, boolean includeTypes, boolean includeSqlTypes) throws IOException {
        ArrayWriter.writeHeader(this.jsonGenerator, rowType, includeTypes, includeSqlTypes);
    }

    @Override
    public void writeRowStart() throws IOException {
        this.jsonGenerator.writeStartArray();
    }

    @Override
    public void writeRowField(String name, @Nullable Object value) throws IOException {
        JacksonUtils.writeObjectUsingSerializerProvider((JsonGenerator)this.jsonGenerator, (SerializerProvider)this.serializers, (Object)value);
    }

    @Override
    public void writeRowEnd() throws IOException {
        this.jsonGenerator.writeEndArray();
    }

    @Override
    public void close() throws IOException {
        this.jsonGenerator.close();
    }
}

