/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.table;

import com.google.common.base.Preconditions;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.table.DruidTable;

public class InlineTable
extends DruidTable {
    private final DataSource dataSource;

    public InlineTable(InlineDataSource dataSource, RowSignature rowSignature) {
        super(rowSignature);
        this.dataSource = (DataSource)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public boolean isJoinable() {
        return false;
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable table) {
        return LogicalTableScan.create((RelOptCluster)context.getCluster(), (RelOptTable)table);
    }

    public String toString() {
        return "DatasourceMetadata{dataSource=" + this.dataSource + ", rowSignature=" + this.getRowSignature() + '}';
    }
}

