/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.druid.sql.calcite.external.ExternalTableScan;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.DruidConvention;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.DruidRel;
import org.apache.druid.sql.calcite.rel.PartialDruidQuery;
import org.apache.druid.sql.calcite.table.DruidTable;

public class DruidQueryRel
extends DruidRel<DruidQueryRel> {
    @Nullable
    private final RelOptTable table;
    private final DruidTable druidTable;
    private final PartialDruidQuery partialQuery;

    private DruidQueryRel(RelOptCluster cluster, RelTraitSet traitSet, @Nullable RelOptTable table, DruidTable druidTable, PlannerContext plannerContext, PartialDruidQuery partialQuery) {
        super(cluster, traitSet, plannerContext);
        this.table = table;
        this.druidTable = (DruidTable)Preconditions.checkNotNull((Object)druidTable, (Object)"druidTable");
        this.partialQuery = (PartialDruidQuery)Preconditions.checkNotNull((Object)partialQuery, (Object)"partialQuery");
    }

    public static DruidQueryRel scanTable(LogicalTableScan scanRel, RelOptTable table, DruidTable druidTable, PlannerContext plannerContext) {
        return new DruidQueryRel(scanRel.getCluster(), scanRel.getCluster().traitSetOf((RelTrait)Convention.NONE), (RelOptTable)Preconditions.checkNotNull((Object)table, (Object)"table"), druidTable, plannerContext, PartialDruidQuery.create((RelNode)scanRel));
    }

    public static DruidQueryRel scanExternal(ExternalTableScan scanRel, PlannerContext plannerContext) {
        return new DruidQueryRel(scanRel.getCluster(), scanRel.getCluster().traitSetOf((RelTrait)Convention.NONE), null, scanRel.getDruidTable(), plannerContext, PartialDruidQuery.create((RelNode)scanRel));
    }

    public static DruidQueryRel scanValues(LogicalValues valuesRel, DruidTable druidTable, PlannerContext plannerContext) {
        return new DruidQueryRel(valuesRel.getCluster(), valuesRel.getTraitSet(), null, druidTable, plannerContext, PartialDruidQuery.create((RelNode)valuesRel));
    }

    @Override
    public DruidQuery toDruidQuery(boolean finalizeAggregations) {
        return this.partialQuery.build(this.druidTable.getDataSource(), this.druidTable.getRowSignature(), this.getPlannerContext(), this.getCluster().getRexBuilder(), finalizeAggregations);
    }

    @Override
    public DruidQuery toDruidQueryForExplaining() {
        return this.toDruidQuery(false);
    }

    @Override
    public DruidQueryRel asDruidConvention() {
        return new DruidQueryRel(this.getCluster(), this.getTraitSet().replace((RelTrait)DruidConvention.instance()), this.table, this.druidTable, this.getPlannerContext(), this.partialQuery);
    }

    @Override
    public Set<String> getDataSourceNames() {
        return this.druidTable.getDataSource().getTableNames();
    }

    @Override
    public PartialDruidQuery getPartialDruidQuery() {
        return this.partialQuery;
    }

    @Override
    public DruidQueryRel withPartialQuery(PartialDruidQuery newQueryBuilder) {
        return new DruidQueryRel(this.getCluster(), this.getTraitSet().plusAll(newQueryBuilder.getRelTraits()), this.table, this.druidTable, this.getPlannerContext(), newQueryBuilder);
    }

    public DruidTable getDruidTable() {
        return this.druidTable;
    }

    public RelOptTable getTable() {
        return this.table;
    }

    protected RelDataType deriveRowType() {
        return this.partialQuery.getRowType();
    }

    public RelWriter explainTerms(RelWriter pw) {
        String queryString;
        DruidQuery druidQuery = this.toDruidQueryForExplaining();
        try {
            queryString = this.getPlannerContext().getJsonMapper().writeValueAsString(druidQuery.getQuery());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return pw.item("query", (Object)queryString).item("signature", (Object)druidQuery.getOutputRowSignature());
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeCost(this.partialQuery.estimateCost(), 0.0, 0.0);
    }
}

