/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongMinAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.SimpleLongAggregatorFactory;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.having.DimFilterHavingSpec;
import org.apache.druid.query.groupby.having.HavingSpec;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.topn.DimensionTopNMetricSpec;
import org.apache.druid.query.topn.InvertedTopNMetricSpec;
import org.apache.druid.query.topn.NumericTopNMetricSpec;
import org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.RowBasedStorageAdapter;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.DimensionExpression;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.OffsetLimit;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.CannotBuildQueryException;
import org.apache.druid.sql.calcite.rel.Grouping;
import org.apache.druid.sql.calcite.rel.PartialDruidQuery;
import org.apache.druid.sql.calcite.rel.Projection;
import org.apache.druid.sql.calcite.rel.Sorting;
import org.apache.druid.sql.calcite.rel.Subtotals;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;
import org.apache.druid.sql.calcite.rule.GroupByRules;
import org.apache.druid.sql.calcite.run.EngineFeature;
import org.apache.druid.sql.calcite.table.RowSignatures;
import org.joda.time.Interval;

public class DruidQuery {
    public static final String CTX_SCAN_SIGNATURE = "scanSignature";
    private static final int MAX_TIME_GRAINS_NON_DRUID_TABLE = 100000;
    private final DataSource dataSource;
    private final PlannerContext plannerContext;
    @Nullable
    private final DimFilter filter;
    @Nullable
    private final Projection selectProjection;
    @Nullable
    private final Grouping grouping;
    @Nullable
    private final Sorting sorting;
    private final Query<?> query;
    private final RowSignature outputRowSignature;
    private final RelDataType outputRowType;
    private final VirtualColumnRegistry virtualColumnRegistry;
    private final RowSignature sourceRowSignature;

    private DruidQuery(DataSource dataSource, PlannerContext plannerContext, @Nullable DimFilter filter, @Nullable Projection selectProjection, @Nullable Grouping grouping, @Nullable Sorting sorting, RowSignature sourceRowSignature, RelDataType outputRowType, VirtualColumnRegistry virtualColumnRegistry) {
        this.dataSource = (DataSource)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        this.plannerContext = (PlannerContext)Preconditions.checkNotNull((Object)plannerContext, (Object)"plannerContext");
        this.filter = filter;
        this.selectProjection = selectProjection;
        this.grouping = grouping;
        this.sorting = sorting;
        this.sourceRowSignature = sourceRowSignature;
        this.outputRowSignature = DruidQuery.computeOutputRowSignature(sourceRowSignature, selectProjection, grouping, sorting);
        this.outputRowType = (RelDataType)Preconditions.checkNotNull((Object)outputRowType, (Object)"outputRowType");
        this.virtualColumnRegistry = (VirtualColumnRegistry)Preconditions.checkNotNull((Object)virtualColumnRegistry, (Object)"virtualColumnRegistry");
        this.query = this.computeQuery();
    }

    public static DruidQuery fromPartialQuery(PartialDruidQuery partialQuery, DataSource dataSource, RowSignature sourceRowSignature, PlannerContext plannerContext, RexBuilder rexBuilder, boolean finalizeAggregations, @Nullable VirtualColumnRegistry virtualColumnRegistry) {
        RelDataType outputRowType = partialQuery.leafRel().getRowType();
        if (virtualColumnRegistry == null) {
            virtualColumnRegistry = VirtualColumnRegistry.create(sourceRowSignature, plannerContext.getExprMacroTable(), plannerContext.getPlannerConfig().isForceExpressionVirtualColumns());
        }
        DimFilter filter = partialQuery.getWhereFilter() != null ? (DimFilter)Preconditions.checkNotNull((Object)DruidQuery.computeWhereFilter(partialQuery, plannerContext, sourceRowSignature, virtualColumnRegistry)) : null;
        Projection selectProjection = partialQuery.getSelectProject() != null && partialQuery.getAggregate() == null ? (Projection)Preconditions.checkNotNull((Object)DruidQuery.computeSelectProjection(partialQuery, plannerContext, DruidQuery.computeOutputRowSignature(sourceRowSignature, null, null, null), virtualColumnRegistry)) : null;
        Grouping grouping = partialQuery.getAggregate() != null ? (Grouping)Preconditions.checkNotNull((Object)DruidQuery.computeGrouping(partialQuery, plannerContext, DruidQuery.computeOutputRowSignature(sourceRowSignature, null, null, null), virtualColumnRegistry, rexBuilder, finalizeAggregations)) : null;
        Sorting sorting = partialQuery.getSort() != null ? (Sorting)Preconditions.checkNotNull((Object)DruidQuery.computeSorting(partialQuery, plannerContext, DruidQuery.computeOutputRowSignature(sourceRowSignature, selectProjection, grouping, null), partialQuery.getAggregate() != null ? null : virtualColumnRegistry)) : null;
        return new DruidQuery(dataSource, plannerContext, filter, selectProjection, grouping, sorting, sourceRowSignature, outputRowType, virtualColumnRegistry);
    }

    @Nonnull
    private static DimFilter computeWhereFilter(PartialDruidQuery partialQuery, PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry) {
        return DruidQuery.getDimFilter(plannerContext, rowSignature, virtualColumnRegistry, partialQuery.getWhereFilter());
    }

    @Nullable
    private static DimFilter computeHavingFilter(PartialDruidQuery partialQuery, PlannerContext plannerContext, RowSignature aggregateSignature) {
        Filter havingFilter = partialQuery.getHavingFilter();
        if (havingFilter == null) {
            return null;
        }
        return DruidQuery.getDimFilter(plannerContext, aggregateSignature, null, havingFilter);
    }

    @Nonnull
    private static DimFilter getDimFilter(PlannerContext plannerContext, RowSignature rowSignature, @Nullable VirtualColumnRegistry virtualColumnRegistry, Filter filter) {
        RexNode condition = filter.getCondition();
        DimFilter dimFilter = Expressions.toFilter(plannerContext, rowSignature, virtualColumnRegistry, condition);
        if (dimFilter == null) {
            throw new CannotBuildQueryException((RelNode)filter, condition);
        }
        return dimFilter;
    }

    @Nonnull
    private static Projection computeSelectProjection(PartialDruidQuery partialQuery, PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry) {
        Project project = (Project)Preconditions.checkNotNull((Object)partialQuery.getSelectProject(), (Object)"selectProject");
        if (partialQuery.getAggregate() != null) {
            throw new ISE("Cannot have both 'selectProject' and 'aggregate', how can this be?", new Object[0]);
        }
        return Projection.preAggregation(project, plannerContext, rowSignature, virtualColumnRegistry);
    }

    @Nonnull
    private static Grouping computeGrouping(PartialDruidQuery partialQuery, PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry, RexBuilder rexBuilder, boolean finalizeAggregations) {
        Aggregate aggregate = (Aggregate)Preconditions.checkNotNull((Object)partialQuery.getAggregate(), (Object)"aggregate");
        Project aggregateProject = partialQuery.getAggregateProject();
        List<DimensionExpression> dimensions = DruidQuery.computeDimensions(partialQuery, plannerContext, rowSignature, virtualColumnRegistry);
        Subtotals subtotals = DruidQuery.computeSubtotals(partialQuery, rowSignature);
        List<Aggregation> aggregations = DruidQuery.computeAggregations(partialQuery, plannerContext, rowSignature, virtualColumnRegistry, rexBuilder, finalizeAggregations);
        RowSignature aggregateRowSignature = RowSignatures.fromRelDataType((List<String>)ImmutableList.copyOf((Iterator)Iterators.concat(dimensions.stream().map(DimensionExpression::getOutputName).iterator(), aggregations.stream().map(Aggregation::getOutputName).iterator())), aggregate.getRowType());
        DimFilter havingFilter = DruidQuery.computeHavingFilter(partialQuery, plannerContext, aggregateRowSignature);
        Grouping grouping = Grouping.create(dimensions, subtotals, aggregations, havingFilter, aggregateRowSignature);
        if (aggregateProject == null) {
            return grouping;
        }
        return grouping.applyProject(plannerContext, aggregateProject);
    }

    private static List<DimensionExpression> computeDimensions(PartialDruidQuery partialQuery, PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry) {
        Aggregate aggregate = (Aggregate)Preconditions.checkNotNull((Object)partialQuery.getAggregate());
        ArrayList<DimensionExpression> dimensions = new ArrayList<DimensionExpression>();
        String outputNamePrefix = Calcites.findUnusedPrefixForDigits("d", rowSignature.getColumnNames());
        int outputNameCounter = 0;
        Iterator iterator = aggregate.getGroupSet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            RexNode rexNode = Expressions.fromFieldAccess(rowSignature, partialQuery.getSelectProject(), i);
            DruidExpression druidExpression = Expressions.toDruidExpression(plannerContext, rowSignature, rexNode);
            if (druidExpression == null) {
                throw new CannotBuildQueryException((RelNode)aggregate, rexNode);
            }
            RelDataType dataType = rexNode.getType();
            ColumnType outputType = Calcites.getColumnTypeForRelDataType(dataType);
            if (Types.isNullOr((TypeSignature)outputType, (TypeDescriptor)ValueType.COMPLEX)) {
                plannerContext.setPlanningError("SQL requires a group-by on a column of type %s that is unsupported.", outputType);
                throw new CannotBuildQueryException((RelNode)aggregate, rexNode);
            }
            String dimOutputName = outputNamePrefix + outputNameCounter++;
            if (!druidExpression.isSimpleExtraction()) {
                String virtualColumn = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(druidExpression, dataType);
                dimensions.add(DimensionExpression.ofVirtualColumn(virtualColumn, dimOutputName, druidExpression, outputType));
                continue;
            }
            dimensions.add(DimensionExpression.ofSimpleColumn(dimOutputName, druidExpression, outputType));
        }
        return dimensions;
    }

    private static Subtotals computeSubtotals(PartialDruidQuery partialQuery, RowSignature rowSignature) {
        Aggregate aggregate = partialQuery.getAggregate();
        int[] dimBitMapping = partialQuery.getSelectProject() != null ? new int[partialQuery.getSelectProject().getRowType().getFieldCount()] : new int[rowSignature.size()];
        int i = 0;
        Iterator iterator = aggregate.getGroupSet().iterator();
        while (iterator.hasNext()) {
            int dimBit = (Integer)iterator.next();
            dimBitMapping[dimBit] = i++;
        }
        ArrayList<IntList> subtotals = new ArrayList<IntList>();
        for (ImmutableBitSet groupSet : aggregate.getGroupSets()) {
            IntArrayList subtotal = new IntArrayList();
            Iterator iterator2 = groupSet.iterator();
            while (iterator2.hasNext()) {
                int dimBit = (Integer)iterator2.next();
                subtotal.add(dimBitMapping[dimBit]);
            }
            subtotals.add((IntList)subtotal);
        }
        return new Subtotals(subtotals);
    }

    private static List<Aggregation> computeAggregations(PartialDruidQuery partialQuery, PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry, RexBuilder rexBuilder, boolean finalizeAggregations) {
        Aggregate aggregate = (Aggregate)Preconditions.checkNotNull((Object)partialQuery.getAggregate());
        ArrayList<Aggregation> aggregations = new ArrayList<Aggregation>();
        String outputNamePrefix = Calcites.findUnusedPrefixForDigits("a", rowSignature.getColumnNames());
        for (int i = 0; i < aggregate.getAggCallList().size(); ++i) {
            String aggName = outputNamePrefix + i;
            AggregateCall aggCall = (AggregateCall)aggregate.getAggCallList().get(i);
            Aggregation aggregation = GroupByRules.translateAggregateCall(plannerContext, rowSignature, virtualColumnRegistry, rexBuilder, partialQuery.getSelectProject(), aggregations, aggName, aggCall, finalizeAggregations);
            if (aggregation == null) {
                if (null == plannerContext.getPlanningError()) {
                    plannerContext.setPlanningError("Aggregation [%s] is not supported", aggCall);
                }
                throw new CannotBuildQueryException((RelNode)aggregate, aggCall);
            }
            aggregations.add(aggregation);
        }
        return aggregations;
    }

    @Nonnull
    private static Sorting computeSorting(PartialDruidQuery partialQuery, PlannerContext plannerContext, RowSignature rowSignature, @Nullable VirtualColumnRegistry virtualColumnRegistry) {
        Projection projection;
        Sort sort = (Sort)Preconditions.checkNotNull((Object)partialQuery.getSort(), (Object)"sort");
        Project sortProject = partialQuery.getSortProject();
        OffsetLimit offsetLimit = OffsetLimit.fromSort(sort);
        ArrayList<OrderByColumnSpec> orderBys = new ArrayList<OrderByColumnSpec>(sort.getChildExps().size());
        for (int sortKey = 0; sortKey < sort.getChildExps().size(); ++sortKey) {
            OrderByColumnSpec.Direction direction;
            RexNode sortExpression = (RexNode)sort.getChildExps().get(sortKey);
            RelFieldCollation collation = (RelFieldCollation)sort.getCollation().getFieldCollations().get(sortKey);
            if (collation.getDirection() == RelFieldCollation.Direction.ASCENDING) {
                direction = OrderByColumnSpec.Direction.ASCENDING;
            } else if (collation.getDirection() == RelFieldCollation.Direction.DESCENDING) {
                direction = OrderByColumnSpec.Direction.DESCENDING;
            } else {
                throw new ISE("Don't know what to do with direction[%s]", new Object[]{collation.getDirection()});
            }
            SqlTypeName sortExpressionType = sortExpression.getType().getSqlTypeName();
            StringComparator comparator = SqlTypeName.NUMERIC_TYPES.contains(sortExpressionType) || SqlTypeName.TIMESTAMP == sortExpressionType || SqlTypeName.DATE == sortExpressionType ? StringComparators.NUMERIC : StringComparators.LEXICOGRAPHIC;
            if (!sortExpression.isA(SqlKind.INPUT_REF)) {
                throw new CannotBuildQueryException((RelNode)sort, sortExpression);
            }
            RexInputRef ref = (RexInputRef)sortExpression;
            String fieldName = rowSignature.getColumnName(ref.getIndex());
            orderBys.add(new OrderByColumnSpec(fieldName, direction, comparator));
        }
        if (sortProject == null) {
            projection = null;
        } else if (partialQuery.getAggregate() == null) {
            if (virtualColumnRegistry == null) {
                throw new ISE("Must provide 'virtualColumnRegistry' for pre-aggregation Projection!", new Object[0]);
            }
            projection = Projection.preAggregation(sortProject, plannerContext, rowSignature, virtualColumnRegistry);
        } else {
            projection = Projection.postAggregation(sortProject, plannerContext, rowSignature, "s");
        }
        return Sorting.create(orderBys, offsetLimit, projection);
    }

    private static RowSignature computeOutputRowSignature(RowSignature sourceRowSignature, @Nullable Projection selectProjection, @Nullable Grouping grouping, @Nullable Sorting sorting) {
        if (sorting != null && sorting.getProjection() != null) {
            return sorting.getProjection().getOutputRowSignature();
        }
        if (grouping != null) {
            Preconditions.checkState((selectProjection == null ? 1 : 0) != 0, (Object)"Cannot have both 'grouping' and 'selectProjection'");
            return grouping.getOutputRowSignature();
        }
        if (selectProjection != null) {
            return selectProjection.getOutputRowSignature();
        }
        return sourceRowSignature;
    }

    private VirtualColumns getVirtualColumns(boolean includeDimensions) {
        HashSet<Object> virtualColumns = new HashSet<Object>();
        HashSet specialized = new HashSet();
        boolean forceExpressionVirtualColumns = this.plannerContext.getPlannerConfig().isForceExpressionVirtualColumns();
        this.virtualColumnRegistry.visitAllSubExpressions(expression -> {
            if (!forceExpressionVirtualColumns && expression.getType() == DruidExpression.NodeType.SPECIALIZED) {
                String name = this.virtualColumnRegistry.getOrCreateVirtualColumnForExpression(expression, expression.getDruidType());
                specialized.add(name);
                return DruidExpression.ofColumn(expression.getDruidType(), name);
            }
            return expression;
        });
        if (this.filter != null) {
            for (String string : this.filter.getRequiredColumns()) {
                if (!this.virtualColumnRegistry.isVirtualColumnDefined(string)) continue;
                virtualColumns.add(this.virtualColumnRegistry.getVirtualColumn(string));
            }
        }
        if (this.selectProjection != null) {
            for (String string : this.selectProjection.getVirtualColumns()) {
                if (!this.virtualColumnRegistry.isVirtualColumnDefined(string)) continue;
                virtualColumns.add(this.virtualColumnRegistry.getVirtualColumn(string));
            }
        }
        if (this.grouping != null) {
            if (includeDimensions) {
                for (DimensionExpression dimensionExpression : this.grouping.getDimensions()) {
                    if (!this.virtualColumnRegistry.isVirtualColumnDefined(dimensionExpression.getVirtualColumn())) continue;
                    virtualColumns.add(this.virtualColumnRegistry.getVirtualColumn(dimensionExpression.getVirtualColumn()));
                }
            }
            for (Aggregation aggregation : this.grouping.getAggregations()) {
                virtualColumns.addAll(this.virtualColumnRegistry.getAllVirtualColumns(aggregation.getRequiredColumns()));
            }
        }
        if (this.sorting != null && this.sorting.getProjection() != null && this.grouping == null) {
            for (String string : this.sorting.getProjection().getVirtualColumns()) {
                if (!this.virtualColumnRegistry.isVirtualColumnDefined(string)) continue;
                virtualColumns.add(this.virtualColumnRegistry.getVirtualColumn(string));
            }
        }
        if (this.dataSource instanceof JoinDataSource) {
            for (String string : ((JoinDataSource)this.dataSource).getVirtualColumnCandidates()) {
                if (!this.virtualColumnRegistry.isVirtualColumnDefined(string)) continue;
                virtualColumns.add(this.virtualColumnRegistry.getVirtualColumn(string));
            }
        }
        for (String string : specialized) {
            if (!this.virtualColumnRegistry.isVirtualColumnDefined(string)) continue;
            virtualColumns.add(this.virtualColumnRegistry.getVirtualColumn(string));
        }
        ArrayList<VirtualColumn> columns = new ArrayList<VirtualColumn>(virtualColumns);
        columns.sort(Comparator.comparing(VirtualColumn::getOutputName));
        return VirtualColumns.create(columns);
    }

    @VisibleForTesting
    static Pair<DataSource, Filtration> getFiltration(DataSource dataSource, DimFilter filter, VirtualColumnRegistry virtualColumnRegistry, JoinableFactoryWrapper joinableFactoryWrapper) {
        if (!(dataSource instanceof JoinDataSource)) {
            return Pair.of((Object)dataSource, (Object)DruidQuery.toFiltration(filter, virtualColumnRegistry));
        }
        JoinDataSource joinDataSource = (JoinDataSource)dataSource;
        if (joinDataSource.getLeftFilter() == null) {
            return Pair.of((Object)dataSource, (Object)DruidQuery.toFiltration(filter, virtualColumnRegistry));
        }
        Filtration leftFiltration = Filtration.create(joinDataSource.getLeftFilter()).optimize(virtualColumnRegistry.getFullRowSignature());
        Filtration queryFiltration = Filtration.create(filter, leftFiltration.getIntervals()).optimize(virtualColumnRegistry.getFullRowSignature());
        JoinDataSource newDataSource = JoinDataSource.create((DataSource)joinDataSource.getLeft(), (DataSource)joinDataSource.getRight(), (String)joinDataSource.getRightPrefix(), (JoinConditionAnalysis)joinDataSource.getConditionAnalysis(), (JoinType)joinDataSource.getJoinType(), (DimFilter)leftFiltration.getDimFilter(), (JoinableFactoryWrapper)joinableFactoryWrapper);
        return Pair.of((Object)newDataSource, (Object)queryFiltration);
    }

    private static Filtration toFiltration(DimFilter filter, VirtualColumnRegistry virtualColumnRegistry) {
        return Filtration.create(filter).optimize(virtualColumnRegistry.getFullRowSignature());
    }

    private static boolean canUseQueryGranularity(DataSource dataSource, Filtration filtration, Granularity queryGranularity) {
        if (Granularities.ALL.equals(queryGranularity)) {
            return true;
        }
        if (DataSourceAnalysis.forDataSource((DataSource)dataSource).isConcreteTableBased()) {
            return true;
        }
        for (Interval filtrationInterval : filtration.getIntervals()) {
            if (!RowBasedStorageAdapter.isQueryGranularityAllowed((Interval)filtrationInterval, (Granularity)queryGranularity)) {
                return false;
            }
            Interval firstBucket = queryGranularity.bucket(filtrationInterval.getStart());
            long estimatedNumBuckets = filtrationInterval.toDurationMillis() / firstBucket.toDurationMillis();
            if (estimatedNumBuckets <= 100000L) continue;
            return false;
        }
        return true;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Nullable
    public Grouping getGrouping() {
        return this.grouping;
    }

    public RelDataType getOutputRowType() {
        return this.outputRowType;
    }

    public RowSignature getOutputRowSignature() {
        return this.outputRowSignature;
    }

    public Query<?> getQuery() {
        return this.query;
    }

    private Query<?> computeQuery() {
        GroupByQuery outerQuery;
        if (this.dataSource instanceof QueryDataSource && (outerQuery = this.toGroupByQuery()) != null) {
            return outerQuery;
        }
        TimeBoundaryQuery timeBoundaryQuery = this.toTimeBoundaryQuery();
        if (timeBoundaryQuery != null) {
            return timeBoundaryQuery;
        }
        TimeseriesQuery tsQuery = this.toTimeseriesQuery();
        if (tsQuery != null) {
            return tsQuery;
        }
        TopNQuery topNQuery = this.toTopNQuery();
        if (topNQuery != null) {
            return topNQuery;
        }
        GroupByQuery groupByQuery = this.toGroupByQuery();
        if (groupByQuery != null) {
            return groupByQuery;
        }
        ScanQuery scanQuery = this.toScanQuery();
        if (scanQuery != null) {
            return scanQuery;
        }
        throw new CannotBuildQueryException("Cannot convert query parts into an actual query");
    }

    @Nullable
    private TimeBoundaryQuery toTimeBoundaryQuery() {
        if (!this.plannerContext.engineHasFeature(EngineFeature.TIME_BOUNDARY_QUERY) || this.grouping == null || this.grouping.getSubtotals().hasEffect(this.grouping.getDimensionSpecs()) || this.grouping.getHavingFilter() != null || this.selectProjection != null) {
            return null;
        }
        if (this.sorting != null && this.sorting.getOffsetLimit().hasOffset()) {
            return null;
        }
        if (this.grouping.getDimensions().isEmpty() && this.grouping.getPostAggregators().isEmpty() && this.grouping.getAggregatorFactories().size() == 1) {
            AggregatorFactory aggregatorFactory = (AggregatorFactory)Iterables.getOnlyElement(this.grouping.getAggregatorFactories());
            if (aggregatorFactory instanceof LongMaxAggregatorFactory || aggregatorFactory instanceof LongMinAggregatorFactory) {
                SimpleLongAggregatorFactory minMaxFactory = (SimpleLongAggregatorFactory)aggregatorFactory;
                String fieldName = minMaxFactory.getFieldName();
                if (fieldName == null || !fieldName.equals("__time") || minMaxFactory.getExpression() != null && !minMaxFactory.getExpression().isEmpty()) {
                    return null;
                }
            } else {
                return null;
            }
            boolean minTime = aggregatorFactory instanceof LongMinAggregatorFactory;
            Pair<DataSource, Filtration> dataSourceFiltrationPair = DruidQuery.getFiltration(this.dataSource, this.filter, this.virtualColumnRegistry, this.plannerContext.getJoinableFactoryWrapper());
            DataSource newDataSource = (DataSource)dataSourceFiltrationPair.lhs;
            Filtration filtration = (Filtration)dataSourceFiltrationPair.rhs;
            String bound = minTime ? "minTime" : "maxTime";
            HashMap<String, Object> context = new HashMap<String, Object>(this.plannerContext.queryContextMap());
            if (minTime) {
                context.put("minTimeArrayOutputName", aggregatorFactory.getName());
            } else {
                context.put("maxTimeArrayOutputName", aggregatorFactory.getName());
            }
            return new TimeBoundaryQuery(newDataSource, filtration.getQuerySegmentSpec(), bound, filtration.getDimFilter(), context);
        }
        return null;
    }

    @Nullable
    private TimeseriesQuery toTimeseriesQuery() {
        boolean descending;
        Granularity queryGranularity;
        HashMap<String, Object> theContext;
        int timeseriesLimit;
        block13: {
            block14: {
                block15: {
                    block12: {
                        if (!this.plannerContext.engineHasFeature(EngineFeature.TIMESERIES_QUERY) || this.grouping == null || this.grouping.getSubtotals().hasEffect(this.grouping.getDimensionSpecs()) || this.grouping.getHavingFilter() != null) {
                            return null;
                        }
                        if (this.sorting != null && this.sorting.getOffsetLimit().hasOffset()) {
                            return null;
                        }
                        timeseriesLimit = 0;
                        theContext = new HashMap<String, Object>();
                        if (!this.grouping.getDimensions().isEmpty()) break block12;
                        queryGranularity = Granularities.ALL;
                        descending = false;
                        break block13;
                    }
                    if (this.grouping.getDimensions().size() != 1) break block14;
                    DimensionExpression dimensionExpression = (DimensionExpression)Iterables.getOnlyElement(this.grouping.getDimensions());
                    queryGranularity = Expressions.toQueryGranularity(dimensionExpression.getDruidExpression(), this.plannerContext.getExprMacroTable());
                    if (queryGranularity == null) {
                        return null;
                    }
                    theContext.put("timestampResultField", ((DimensionExpression)Iterables.getOnlyElement(this.grouping.getDimensions())).toDimensionSpec().getOutputName());
                    if (this.sorting == null) break block15;
                    if (this.sorting.getOffsetLimit().hasLimit()) {
                        long limit = this.sorting.getOffsetLimit().getLimit();
                        if (limit == 0L) {
                            return null;
                        }
                        timeseriesLimit = Ints.checkedCast((long)limit);
                    }
                    switch (this.sorting.getTimeSortKind(dimensionExpression.getOutputName())) {
                        case UNORDERED: 
                        case TIME_ASCENDING: {
                            descending = false;
                            break block13;
                        }
                        case TIME_DESCENDING: {
                            descending = true;
                            break block13;
                        }
                        default: {
                            return null;
                        }
                    }
                }
                descending = false;
                break block13;
            }
            return null;
        }
        if (!Granularities.ALL.equals(queryGranularity) || this.grouping.hasGroupingDimensionsDropped()) {
            theContext.put("skipEmptyBuckets", true);
        }
        theContext.putAll(this.plannerContext.queryContextMap());
        Pair<DataSource, Filtration> dataSourceFiltrationPair = DruidQuery.getFiltration(this.dataSource, this.filter, this.virtualColumnRegistry, this.plannerContext.getJoinableFactoryWrapper());
        DataSource newDataSource = (DataSource)dataSourceFiltrationPair.lhs;
        Filtration filtration = (Filtration)dataSourceFiltrationPair.rhs;
        if (!DruidQuery.canUseQueryGranularity(this.dataSource, filtration, queryGranularity)) {
            return null;
        }
        ArrayList<PostAggregator> postAggregators = new ArrayList<PostAggregator>(this.grouping.getPostAggregators());
        if (this.sorting != null && this.sorting.getProjection() != null) {
            postAggregators.addAll(this.sorting.getProjection().getPostAggregators());
        }
        return new TimeseriesQuery(newDataSource, filtration.getQuerySegmentSpec(), descending, this.getVirtualColumns(false), filtration.getDimFilter(), queryGranularity, this.grouping.getAggregatorFactories(), postAggregators, timeseriesLimit, (Map)ImmutableSortedMap.copyOf(theContext));
    }

    @Nullable
    private TopNQuery toTopNQuery() {
        DimensionTopNMetricSpec topNMetricSpec;
        DimensionTopNMetricSpec baseMetricSpec;
        boolean topNOk;
        if (!this.plannerContext.engineHasFeature(EngineFeature.TOPN_QUERY)) {
            return null;
        }
        boolean bl = topNOk = this.grouping != null && this.grouping.getDimensions().size() == 1 && !this.grouping.getSubtotals().hasEffect(this.grouping.getDimensionSpecs()) && this.sorting != null && this.sorting.getOrderBys().size() <= 1 && this.sorting.getOffsetLimit().hasLimit() && this.sorting.getOffsetLimit().getLimit() > 0L && this.sorting.getOffsetLimit().getLimit() <= (long)this.plannerContext.getPlannerConfig().getMaxTopNLimit() && !this.sorting.getOffsetLimit().hasOffset() && this.grouping.getHavingFilter() == null;
        if (!topNOk) {
            return null;
        }
        DimensionSpec dimensionSpec = ((DimensionExpression)Iterables.getOnlyElement(this.grouping.getDimensions())).toDimensionSpec();
        if (dimensionSpec.getOutputType().isArray()) {
            return null;
        }
        OrderByColumnSpec limitColumn = this.sorting.getOrderBys().isEmpty() ? new OrderByColumnSpec(dimensionSpec.getOutputName(), OrderByColumnSpec.Direction.ASCENDING, Calcites.getStringComparatorForValueType(dimensionSpec.getOutputType())) : (OrderByColumnSpec)Iterables.getOnlyElement(this.sorting.getOrderBys());
        if (limitColumn.getDimension().equals(dimensionSpec.getOutputName())) {
            baseMetricSpec = new DimensionTopNMetricSpec(null, limitColumn.getDimensionComparator());
            topNMetricSpec = limitColumn.getDirection() == OrderByColumnSpec.Direction.ASCENDING ? baseMetricSpec : new InvertedTopNMetricSpec((TopNMetricSpec)baseMetricSpec);
        } else if (this.plannerContext.getPlannerConfig().isUseApproximateTopN()) {
            baseMetricSpec = new NumericTopNMetricSpec(limitColumn.getDimension());
            topNMetricSpec = limitColumn.getDirection() == OrderByColumnSpec.Direction.ASCENDING ? new InvertedTopNMetricSpec((TopNMetricSpec)baseMetricSpec) : baseMetricSpec;
        } else {
            return null;
        }
        Pair<DataSource, Filtration> dataSourceFiltrationPair = DruidQuery.getFiltration(this.dataSource, this.filter, this.virtualColumnRegistry, this.plannerContext.getJoinableFactoryWrapper());
        DataSource newDataSource = (DataSource)dataSourceFiltrationPair.lhs;
        Filtration filtration = (Filtration)dataSourceFiltrationPair.rhs;
        ArrayList<PostAggregator> postAggregators = new ArrayList<PostAggregator>(this.grouping.getPostAggregators());
        if (this.sorting.getProjection() != null) {
            postAggregators.addAll(this.sorting.getProjection().getPostAggregators());
        }
        return new TopNQuery(newDataSource, this.getVirtualColumns(true), dimensionSpec, (TopNMetricSpec)topNMetricSpec, Ints.checkedCast((long)this.sorting.getOffsetLimit().getLimit()), filtration.getQuerySegmentSpec(), filtration.getDimFilter(), Granularities.ALL, this.grouping.getAggregatorFactories(), postAggregators, (Map)ImmutableSortedMap.copyOf(this.plannerContext.queryContextMap()));
    }

    @Nullable
    private GroupByQuery toGroupByQuery() {
        GroupByQuery query;
        if (this.grouping == null) {
            return null;
        }
        if (this.sorting != null && this.sorting.getOffsetLimit().hasLimit() && this.sorting.getOffsetLimit().getLimit() <= 0L) {
            return null;
        }
        Pair<DataSource, Filtration> dataSourceFiltrationPair = DruidQuery.getFiltration(this.dataSource, this.filter, this.virtualColumnRegistry, this.plannerContext.getJoinableFactoryWrapper());
        DataSource newDataSource = (DataSource)dataSourceFiltrationPair.lhs;
        Filtration filtration = (Filtration)dataSourceFiltrationPair.rhs;
        DimFilterHavingSpec havingSpec = this.grouping.getHavingFilter() != null ? new DimFilterHavingSpec(Filtration.create(this.grouping.getHavingFilter()).optimizeFilterOnly(this.grouping.getOutputRowSignature()).getDimFilter(), Boolean.valueOf(true)) : null;
        ArrayList<PostAggregator> postAggregators = new ArrayList<PostAggregator>(this.grouping.getPostAggregators());
        if (this.sorting != null && this.sorting.getProjection() != null) {
            postAggregators.addAll(this.sorting.getProjection().getPostAggregators());
        }
        if ((query = new GroupByQuery(newDataSource, filtration.getQuerySegmentSpec(), this.getVirtualColumns(true), filtration.getDimFilter(), Granularities.ALL, this.grouping.getDimensionSpecs(), this.grouping.getAggregatorFactories(), postAggregators, (HavingSpec)havingSpec, Optional.ofNullable(this.sorting).orElse(Sorting.none()).limitSpec(), this.grouping.getSubtotals().toSubtotalsSpec(this.grouping.getDimensionSpecs()), (Map)ImmutableSortedMap.copyOf(this.plannerContext.queryContextMap()))).getLimitSpec() instanceof DefaultLimitSpec && query.isApplyLimitPushDown()) {
            return query;
        }
        HashMap<String, Object> theContext = new HashMap<String, Object>();
        Granularity queryGranularity = null;
        if (!this.grouping.getDimensions().isEmpty()) {
            for (DimensionExpression dimensionExpression : this.grouping.getDimensions()) {
                Granularity granularity = Expressions.toQueryGranularity(dimensionExpression.getDruidExpression(), this.plannerContext.getExprMacroTable());
                if (granularity == null || !DruidQuery.canUseQueryGranularity(this.dataSource, filtration, granularity)) continue;
                if (queryGranularity != null) {
                    queryGranularity = null;
                    break;
                }
                queryGranularity = granularity;
                int timestampDimensionIndexInDimensions = this.grouping.getDimensions().indexOf(dimensionExpression);
                theContext.put("timestampResultField", dimensionExpression.getOutputName());
                theContext.put("timestampResultFieldInOriginalDimensions", timestampDimensionIndexInDimensions);
                try {
                    theContext.put("timestampResultFieldGranularity", this.plannerContext.getJsonMapper().writeValueAsString((Object)queryGranularity));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (queryGranularity == null) {
            return query;
        }
        return query.withOverriddenContext(theContext);
    }

    @Nullable
    private ScanQuery toScanQuery() {
        List<ScanQuery.OrderBy> orderByColumns;
        if (this.grouping != null) {
            return null;
        }
        if (this.outputRowSignature.size() == 0) {
            throw new ISE("Cannot convert to Scan query without any columns.", new Object[0]);
        }
        Pair<DataSource, Filtration> dataSourceFiltrationPair = DruidQuery.getFiltration(this.dataSource, this.filter, this.virtualColumnRegistry, this.plannerContext.getJoinableFactoryWrapper());
        DataSource newDataSource = (DataSource)dataSourceFiltrationPair.lhs;
        Filtration filtration = (Filtration)dataSourceFiltrationPair.rhs;
        long scanOffset = 0L;
        long scanLimit = 0L;
        if (this.sorting != null) {
            scanOffset = this.sorting.getOffsetLimit().getOffset();
            if (this.sorting.getOffsetLimit().hasLimit()) {
                long limit = this.sorting.getOffsetLimit().getLimit();
                if (limit == 0L) {
                    return null;
                }
                scanLimit = limit;
            }
            orderByColumns = this.sorting.getOrderBys().stream().map(orderBy -> new ScanQuery.OrderBy(orderBy.getDimension(), orderBy.getDirection() == OrderByColumnSpec.Direction.DESCENDING ? ScanQuery.Order.DESCENDING : ScanQuery.Order.ASCENDING)).collect(Collectors.toList());
        } else {
            orderByColumns = Collections.emptyList();
        }
        if (!this.plannerContext.engineHasFeature(EngineFeature.SCAN_ORDER_BY_NON_TIME) && !orderByColumns.isEmpty()) {
            if (orderByColumns.size() > 1 || !"__time".equals(((ScanQuery.OrderBy)orderByColumns.get(0)).getColumnName())) {
                this.plannerContext.setPlanningError("SQL query requires order by non-time column %s that is not supported.", orderByColumns);
                return null;
            }
            if (!this.dataSource.isConcrete()) {
                this.plannerContext.setPlanningError("SQL query is a scan and requires order by on a datasource[%s], which is not supported.", this.dataSource);
                return null;
            }
        }
        TreeSet scanColumns = new TreeSet(this.outputRowSignature.getColumnNames());
        orderByColumns.forEach(column -> scanColumns.add(column.getColumnName()));
        VirtualColumns virtualColumns = this.getVirtualColumns(true);
        ImmutableList scanColumnsList = ImmutableList.copyOf(scanColumns);
        return new ScanQuery(newDataSource, filtration.getQuerySegmentSpec(), virtualColumns, ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST, 0, scanOffset, scanLimit, null, orderByColumns, filtration.getDimFilter(), (List)scanColumnsList, Boolean.valueOf(false), this.withScanSignatureIfNeeded(virtualColumns, (List<String>)scanColumnsList, this.plannerContext.queryContextMap()));
    }

    private Map<String, Object> withScanSignatureIfNeeded(VirtualColumns virtualColumns, List<String> scanColumns, Map<String, Object> queryContext) {
        if (!this.plannerContext.engineHasFeature(EngineFeature.SCAN_NEEDS_SIGNATURE)) {
            return queryContext;
        }
        RowSignature.Builder scanSignatureBuilder = RowSignature.builder();
        for (String columnName : scanColumns) {
            ColumnCapabilities capabilities = virtualColumns.getColumnCapabilitiesWithFallback((ColumnInspector)this.sourceRowSignature, columnName);
            if (capabilities == null) {
                throw new ISE("No type for column [%s]", new Object[]{columnName});
            }
            scanSignatureBuilder.add(columnName, capabilities.toColumnType());
        }
        RowSignature signature = scanSignatureBuilder.build();
        try {
            HashMap<String, Object> revised = new HashMap<String, Object>(queryContext);
            revised.put(CTX_SCAN_SIGNATURE, this.plannerContext.getJsonMapper().writeValueAsString((Object)signature));
            return revised;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

