/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner.convertlet;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql2rel.SqlRexContext;
import org.apache.calcite.sql2rel.SqlRexConvertlet;
import org.apache.calcite.util.Static;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.convertlet.DruidConvertletFactory;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.chrono.ISOChronology;

public class TimeInIntervalConvertletFactory
implements DruidConvertletFactory {
    public static final TimeInIntervalConvertletFactory INSTANCE = new TimeInIntervalConvertletFactory();
    private static final String NAME = "TIME_IN_INTERVAL";
    private static final SqlOperator OPERATOR = OperatorConversions.operatorBuilder("TIME_IN_INTERVAL").operandTypeChecker(OperandTypes.sequence((String)"TIME_IN_INTERVAL(<TIMESTAMP>, <LITERAL ISO8601 INTERVAL>)", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.TIMESTAMP}), OperandTypes.and((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.CHARACTER}), OperandTypes.LITERAL})})).returnTypeNonNull(SqlTypeName.BOOLEAN).functionCategory(SqlFunctionCategory.TIMEDATE).build();

    private TimeInIntervalConvertletFactory() {
    }

    @Override
    public SqlRexConvertlet createConvertlet(PlannerContext plannerContext) {
        return new TimeInIntervalConvertlet(plannerContext.getTimeZone());
    }

    @Override
    public List<SqlOperator> operators() {
        return Collections.singletonList(OPERATOR);
    }

    private static Interval intervalFromStringArgument(SqlParserPos parserPos, String intervalString, DateTimeZone sessionTimeZone) {
        try {
            return new Interval((Object)intervalString, (Chronology)ISOChronology.getInstance((DateTimeZone)sessionTimeZone));
        }
        catch (IllegalArgumentException e) {
            IAE ex = new IAE("Function '%s' second argument is not a valid ISO8601 interval: %s", new Object[]{NAME, e.getMessage()});
            throw (CalciteContextException)Static.RESOURCE.validatorContext(parserPos.getLineNum(), parserPos.getColumnNum(), parserPos.getEndLineNum(), parserPos.getEndColumnNum()).ex((Throwable)ex);
        }
    }

    private static class TimeInIntervalConvertlet
    implements SqlRexConvertlet {
        private final DateTimeZone sessionTimeZone;

        private TimeInIntervalConvertlet(DateTimeZone sessionTimeZone) {
            this.sessionTimeZone = sessionTimeZone;
        }

        public RexNode convertCall(SqlRexContext cx, SqlCall call) {
            RexBuilder rexBuilder = cx.getRexBuilder();
            RexNode timeOperand = cx.convertExpression((SqlNode)call.getOperandList().get(0));
            RexNode intervalOperand = cx.convertExpression((SqlNode)call.getOperandList().get(1));
            Interval interval = TimeInIntervalConvertletFactory.intervalFromStringArgument(call.getParserPosition(), RexLiteral.stringValue((RexNode)intervalOperand), this.sessionTimeZone);
            RexNode lowerBound = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{timeOperand, Calcites.jodaToCalciteTimestampLiteral(rexBuilder, interval.getStart(), this.sessionTimeZone, 3)});
            RexNode upperBound = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{timeOperand, Calcites.jodaToCalciteTimestampLiteral(rexBuilder, interval.getEnd(), this.sessionTimeZone, 3)});
            return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{lowerBound, upperBound});
        }
    }
}

