/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.DataContext;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.interpreter.BindableRel;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.query.Query;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.planner.CalcitePlanner;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.OffsetLimit;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.PlannerResult;
import org.apache.druid.sql.calcite.planner.PrepareResult;
import org.apache.druid.sql.calcite.planner.RelParameterizerShuttle;
import org.apache.druid.sql.calcite.planner.SqlParameterizerShuttle;
import org.apache.druid.sql.calcite.planner.SqlResourceCollectorShuttle;
import org.apache.druid.sql.calcite.planner.SqlStatementHandler;
import org.apache.druid.sql.calcite.planner.UnsupportedSQLQueryException;
import org.apache.druid.sql.calcite.rel.DruidConvention;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.DruidRel;
import org.apache.druid.sql.calcite.rel.DruidUnionRel;
import org.apache.druid.sql.calcite.run.EngineFeature;
import org.apache.druid.sql.calcite.run.QueryMaker;
import org.apache.druid.sql.calcite.table.DruidTable;
import org.apache.druid.utils.Throwables;

public abstract class QueryHandler
extends SqlStatementHandler.BaseStatementHandler {
    static final EmittingLogger log = new EmittingLogger(QueryHandler.class);
    protected SqlNode queryNode;
    protected SqlExplain explain;
    protected SqlNode validatedQueryNode;
    private boolean isPrepared;
    protected RelRoot rootQueryRel;
    private PrepareResult prepareResult;
    protected RexBuilder rexBuilder;

    public QueryHandler(SqlStatementHandler.HandlerContext handlerContext, SqlNode sqlNode, SqlExplain explain) {
        super(handlerContext);
        this.queryNode = sqlNode;
        this.explain = explain;
    }

    @Override
    public void validate() throws ValidationException {
        CalcitePlanner planner = this.handlerContext.planner();
        this.validatedQueryNode = planner.validate(this.rewriteParameters());
        SqlValidator validator = planner.getValidator();
        SqlResourceCollectorShuttle resourceCollectorShuttle = new SqlResourceCollectorShuttle(validator, this.handlerContext.plannerContext());
        this.validatedQueryNode.accept((SqlVisitor)resourceCollectorShuttle);
        this.resourceActions = resourceCollectorShuttle.getResourceActions();
    }

    private SqlNode rewriteParameters() {
        PlannerContext plannerContext = this.handlerContext.plannerContext();
        if (plannerContext.getParameters().isEmpty()) {
            return this.queryNode;
        }
        return (SqlNode)this.queryNode.accept((SqlVisitor)new SqlParameterizerShuttle(plannerContext));
    }

    @Override
    public void prepare() {
        if (this.isPrepared) {
            return;
        }
        this.isPrepared = true;
        this.rootQueryRel = this.handlerContext.planner().rel(this.validatedQueryNode);
        RelDataTypeFactory typeFactory = this.rootQueryRel.rel.getCluster().getTypeFactory();
        SqlValidator validator = this.handlerContext.planner().getValidator();
        RelDataType parameterTypes = validator.getParameterRowType(this.validatedQueryNode);
        RelDataType returnedRowType = this.explain != null ? QueryHandler.getExplainStructType(typeFactory) : this.returnedRowType();
        this.prepareResult = new PrepareResult(this.rootQueryRel.validatedRowType, returnedRowType, parameterTypes);
    }

    @Override
    public PrepareResult prepareResult() {
        return this.prepareResult;
    }

    protected abstract RelDataType returnedRowType();

    private static RelDataType getExplainStructType(RelDataTypeFactory typeFactory) {
        return typeFactory.createStructType((List)ImmutableList.of((Object)Calcites.createSqlType(typeFactory, SqlTypeName.VARCHAR), (Object)Calcites.createSqlType(typeFactory, SqlTypeName.VARCHAR)), (List)ImmutableList.of((Object)"PLAN", (Object)"RESOURCES"));
    }

    @Override
    public PlannerResult plan() throws ValidationException {
        this.prepare();
        Set<RelOptTable> bindableTables = QueryHandler.getBindableTables(this.rootQueryRel.rel);
        this.rexBuilder = new RexBuilder((RelDataTypeFactory)this.handlerContext.planner().getTypeFactory());
        try {
            if (!bindableTables.isEmpty()) {
                if (!this.handlerContext.plannerContext().engineHasFeature(EngineFeature.ALLOW_BINDABLE_PLAN)) {
                    throw new ValidationException(StringUtils.format((String)"Cannot query table%s %s with SQL engine '%s'.", (Object[])new Object[]{bindableTables.size() != 1 ? "s" : "", bindableTables.stream().map(table -> Joiner.on((String)".").join((Iterable)table.getQualifiedName())).collect(Collectors.joining(", ")), this.handlerContext.engine().name()}));
                }
                return this.planWithBindableConvention();
            }
            return this.planForDruid();
        }
        catch (Exception e) {
            Throwable cannotPlanException = Throwables.getCauseOfType((Throwable)e, RelOptPlanner.CannotPlanException.class);
            if (null == cannotPlanException) {
                throw e;
            }
            EmittingLogger logger = log;
            if (!this.handlerContext.queryContext().isDebug()) {
                logger = log.noStackTrace();
            }
            String errorMessage = this.buildSQLPlanningErrorMessage(cannotPlanException);
            logger.warn((Throwable)e, errorMessage, new Object[0]);
            throw new UnsupportedSQLQueryException(errorMessage, new Object[0]);
        }
    }

    private static Set<RelOptTable> getBindableTables(RelNode relNode) {
        class HasBindableVisitor
        extends RelVisitor {
            private final Set<RelOptTable> found = new HashSet<RelOptTable>();

            HasBindableVisitor() {
            }

            public void visit(RelNode node, int ordinal, RelNode parent) {
                RelOptTable table;
                if (node instanceof TableScan && (table = node.getTable()).unwrap(ScannableTable.class) != null && table.unwrap(DruidTable.class) == null) {
                    this.found.add(table);
                    return;
                }
                super.visit(node, ordinal, parent);
            }
        }
        HasBindableVisitor visitor = new HasBindableVisitor();
        visitor.go(relNode);
        return visitor.found;
    }

    private PlannerResult planWithBindableConvention() {
        CalcitePlanner planner = this.handlerContext.planner();
        BindableRel bindableRel = (BindableRel)planner.transform(1, planner.getEmptyTraitSet().replace((RelTrait)BindableConvention.INSTANCE).plus((RelTrait)this.rootQueryRel.collation), this.rootQueryRel.rel);
        if (!this.rootQueryRel.isRefTrivial()) {
            ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>();
            RexBuilder rexBuilder = bindableRel.getCluster().getRexBuilder();
            Iterator iterator = Pair.left((List)this.rootQueryRel.fields).iterator();
            while (iterator.hasNext()) {
                int field = (Integer)iterator.next();
                projects.add(rexBuilder.makeInputRef((RelNode)bindableRel, field));
            }
            bindableRel = new Bindables.BindableProject(bindableRel.getCluster(), bindableRel.getTraitSet(), (RelNode)bindableRel, projects, this.rootQueryRel.validatedRowType);
        }
        PlannerContext plannerContext = this.handlerContext.plannerContext();
        if (this.explain != null) {
            return this.planExplanation((RelNode)bindableRel, false);
        }
        BindableRel theRel = bindableRel;
        DataContext dataContext = plannerContext.createDataContext(planner.getTypeFactory(), plannerContext.getParameters());
        Supplier resultsSupplier = () -> {
            Enumerable enumerable = theRel.bind(dataContext);
            final Enumerator enumerator = enumerable.enumerator();
            return QueryResponse.withEmptyContext((Sequence)Sequences.withBaggage((Sequence)new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Object[], EnumeratorIterator<Object[]>>(){

                public EnumeratorIterator<Object[]> make() {
                    return new EnumeratorIterator<Object[]>(new Iterator<Object[]>(){

                        @Override
                        public boolean hasNext() {
                            return enumerator.moveNext();
                        }

                        @Override
                        public Object[] next() {
                            return (Object[])enumerator.current();
                        }
                    });
                }

                public void cleanup(EnumeratorIterator<Object[]> iterFromMake) {
                }
            }), () -> ((Enumerator)enumerator).close()));
        };
        return new PlannerResult((Supplier<QueryResponse<Object[]>>)resultsSupplier, this.rootQueryRel.validatedRowType);
    }

    protected PlannerResult planExplanation(RelNode rel, boolean isDruidConventionExplanation) {
        String resourcesString;
        PlannerContext plannerContext = this.handlerContext.plannerContext();
        String explanation = RelOptUtil.dumpPlan((String)"", (RelNode)rel, (SqlExplainFormat)this.explain.getFormat(), (SqlExplainLevel)this.explain.getDetailLevel());
        try {
            if (isDruidConventionExplanation && rel instanceof DruidRel && plannerContext.getPlannerConfig().isUseNativeQueryExplain()) {
                DruidRel druidRel = (DruidRel)rel;
                try {
                    explanation = this.explainSqlPlanAsNativeQueries(druidRel);
                }
                catch (Exception ex) {
                    log.warn((Throwable)ex, "Unable to translate to a native Druid query. Resorting to legacy Druid explain plan.", new Object[0]);
                }
            }
            Set resources = plannerContext.getResourceActions().stream().map(ResourceAction::getResource).collect(Collectors.toSet());
            resourcesString = plannerContext.getJsonMapper().writeValueAsString(resources);
        }
        catch (JsonProcessingException jpe) {
            log.error((Throwable)jpe, "Encountered exception while serializing resources for explain output", new Object[0]);
            resourcesString = null;
        }
        Supplier resultsSupplier = Suppliers.ofInstance((Object)QueryResponse.withEmptyContext((Sequence)Sequences.simple((Iterable)ImmutableList.of((Object)new Object[]{explanation, resourcesString}))));
        return new PlannerResult((Supplier<QueryResponse<Object[]>>)resultsSupplier, QueryHandler.getExplainStructType(rel.getCluster().getTypeFactory()));
    }

    private String explainSqlPlanAsNativeQueries(DruidRel<?> rel) throws JsonProcessingException {
        ObjectMapper jsonMapper = this.handlerContext.jsonMapper();
        List druidQueryList = this.flattenOutermostRel(rel).stream().map(druidRel -> druidRel.toDruidQuery(false)).collect(Collectors.toList());
        ArrayNode nativeQueriesArrayNode = jsonMapper.createArrayNode();
        for (DruidQuery druidQuery : druidQueryList) {
            Query<?> nativeQuery = druidQuery.getQuery();
            ObjectNode objectNode = jsonMapper.createObjectNode();
            objectNode.put("query", (JsonNode)jsonMapper.convertValue(nativeQuery, ObjectNode.class));
            objectNode.put("signature", (JsonNode)jsonMapper.convertValue((Object)druidQuery.getOutputRowSignature(), ArrayNode.class));
            nativeQueriesArrayNode.add((JsonNode)objectNode);
        }
        return jsonMapper.writeValueAsString((Object)nativeQueriesArrayNode);
    }

    private List<DruidRel<?>> flattenOutermostRel(DruidRel<?> outermostDruidRel) {
        ArrayList druidRels = new ArrayList();
        this.flattenOutermostRel(outermostDruidRel, druidRels);
        return druidRels;
    }

    private void flattenOutermostRel(DruidRel<?> druidRel, List<DruidRel<?>> flattendListAccumulator) {
        if (druidRel instanceof DruidUnionRel) {
            DruidUnionRel druidUnionRel = (DruidUnionRel)druidRel;
            druidUnionRel.getInputs().forEach(innerRelNode -> {
                DruidRel innerDruidRelNode = (DruidRel)((Object)innerRelNode);
                this.flattenOutermostRel(innerDruidRelNode, flattendListAccumulator);
            });
        } else {
            flattendListAccumulator.add(druidRel);
        }
    }

    protected abstract PlannerResult planForDruid() throws ValidationException;

    protected PlannerResult planWithDruidConvention() throws ValidationException {
        RelRoot possiblyLimitedRoot = this.possiblyWrapRootWithOuterLimitFromContext(this.rootQueryRel);
        QueryMaker queryMaker = this.buildQueryMaker(possiblyLimitedRoot);
        PlannerContext plannerContext = this.handlerContext.plannerContext();
        plannerContext.setQueryMaker(queryMaker);
        RelNode parameterized = possiblyLimitedRoot.rel.accept((RelShuttle)new RelParameterizerShuttle(plannerContext));
        CalcitePlanner planner = this.handlerContext.planner();
        DruidRel druidRel = (DruidRel)planner.transform(0, planner.getEmptyTraitSet().replace((RelTrait)DruidConvention.instance()).plus((RelTrait)this.rootQueryRel.collation), parameterized);
        if (this.explain != null) {
            return this.planExplanation((RelNode)druidRel, true);
        }
        RelDataType rowType = this.prepareResult.getReturnedRowType();
        Supplier resultsSupplier = () -> {
            Set readResourceActions = plannerContext.getResourceActions().stream().filter(action -> action.getAction() == Action.READ).collect(Collectors.toSet());
            Preconditions.checkState((readResourceActions.isEmpty() == druidRel.getDataSourceNames().isEmpty() || readResourceActions.size() >= druidRel.getDataSourceNames().size() ? 1 : 0) != 0, (Object)"Authorization sanity check failed");
            return druidRel.runQuery();
        };
        return new PlannerResult((Supplier<QueryResponse<Object[]>>)resultsSupplier, rowType);
    }

    @Nullable
    private RelRoot possiblyWrapRootWithOuterLimitFromContext(RelRoot root) {
        LogicalSort newRootRel;
        Long outerLimit = this.handlerContext.queryContext().getLong("sqlOuterLimit");
        if (outerLimit == null) {
            return root;
        }
        if (root.rel instanceof Sort) {
            Sort sort = (Sort)root.rel;
            OffsetLimit originalOffsetLimit = OffsetLimit.fromSort(sort);
            OffsetLimit newOffsetLimit = originalOffsetLimit.andThen(new OffsetLimit(0L, outerLimit));
            if (newOffsetLimit.equals(originalOffsetLimit)) {
                return root;
            }
            newRootRel = LogicalSort.create((RelNode)sort.getInput(), (RelCollation)sort.collation, (RexNode)newOffsetLimit.getOffsetAsRexNode(this.rexBuilder), (RexNode)newOffsetLimit.getLimitAsRexNode(this.rexBuilder));
        } else {
            newRootRel = LogicalSort.create((RelNode)root.rel, (RelCollation)root.collation, null, (RexNode)new OffsetLimit(0L, outerLimit).getLimitAsRexNode(this.rexBuilder));
        }
        return new RelRoot((RelNode)newRootRel, root.validatedRowType, root.kind, (List)root.fields, root.collation);
    }

    protected abstract QueryMaker buildQueryMaker(RelRoot var1) throws ValidationException;

    private String buildSQLPlanningErrorMessage(Throwable exception) {
        String errorMessage = this.handlerContext.plannerContext().getPlanningError();
        if (null == errorMessage && exception instanceof UnsupportedSQLQueryException) {
            errorMessage = exception.getMessage();
        }
        errorMessage = null == errorMessage ? "Please check Broker logs for additional details." : "Possible error: " + errorMessage;
        return StringUtils.format((String)"Query not supported. %s SQL was: %s", (Object[])new Object[]{errorMessage, this.handlerContext.plannerContext().getSql()});
    }

    private static class EnumeratorIterator<T>
    implements Iterator<T> {
        private final Iterator<T> it;

        EnumeratorIterator(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            return this.it.next();
        }
    }

    public static class SelectHandler
    extends QueryHandler {
        private final SqlNode sqlNode;

        public SelectHandler(SqlStatementHandler.HandlerContext handlerContext, SqlNode sqlNode, SqlExplain explain) {
            super(handlerContext, sqlNode, explain);
            this.sqlNode = sqlNode;
        }

        @Override
        public SqlNode sqlNode() {
            return this.sqlNode;
        }

        @Override
        public void validate() throws ValidationException {
            if (!this.handlerContext.plannerContext().engineHasFeature(EngineFeature.CAN_SELECT)) {
                throw new ValidationException(StringUtils.format((String)"Cannot execute SELECT with SQL engine '%s'.", (Object[])new Object[]{this.handlerContext.engine().name()}));
            }
            super.validate();
        }

        @Override
        protected RelDataType returnedRowType() {
            RelDataTypeFactory typeFactory = this.rootQueryRel.rel.getCluster().getTypeFactory();
            return this.handlerContext.engine().resultTypeForSelect(typeFactory, this.rootQueryRel.validatedRowType);
        }

        @Override
        protected PlannerResult planForDruid() throws ValidationException {
            return this.planWithDruidConvention();
        }

        @Override
        protected QueryMaker buildQueryMaker(RelRoot rootQueryRel) throws ValidationException {
            return this.handlerContext.engine().buildQueryMakerForSelect(rootQueryRel, this.handlerContext.plannerContext());
        }
    }
}

