/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.UnsupportedSQLQueryException;

public class DruidRexExecutor
implements RexExecutor {
    private static final RowSignature EMPTY_ROW_SIGNATURE = RowSignature.builder().build();
    private final PlannerContext plannerContext;

    public DruidRexExecutor(PlannerContext plannerContext) {
        this.plannerContext = plannerContext;
    }

    public void reduce(RexBuilder rexBuilder, List<RexNode> constExps, List<RexNode> reducedValues) {
        for (RexNode constExp : constExps) {
            RexNode literal;
            DruidExpression druidExpression = Expressions.toDruidExpression(this.plannerContext, EMPTY_ROW_SIGNATURE, constExp);
            if (druidExpression == null) {
                reducedValues.add(constExp);
                continue;
            }
            SqlTypeName sqlTypeName = constExp.getType().getSqlTypeName();
            Expr expr = Parser.parse((String)druidExpression.getExpression(), (ExprMacroTable)this.plannerContext.getExprMacroTable());
            ExprEval exprResult = expr.eval(InputBindings.forFunction(name -> {
                throw new UnsupportedOperationException();
            }));
            if (sqlTypeName == SqlTypeName.BOOLEAN) {
                literal = rexBuilder.makeLiteral((Object)exprResult.asBoolean(), constExp.getType(), true);
            } else if (sqlTypeName == SqlTypeName.DATE) {
                if (!constExp.getType().isNullable() && exprResult.isNumericNull()) {
                    throw new UnsupportedSQLQueryException("Illegal DATE constant: %s", constExp);
                }
                literal = rexBuilder.makeDateLiteral(Calcites.jodaToCalciteDateString(DateTimes.utc((long)exprResult.asLong()), this.plannerContext.getTimeZone()));
            } else if (sqlTypeName == SqlTypeName.TIMESTAMP) {
                if (!constExp.getType().isNullable() && exprResult.isNumericNull()) {
                    throw new UnsupportedSQLQueryException("Illegal TIMESTAMP constant: %s", constExp);
                }
                literal = Calcites.jodaToCalciteTimestampLiteral(rexBuilder, DateTimes.utc((long)exprResult.asLong()), this.plannerContext.getTimeZone(), constExp.getType().getPrecision());
            } else if (SqlTypeName.NUMERIC_TYPES.contains(sqlTypeName)) {
                if (exprResult.isNumericNull()) {
                    literal = rexBuilder.makeNullLiteral(constExp.getType());
                } else {
                    BigDecimal bigDecimal;
                    if (exprResult.type().is((TypeDescriptor)ExprType.LONG)) {
                        bigDecimal = BigDecimal.valueOf(exprResult.asLong());
                    } else {
                        double exprResultDouble = exprResult.asDouble();
                        if (Double.isNaN(exprResultDouble) || Double.isInfinite(exprResultDouble)) {
                            String expression = druidExpression.getExpression();
                            throw new UnsupportedSQLQueryException("'%s' evaluates to '%s' that is not supported in SQL. You can either cast the expression as BIGINT ('CAST(%s as BIGINT)') or VARCHAR ('CAST(%s as VARCHAR)') or change the expression itself", expression, Double.toString(exprResultDouble), expression, expression);
                        }
                        bigDecimal = BigDecimal.valueOf(exprResult.asDouble());
                    }
                    literal = rexBuilder.makeLiteral((Object)bigDecimal, constExp.getType(), true);
                }
            } else if (sqlTypeName == SqlTypeName.ARRAY) {
                assert (exprResult.isArray());
                Object[] array = exprResult.asArray();
                if (array == null) {
                    literal = rexBuilder.makeNullLiteral(constExp.getType());
                } else if (SqlTypeName.NUMERIC_TYPES.contains(constExp.getType().getComponentType().getSqlTypeName())) {
                    if (exprResult.type().getElementType().is((TypeDescriptor)ExprType.LONG)) {
                        ArrayList<BigDecimal> resultAsBigDecimalList = new ArrayList<BigDecimal>(array.length);
                        for (Object val : array) {
                            Number longVal = (Number)val;
                            if (longVal == null) {
                                resultAsBigDecimalList.add(null);
                                continue;
                            }
                            resultAsBigDecimalList.add(BigDecimal.valueOf(longVal.longValue()));
                        }
                        literal = rexBuilder.makeLiteral(resultAsBigDecimalList, constExp.getType(), true);
                    } else {
                        ArrayList<BigDecimal> resultAsBigDecimalList = new ArrayList<BigDecimal>(array.length);
                        for (Object val : array) {
                            Number doubleVal = (Number)val;
                            if (doubleVal == null) {
                                resultAsBigDecimalList.add(null);
                                continue;
                            }
                            if (Double.isNaN(doubleVal.doubleValue()) || Double.isInfinite(doubleVal.doubleValue())) {
                                String expression = druidExpression.getExpression();
                                throw new UnsupportedSQLQueryException("'%s' contains an element that evaluates to '%s' which is not supported in SQL. You can either cast the element in the ARRAY to BIGINT or VARCHAR or change the expression itself", expression, Double.toString(doubleVal.doubleValue()));
                            }
                            resultAsBigDecimalList.add(BigDecimal.valueOf(doubleVal.doubleValue()));
                        }
                        literal = rexBuilder.makeLiteral(resultAsBigDecimalList, constExp.getType(), true);
                    }
                } else {
                    literal = rexBuilder.makeLiteral(Arrays.asList(array), constExp.getType(), true);
                }
            } else {
                literal = sqlTypeName == SqlTypeName.OTHER ? constExp : (exprResult.isArray() ? constExp : rexBuilder.makeLiteral(exprResult.value(), constExp.getType(), true));
            }
            reducedValues.add(literal);
        }
    }
}

