/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.ValidationException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.QueryContext;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.parser.DruidSqlInsert;
import org.apache.druid.sql.calcite.parser.DruidSqlReplace;
import org.apache.druid.sql.calcite.planner.CalcitePlanner;
import org.apache.druid.sql.calcite.planner.IngestHandler;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.PlannerResult;
import org.apache.druid.sql.calcite.planner.PrepareResult;
import org.apache.druid.sql.calcite.planner.QueryHandler;
import org.apache.druid.sql.calcite.planner.SqlStatementHandler;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.joda.time.DateTimeZone;

public class DruidPlanner
implements Closeable {
    private final FrameworkConfig frameworkConfig;
    private final CalcitePlanner planner;
    private final PlannerContext plannerContext;
    private final SqlEngine engine;
    private State state = State.START;
    private SqlStatementHandler handler;
    private boolean authorized;

    DruidPlanner(FrameworkConfig frameworkConfig, PlannerContext plannerContext, SqlEngine engine) {
        this.frameworkConfig = frameworkConfig;
        this.planner = new CalcitePlanner(frameworkConfig);
        this.plannerContext = plannerContext;
        this.engine = engine;
    }

    public void validate() throws SqlParseException, ValidationException {
        Preconditions.checkState((this.state == State.START ? 1 : 0) != 0);
        this.engine.validateContext(this.plannerContext.queryContextMap());
        SqlNode root = this.planner.parse(this.plannerContext.getSql());
        this.handler = this.createHandler(root);
        try {
            this.handler.validate();
            this.plannerContext.setResourceActions(this.handler.resourceActions());
        }
        catch (RuntimeException e) {
            throw new ValidationException((Throwable)e);
        }
        this.state = State.VALIDATED;
    }

    private SqlStatementHandler createHandler(SqlNode node) throws ValidationException {
        SqlNode query = node;
        SqlExplain explain = null;
        if (query.getKind() == SqlKind.EXPLAIN) {
            explain = (SqlExplain)query;
            query = explain.getExplicandum();
        }
        HandlerContextImpl handlerContext = new HandlerContextImpl();
        if (query.getKind() == SqlKind.INSERT) {
            if (query instanceof DruidSqlInsert) {
                return new IngestHandler.InsertHandler((SqlStatementHandler.HandlerContext)handlerContext, (DruidSqlInsert)query, explain);
            }
            if (query instanceof DruidSqlReplace) {
                return new IngestHandler.ReplaceHandler((SqlStatementHandler.HandlerContext)handlerContext, (DruidSqlReplace)query, explain);
            }
        }
        if (query.isA((Set)SqlKind.QUERY)) {
            return new QueryHandler.SelectHandler(handlerContext, query, explain);
        }
        throw new ValidationException(StringUtils.format((String)"Cannot execute [%s].", (Object[])new Object[]{node.getKind()}));
    }

    public PrepareResult prepare() {
        Preconditions.checkState((this.state == State.VALIDATED ? 1 : 0) != 0);
        this.handler.prepare();
        this.state = State.PREPARED;
        return this.prepareResult();
    }

    public AuthResult authorize(Function<Set<ResourceAction>, Access> authorizer, Set<ResourceAction> extraActions) {
        Preconditions.checkState((this.state == State.VALIDATED ? 1 : 0) != 0);
        Set<ResourceAction> sqlResourceActions = this.plannerContext.getResourceActions();
        HashSet<ResourceAction> allResourceActions = new HashSet<ResourceAction>(sqlResourceActions);
        allResourceActions.addAll(extraActions);
        Access access = authorizer.apply(allResourceActions);
        this.plannerContext.setAuthorizationResult(access);
        this.authorized = true;
        return new AuthResult(access, sqlResourceActions, allResourceActions);
    }

    public PlannerResult plan() throws ValidationException {
        Preconditions.checkState((this.state == State.VALIDATED || this.state == State.PREPARED ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.authorized);
        this.state = State.PLANNED;
        return this.handler.plan();
    }

    public PlannerContext getPlannerContext() {
        return this.plannerContext;
    }

    public PrepareResult prepareResult() {
        return this.handler.prepareResult();
    }

    @Override
    public void close() {
        this.planner.close();
    }

    protected class HandlerContextImpl
    implements SqlStatementHandler.HandlerContext {
        protected HandlerContextImpl() {
        }

        @Override
        public PlannerContext plannerContext() {
            return DruidPlanner.this.plannerContext;
        }

        @Override
        public SqlEngine engine() {
            return DruidPlanner.this.engine;
        }

        @Override
        public CalcitePlanner planner() {
            return DruidPlanner.this.planner;
        }

        @Override
        public QueryContext queryContext() {
            return DruidPlanner.this.plannerContext.queryContext();
        }

        @Override
        public Map<String, Object> queryContextMap() {
            return DruidPlanner.this.plannerContext.queryContextMap();
        }

        @Override
        public SchemaPlus defaultSchema() {
            return DruidPlanner.this.frameworkConfig.getDefaultSchema();
        }

        @Override
        public ObjectMapper jsonMapper() {
            return DruidPlanner.this.plannerContext.getJsonMapper();
        }

        @Override
        public DateTimeZone timeZone() {
            return DruidPlanner.this.plannerContext.getTimeZone();
        }
    }

    public static class AuthResult {
        public final Access authorizationResult;
        public final Set<ResourceAction> sqlResourceActions;
        public final Set<ResourceAction> allResourceActions;

        public AuthResult(Access authorizationResult, Set<ResourceAction> sqlResourceActions, Set<ResourceAction> allResourceActions) {
            this.authorizationResult = authorizationResult;
            this.sqlResourceActions = sqlResourceActions;
            this.allResourceActions = allResourceActions;
        }
    }

    public static enum State {
        START,
        VALIDATED,
        PREPARED,
        PLANNED;

    }
}

