/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.google.common.collect.ImmutableList;
import java.io.Reader;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.BaseDruidSqlValidator;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.metadata.CachingRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Pair;

public class CalcitePlanner
implements Planner,
RelOptTable.ViewExpander {
    private final SqlOperatorTable operatorTable;
    private final ImmutableList<Program> programs;
    private final FrameworkConfig frameworkConfig;
    private final Context context;
    private final CalciteConnectionConfig connectionConfig;
    @Nullable
    private final List<RelTraitDef> traitDefs;
    private final SqlParser.Config parserConfig;
    private final SqlToRelConverter.Config sqlToRelConverterConfig;
    private final SqlRexConvertletTable convertletTable;
    private State state;
    private SchemaPlus defaultSchema;
    private JavaTypeFactory typeFactory;
    private RelOptPlanner planner;
    private RexExecutor executor;
    private SqlValidator validator;
    private SqlNode validatedSqlNode;
    private RelRoot root;

    public CalcitePlanner(FrameworkConfig config) {
        this.frameworkConfig = config;
        this.defaultSchema = config.getDefaultSchema();
        this.operatorTable = config.getOperatorTable();
        this.programs = config.getPrograms();
        this.parserConfig = config.getParserConfig();
        this.sqlToRelConverterConfig = config.getSqlToRelConverterConfig();
        this.state = State.STATE_0_CLOSED;
        this.traitDefs = config.getTraitDefs();
        this.convertletTable = config.getConvertletTable();
        this.executor = config.getExecutor();
        this.context = config.getContext();
        this.connectionConfig = this.connConfig();
        this.reset();
    }

    private CalciteConnectionConfig connConfig() {
        CalciteConnectionConfig unwrapped = (CalciteConnectionConfig)this.context.unwrap(CalciteConnectionConfig.class);
        if (unwrapped != null) {
            return unwrapped;
        }
        Properties properties = new Properties();
        properties.setProperty(CalciteConnectionProperty.CASE_SENSITIVE.camelName(), String.valueOf(this.parserConfig.caseSensitive()));
        properties.setProperty(CalciteConnectionProperty.CONFORMANCE.camelName(), String.valueOf(this.frameworkConfig.getParserConfig().conformance()));
        return new CalciteConnectionConfigImpl(properties);
    }

    private void ensure(State state) {
        if (state == this.state) {
            return;
        }
        if (state.ordinal() < this.state.ordinal()) {
            throw new IllegalArgumentException("cannot move to " + (Object)((Object)state) + " from " + (Object)((Object)this.state));
        }
        state.from(this);
    }

    public RelTraitSet getEmptyTraitSet() {
        return this.planner.emptyTraitSet();
    }

    public FrameworkConfig frameworkConfig() {
        return this.frameworkConfig;
    }

    public void close() {
        this.typeFactory = null;
        this.state = State.STATE_0_CLOSED;
    }

    public void reset() {
        this.ensure(State.STATE_0_CLOSED);
        this.state = State.STATE_1_RESET;
    }

    private void ready() {
        switch (this.state) {
            case STATE_0_CLOSED: {
                this.reset();
                break;
            }
        }
        this.ensure(State.STATE_1_RESET);
        RelDataTypeSystem typeSystem = (RelDataTypeSystem)this.connectionConfig.typeSystem(RelDataTypeSystem.class, (Object)RelDataTypeSystem.DEFAULT);
        this.typeFactory = new JavaTypeFactoryImpl(typeSystem);
        this.planner = new VolcanoPlanner(this.frameworkConfig.getCostFactory(), this.context);
        RelOptUtil.registerDefaultRules((RelOptPlanner)this.planner, (boolean)this.connectionConfig.materializationsEnabled(), (boolean)((Boolean)Hook.ENABLE_BINDABLE.get((Object)false)));
        this.planner.setExecutor(this.executor);
        this.state = State.STATE_2_READY;
        if (this.traitDefs == null) {
            this.planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
            if (((Boolean)CalciteSystemProperty.ENABLE_COLLATION_TRAIT.value()).booleanValue()) {
                this.planner.addRelTraitDef((RelTraitDef)RelCollationTraitDef.INSTANCE);
            }
        } else {
            for (RelTraitDef def : this.traitDefs) {
                this.planner.addRelTraitDef(def);
            }
        }
    }

    public SqlNode parse(Reader reader) throws SqlParseException {
        switch (this.state) {
            case STATE_0_CLOSED: 
            case STATE_1_RESET: {
                this.ready();
                break;
            }
        }
        this.ensure(State.STATE_2_READY);
        SqlParser parser = SqlParser.create((Reader)reader, (SqlParser.Config)this.parserConfig);
        SqlNode sqlNode = parser.parseStmt();
        this.state = State.STATE_3_PARSED;
        return sqlNode;
    }

    public SqlNode validate(SqlNode sqlNode) throws ValidationException {
        this.ensure(State.STATE_3_PARSED);
        SqlConformance conformance = this.conformance();
        CalciteCatalogReader catalogReader = this.createCatalogReader();
        this.validator = new BaseDruidSqlValidator(this.operatorTable, catalogReader, this.typeFactory, conformance);
        this.validator.setIdentifierExpansion(true);
        try {
            this.validatedSqlNode = this.validator.validate(sqlNode);
        }
        catch (RuntimeException e) {
            throw new ValidationException((Throwable)e);
        }
        this.state = State.STATE_4_VALIDATED;
        return this.validatedSqlNode;
    }

    public SqlValidator getValidator() {
        return this.validator;
    }

    private SqlConformance conformance() {
        return this.connectionConfig.conformance();
    }

    public Pair<SqlNode, RelDataType> validateAndGetType(SqlNode sqlNode) throws ValidationException {
        SqlNode validatedNode = this.validate(sqlNode);
        RelDataType type = this.validator.getValidatedNodeType(validatedNode);
        return Pair.of((Object)validatedNode, (Object)type);
    }

    public final RelNode convert(SqlNode sql) {
        return this.rel((SqlNode)sql).rel;
    }

    public RelRoot rel(SqlNode sql) {
        this.ensure(State.STATE_4_VALIDATED);
        assert (this.validatedSqlNode != null);
        RexBuilder rexBuilder = this.createRexBuilder();
        RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)this.planner, (RexBuilder)rexBuilder);
        SqlToRelConverter.Config config = SqlToRelConverter.configBuilder().withConfig(this.sqlToRelConverterConfig).withTrimUnusedFields(false).withConvertTableAccess(false).build();
        SqlToRelConverter sqlToRelConverter = new SqlToRelConverter((RelOptTable.ViewExpander)this, this.validator, (Prepare.CatalogReader)this.createCatalogReader(), cluster, this.convertletTable, config);
        this.root = sqlToRelConverter.convertQuery(this.validatedSqlNode, false, true);
        this.root = this.root.withRel(sqlToRelConverter.flattenTypes(this.root.rel, true));
        RelBuilder relBuilder = config.getRelBuilderFactory().create(cluster, null);
        this.root = this.root.withRel(RelDecorrelator.decorrelateQuery((RelNode)this.root.rel, (RelBuilder)relBuilder));
        this.state = State.STATE_5_CONVERTED;
        return this.root;
    }

    public RelRoot expandView(RelDataType rowType, String queryString, List<String> schemaPath, List<String> viewPath) {
        SqlNode sqlNode;
        if (this.planner == null) {
            this.ready();
        }
        SqlParser parser = SqlParser.create((String)queryString, (SqlParser.Config)this.parserConfig);
        try {
            sqlNode = parser.parseQuery();
        }
        catch (SqlParseException e) {
            throw new RuntimeException("parse failed", e);
        }
        SqlConformance conformance = this.conformance();
        CalciteCatalogReader catalogReader = this.createCatalogReader().withSchemaPath(schemaPath);
        BaseDruidSqlValidator validator = new BaseDruidSqlValidator(this.operatorTable, catalogReader, this.typeFactory, conformance);
        validator.setIdentifierExpansion(true);
        RexBuilder rexBuilder = this.createRexBuilder();
        RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)this.planner, (RexBuilder)rexBuilder);
        SqlToRelConverter.Config config = SqlToRelConverter.configBuilder().withConfig(this.sqlToRelConverterConfig).withTrimUnusedFields(false).withConvertTableAccess(false).build();
        SqlToRelConverter sqlToRelConverter = new SqlToRelConverter((RelOptTable.ViewExpander)this, (SqlValidator)validator, (Prepare.CatalogReader)catalogReader, cluster, this.convertletTable, config);
        RelRoot root = sqlToRelConverter.convertQuery(sqlNode, true, false);
        RelRoot root2 = root.withRel(sqlToRelConverter.flattenTypes(root.rel, true));
        RelBuilder relBuilder = config.getRelBuilderFactory().create(cluster, null);
        return root2.withRel(RelDecorrelator.decorrelateQuery((RelNode)root.rel, (RelBuilder)relBuilder));
    }

    private CalciteCatalogReader createCatalogReader() {
        return new CalciteCatalogReader(CalciteSchema.from((SchemaPlus)CalcitePlanner.rootSchema(this.defaultSchema)), CalciteSchema.from((SchemaPlus)this.defaultSchema).path(null), (RelDataTypeFactory)this.typeFactory, this.connectionConfig);
    }

    private static SchemaPlus rootSchema(SchemaPlus schema) {
        while (schema.getParentSchema() != null) {
            schema = schema.getParentSchema();
        }
        return schema;
    }

    private RexBuilder createRexBuilder() {
        return new RexBuilder((RelDataTypeFactory)this.typeFactory);
    }

    public JavaTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public RelNode transform(int ruleSetIndex, RelTraitSet requiredOutputTraits, RelNode rel) {
        this.ensure(State.STATE_5_CONVERTED);
        rel.getCluster().setMetadataProvider((RelMetadataProvider)new CachingRelMetadataProvider(rel.getCluster().getMetadataProvider(), rel.getCluster().getPlanner()));
        Program program = (Program)this.programs.get(ruleSetIndex);
        return program.run(this.planner, rel, requiredOutputTraits, (List)ImmutableList.of(), (List)ImmutableList.of());
    }

    private static enum State {
        STATE_0_CLOSED{

            @Override
            void from(CalcitePlanner planner) {
                planner.close();
            }
        }
        ,
        STATE_1_RESET{

            @Override
            void from(CalcitePlanner planner) {
                planner.ensure(2.STATE_0_CLOSED);
                planner.reset();
            }
        }
        ,
        STATE_2_READY{

            @Override
            void from(CalcitePlanner planner) {
                STATE_1_RESET.from(planner);
                planner.ready();
            }
        }
        ,
        STATE_3_PARSED,
        STATE_4_VALIDATED,
        STATE_5_CONVERTED;


        void from(CalcitePlanner planner) {
            throw new IllegalArgumentException("cannot move from " + (Object)((Object)planner.state) + " to " + (Object)((Object)this));
        }
    }
}

