/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.parser;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.sql.calcite.parser.DruidSqlIngest;

public class DruidSqlReplace
extends DruidSqlIngest {
    public static final String SQL_REPLACE_TIME_CHUNKS = "sqlReplaceTimeChunks";
    public static final SqlOperator OPERATOR = new SqlSpecialOperator("REPLACE", SqlKind.OTHER);
    private final SqlNode replaceTimeQuery;

    public DruidSqlReplace(@Nonnull SqlInsert insertNode, @Nullable Granularity partitionedBy, @Nullable String partitionedByStringForUnparse, @Nullable SqlNodeList clusteredBy, @Nullable SqlNode replaceTimeQuery) {
        super(insertNode.getParserPosition(), (SqlNodeList)insertNode.getOperandList().get(0), insertNode.getTargetTable(), insertNode.getSource(), insertNode.getTargetColumnList(), partitionedBy, partitionedByStringForUnparse, clusteredBy);
        this.replaceTimeQuery = replaceTimeQuery;
    }

    public SqlNode getReplaceTimeQuery() {
        return this.replaceTimeQuery;
    }

    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.startList(SqlWriter.FrameTypeEnum.SELECT);
        writer.sep("REPLACE INTO");
        int opLeft = this.getOperator().getLeftPrec();
        int opRight = this.getOperator().getRightPrec();
        this.getTargetTable().unparse(writer, opLeft, opRight);
        if (this.getTargetColumnList() != null) {
            this.getTargetColumnList().unparse(writer, opLeft, opRight);
        }
        writer.newlineAndIndent();
        writer.keyword("OVERWRITE");
        if (this.replaceTimeQuery instanceof SqlLiteral) {
            writer.keyword("ALL");
        } else {
            this.replaceTimeQuery.unparse(writer, leftPrec, rightPrec);
        }
        writer.newlineAndIndent();
        this.getSource().unparse(writer, 0, 0);
        writer.newlineAndIndent();
        writer.keyword("PARTITIONED BY");
        writer.keyword(this.partitionedByStringForUnparse);
        if (this.getClusteredBy() != null) {
            writer.keyword("CLUSTERED BY");
            SqlWriter.Frame frame = writer.startList("", "");
            for (SqlNode clusterByOpts : this.getClusteredBy().getList()) {
                clusterByOpts.unparse(writer, leftPrec, rightPrec);
            }
            writer.endList(frame);
        }
    }
}

