/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class TruncateOperatorConversion
implements SqlOperatorConversion {
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("TRUNCATE").operandTypes(SqlTypeFamily.NUMERIC, SqlTypeFamily.INTEGER).requiredOperands(1).returnTypeInference(ReturnTypes.ARG0).functionCategory(SqlFunctionCategory.NUMERIC).build();

    public SqlFunction calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertCallBuilder(plannerContext, rowSignature, rexNode, inputExpressions -> {
            String factorString;
            Expr digitsExpr;
            DruidExpression arg = (DruidExpression)inputExpressions.get(0);
            Expr expr = digitsExpr = inputExpressions.size() > 1 ? ((DruidExpression)inputExpressions.get(1)).parse(plannerContext.getExprMacroTable()) : null;
            if (digitsExpr == null) {
                factorString = "1";
            } else if (digitsExpr.isLiteral()) {
                int digits = ((Number)digitsExpr.getLiteralValue()).intValue();
                double factor = Math.pow(10.0, digits);
                factorString = DruidExpression.doubleLiteral(factor);
            } else {
                factorString = StringUtils.format((String)"pow(10,%s)", (Object[])new Object[]{inputExpressions.get(1)});
            }
            return StringUtils.format((String)"(cast(cast(%s * %s,'long'),'double') / %s)", (Object[])new Object[]{arg.getExpression(), factorString, factorString});
        });
    }
}

