/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.joda.time.DateTimeZone;

public class TimeParseOperatorConversion
implements SqlOperatorConversion {
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("TIME_PARSE").operandTypes(SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER).requiredOperands(1).returnTypeNullable(SqlTypeName.TIMESTAMP).functionCategory(SqlFunctionCategory.TIMEDATE).build();

    @Override
    public SqlOperator calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        RexCall call = (RexCall)rexNode;
        RexNode timeArg = (RexNode)call.getOperands().get(0);
        DruidExpression timeExpression = Expressions.toDruidExpression(plannerContext, rowSignature, timeArg);
        if (timeExpression == null) {
            return null;
        }
        String pattern = OperatorConversions.getOperandWithDefault(call.getOperands(), 1, RexLiteral::stringValue, null);
        DateTimeZone timeZone = OperatorConversions.getOperandWithDefault(call.getOperands(), 2, operand -> DateTimes.inferTzFromString((String)RexLiteral.stringValue((RexNode)operand)), plannerContext.getTimeZone());
        return DruidExpression.ofFunctionCall(Calcites.getColumnTypeForRelDataType(rexNode.getType()), "timestamp_parse", (List<DruidExpression>)ImmutableList.of((Object)timeExpression, (Object)DruidExpression.ofStringLiteral(pattern), (Object)DruidExpression.ofStringLiteral(timeZone.getID())));
    }
}

