/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.Aggregations;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public abstract class SimpleSqlAggregator
implements SqlAggregator {
    @Override
    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry, RexBuilder rexBuilder, String name, AggregateCall aggregateCall, Project project, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        if (aggregateCall.isDistinct()) {
            return null;
        }
        List<DruidExpression> arguments = Aggregations.getArgumentsForSimpleAggregator(plannerContext, rowSignature, aggregateCall, project);
        if (arguments == null) {
            return null;
        }
        DruidExpression arg = (DruidExpression)Iterables.getOnlyElement(arguments);
        ExprMacroTable macroTable = plannerContext.getExprMacroTable();
        String fieldName = arg.isDirectColumnAccess() ? arg.getDirectColumn() : virtualColumnRegistry.getOrCreateVirtualColumnForExpression(arg, aggregateCall.getType());
        return this.getAggregation(name, aggregateCall, macroTable, fieldName);
    }

    abstract Aggregation getAggregation(String var1, AggregateCall var2, ExprMacroTable var3, String var4);
}

