/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.sql.calcite.expression.DruidExpression;

public class DimensionExpression {
    private final String virtualColumn;
    private final String outputName;
    private final DruidExpression expression;
    private final ColumnType outputType;

    public static DimensionExpression ofSimpleColumn(String outputName, DruidExpression expression, ColumnType outputType) {
        return new DimensionExpression(outputName, outputName, expression, outputType);
    }

    public static DimensionExpression ofVirtualColumn(String virtualColumn, String outputName, DruidExpression expression, ColumnType outputType) {
        return new DimensionExpression(virtualColumn, outputName, expression, outputType);
    }

    private DimensionExpression(String virtualColumn, String outputName, DruidExpression expression, ColumnType outputType) {
        Preconditions.checkArgument((!expression.isSimpleExtraction() || outputName.equals(virtualColumn) ? 1 : 0) != 0);
        this.virtualColumn = virtualColumn;
        this.outputName = outputName;
        this.expression = expression;
        this.outputType = outputType;
    }

    public String getVirtualColumn() {
        return this.virtualColumn;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public DruidExpression getDruidExpression() {
        return this.expression;
    }

    public DimensionSpec toDimensionSpec() {
        if (this.expression.isSimpleExtraction()) {
            return this.expression.getSimpleExtraction().toDimensionSpec(this.outputName, this.outputType);
        }
        return new DefaultDimensionSpec(this.virtualColumn, this.outputName, this.outputType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionExpression that = (DimensionExpression)o;
        return Objects.equals(this.virtualColumn, that.virtualColumn) && Objects.equals(this.outputName, that.outputName) && Objects.equals(this.expression, that.expression) && this.outputType == that.outputType;
    }

    public int hashCode() {
        return Objects.hash(this.virtualColumn, this.outputName, this.expression, this.outputType);
    }

    public String toString() {
        return "DimensionExpression{virtualColumn='" + this.virtualColumn + '\'' + ", outputName='" + this.outputName + '\'' + ", expression=" + this.expression + ", outputType=" + this.outputType + '}';
    }
}

