/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.calcite.avatica.Meta;
import org.apache.druid.sql.DirectStatement;
import org.apache.druid.sql.SqlQueryPlus;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.avatica.AbstractDruidJdbcStatement;
import org.apache.druid.sql.avatica.DruidJdbcResultSet;

public class DruidJdbcStatement
extends AbstractDruidJdbcStatement {
    private final SqlStatementFactory lifecycleFactory;
    protected final Map<String, Object> queryContext;

    public DruidJdbcStatement(String connectionId, int statementId, Map<String, Object> queryContext, SqlStatementFactory lifecycleFactory, DruidJdbcResultSet.ResultFetcherFactory fetcherFactory) {
        super(connectionId, statementId, fetcherFactory);
        this.queryContext = queryContext;
        this.lifecycleFactory = (SqlStatementFactory)Preconditions.checkNotNull((Object)lifecycleFactory, (Object)"lifecycleFactory");
    }

    public synchronized void execute(SqlQueryPlus queryPlus, long maxRowCount) {
        this.closeResultSet();
        queryPlus = queryPlus.withContext(this.queryContext);
        DirectStatement stmt = this.lifecycleFactory.directStatement(queryPlus);
        this.resultSet = new DruidJdbcResultSet(this, stmt, Long.MAX_VALUE, this.fetcherFactory);
        try {
            this.resultSet.execute();
        }
        catch (Throwable t) {
            this.closeResultSet();
            throw t;
        }
    }

    @Override
    public Meta.Signature getSignature() {
        return this.requireResultSet().getSignature();
    }
}

