/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.server.QueryStats;
import org.apache.druid.server.RequestLogLine;
import org.apache.druid.sql.AbstractStatement;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.joda.time.DateTime;

public class SqlExecutionReporter {
    private static final Logger log = new Logger(SqlExecutionReporter.class);
    private final AbstractStatement stmt;
    private final String remoteAddress;
    private final long startMs;
    private final long startNs;
    private Throwable e;
    private long bytesWritten;
    private long planningTimeNanos;

    public SqlExecutionReporter(AbstractStatement stmt, String remoteAddress) {
        this.stmt = stmt;
        this.remoteAddress = remoteAddress;
        this.startMs = System.currentTimeMillis();
        this.startNs = System.nanoTime();
    }

    public void failed(Throwable e) {
        this.e = e;
    }

    public void succeeded(long bytesWritten) {
        this.bytesWritten = bytesWritten;
    }

    public void planningTimeNanos(long planningTimeNanos) {
        this.planningTimeNanos = planningTimeNanos;
    }

    public void emit() {
        boolean success = this.e == null;
        long queryTimeNs = System.nanoTime() - this.startNs;
        ServiceEmitter emitter = this.stmt.sqlToolbox.emitter;
        PlannerContext plannerContext = this.stmt.plannerContext;
        try {
            ServiceMetricEvent.Builder metricBuilder = ServiceMetricEvent.builder();
            if (plannerContext != null) {
                metricBuilder.setDimension("id", (Object)plannerContext.getSqlQueryId());
                metricBuilder.setDimension("nativeQueryIds", (Object)plannerContext.getNativeQueryIds().toString());
            }
            if (this.stmt.authResult != null) {
                metricBuilder.setDimension("dataSource", (Object)this.stmt.authResult.sqlResourceActions.stream().map(action -> action.getResource().getName()).collect(Collectors.toList()).toString());
            }
            metricBuilder.setDimension("remoteAddress", (Object)StringUtils.nullToEmptyNonDruidDataString((String)this.remoteAddress));
            metricBuilder.setDimension("success", (Object)String.valueOf(success));
            emitter.emit(metricBuilder.build("sqlQuery/time", (Number)TimeUnit.NANOSECONDS.toMillis(queryTimeNs)));
            if (this.bytesWritten >= 0L) {
                emitter.emit(metricBuilder.build("sqlQuery/bytes", (Number)this.bytesWritten));
            }
            if (this.planningTimeNanos >= 0L) {
                emitter.emit(metricBuilder.build("sqlQuery/planningTimeMs", (Number)TimeUnit.NANOSECONDS.toMillis(this.planningTimeNanos)));
            }
            LinkedHashMap<String, Object> statsMap = new LinkedHashMap<String, Object>();
            statsMap.put("sqlQuery/time", TimeUnit.NANOSECONDS.toMillis(queryTimeNs));
            statsMap.put("sqlQuery/planningTimeMs", TimeUnit.NANOSECONDS.toMillis(this.planningTimeNanos));
            statsMap.put("sqlQuery/bytes", this.bytesWritten);
            statsMap.put("success", success);
            Map<String, Object> queryContext = this.stmt.queryContext;
            if (plannerContext != null) {
                statsMap.put("identity", plannerContext.getAuthenticationResult().getIdentity());
                queryContext.put("nativeQueryIds", plannerContext.getNativeQueryIds().toString());
            }
            statsMap.put("context", queryContext);
            if (this.e != null) {
                statsMap.put("exception", this.e.toString());
                if (this.e instanceof QueryInterruptedException || this.e instanceof QueryTimeoutException) {
                    statsMap.put("interrupted", true);
                    statsMap.put("reason", this.e.toString());
                }
            }
            this.stmt.sqlToolbox.requestLogger.logSqlQuery(RequestLogLine.forSql((String)this.stmt.queryPlus.sql(), queryContext, (DateTime)DateTimes.utc((long)this.startMs), (String)this.remoteAddress, (QueryStats)new QueryStats(statsMap)));
        }
        catch (Exception ex) {
            log.error((Throwable)ex, "Unable to log SQL [%s]!", new Object[]{this.stmt.queryPlus.sql()});
        }
    }
}

