/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.guice;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Module;
import java.util.Properties;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.PolyBind;
import org.apache.druid.sql.avatica.AvaticaModule;
import org.apache.druid.sql.calcite.aggregation.SqlAggregationModule;
import org.apache.druid.sql.calcite.expression.builtin.QueryLookupOperatorConversion;
import org.apache.druid.sql.calcite.planner.CalcitePlannerModule;
import org.apache.druid.sql.calcite.schema.DruidCalciteSchemaModule;
import org.apache.druid.sql.calcite.schema.DruidSchemaManager;
import org.apache.druid.sql.calcite.schema.NoopDruidSchemaManager;
import org.apache.druid.sql.calcite.view.DruidViewModule;
import org.apache.druid.sql.calcite.view.NoopViewManager;
import org.apache.druid.sql.calcite.view.ViewManager;
import org.apache.druid.sql.guice.SqlBindings;
import org.apache.druid.sql.http.SqlHttpModule;

public class SqlModule
implements Module {
    public static final String PROPERTY_SQL_ENABLE = "druid.sql.enable";
    public static final String PROPERTY_SQL_ENABLE_JSON_OVER_HTTP = "druid.sql.http.enable";
    public static final String PROPERTY_SQL_ENABLE_AVATICA = "druid.sql.avatica.enable";
    public static final String PROPERTY_SQL_VIEW_MANAGER_TYPE = "druid.sql.viewmanager.type";
    public static final String PROPERTY_SQL_SCHEMA_MANAGER_TYPE = "druid.sql.schemamanager.type";
    public static final String PROPERTY_SQL_APPROX_COUNT_DISTINCT_CHOICE = "druid.sql.approxCountDistinct.function";
    @Inject
    private Properties props;

    public SqlModule() {
    }

    @VisibleForTesting
    public SqlModule(Properties props) {
        this.props = props;
    }

    public void configure(Binder binder) {
        if (!this.isEnabled()) {
            return;
        }
        PolyBind.optionBinder((Binder)binder, (Key)Key.get(ViewManager.class)).addBinding((Object)"noop").to(NoopViewManager.class).in(LazySingleton.class);
        PolyBind.createChoiceWithDefault((Binder)binder, (String)PROPERTY_SQL_VIEW_MANAGER_TYPE, (Key)Key.get(ViewManager.class), (String)"noop");
        PolyBind.optionBinder((Binder)binder, (Key)Key.get(DruidSchemaManager.class)).addBinding((Object)"noop").to(NoopDruidSchemaManager.class).in(LazySingleton.class);
        PolyBind.createChoiceWithDefault((Binder)binder, (String)PROPERTY_SQL_SCHEMA_MANAGER_TYPE, (Key)Key.get(DruidSchemaManager.class), (String)"noop");
        binder.install((Module)new DruidCalciteSchemaModule());
        binder.install((Module)new CalcitePlannerModule());
        binder.install((Module)new SqlAggregationModule());
        binder.install((Module)new DruidViewModule());
        SqlBindings.addOperatorConversion(binder, QueryLookupOperatorConversion.class);
        if (this.isJsonOverHttpEnabled()) {
            binder.install((Module)new SqlHttpModule());
        }
        if (this.isAvaticaEnabled()) {
            binder.install((Module)new AvaticaModule());
        }
    }

    private boolean isEnabled() {
        Preconditions.checkNotNull((Object)this.props, (Object)"props");
        return Boolean.valueOf(this.props.getProperty(PROPERTY_SQL_ENABLE, "true"));
    }

    private boolean isJsonOverHttpEnabled() {
        Preconditions.checkNotNull((Object)this.props, (Object)"props");
        return Boolean.valueOf(this.props.getProperty(PROPERTY_SQL_ENABLE_JSON_OVER_HTTP, "true"));
    }

    private boolean isAvaticaEnabled() {
        Preconditions.checkNotNull((Object)this.props, (Object)"props");
        return Boolean.valueOf(this.props.getProperty(PROPERTY_SQL_ENABLE_AVATICA, "true"));
    }
}

