/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.run;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Pair;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.run.EngineFeature;
import org.apache.druid.sql.calcite.run.NativeQueryMaker;
import org.apache.druid.sql.calcite.run.QueryMaker;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.run.SqlEngines;

@LazySingleton
public class NativeSqlEngine
implements SqlEngine {
    public static final Set<String> SYSTEM_CONTEXT_PARAMETERS = ImmutableSet.of((Object)"maxTimeArrayOutputName", (Object)"minTimeArrayOutputName", (Object)"timestampResultField", (Object)"timestampResultFieldGranularity", (Object)"timestampResultFieldInOriginalDimensions", (Object)"scanSignature", (Object[])new String[]{"sqlInsertSegmentGranularity", "sqlReplaceTimeChunks"});
    private static final String NAME = "native";
    private final QueryLifecycleFactory queryLifecycleFactory;
    private final ObjectMapper jsonMapper;

    @Inject
    public NativeSqlEngine(QueryLifecycleFactory queryLifecycleFactory, ObjectMapper jsonMapper) {
        this.queryLifecycleFactory = queryLifecycleFactory;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void validateContext(QueryContext queryContext) throws ValidationException {
        SqlEngines.validateNoSpecialContextKeys(queryContext, SYSTEM_CONTEXT_PARAMETERS);
    }

    @Override
    public RelDataType resultTypeForSelect(RelDataTypeFactory typeFactory, RelDataType validatedRowType) {
        return validatedRowType;
    }

    @Override
    public RelDataType resultTypeForInsert(RelDataTypeFactory typeFactory, RelDataType validatedRowType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean feature(EngineFeature feature, PlannerContext plannerContext) {
        switch (feature) {
            case CAN_SELECT: 
            case ALLOW_BINDABLE_PLAN: 
            case TIMESERIES_QUERY: 
            case TOPN_QUERY: {
                return true;
            }
            case TIME_BOUNDARY_QUERY: {
                return QueryContexts.isTimeBoundaryPlanningEnabled((Map)plannerContext.getQueryContext().getMergedParams());
            }
            case CAN_INSERT: 
            case CAN_REPLACE: 
            case READ_EXTERNAL_DATA: 
            case SCAN_ORDER_BY_NON_TIME: 
            case SCAN_NEEDS_SIGNATURE: {
                return false;
            }
        }
        throw new IAE("Unrecognized feature: %s", new Object[]{feature});
    }

    @Override
    public QueryMaker buildQueryMakerForSelect(RelRoot relRoot, PlannerContext plannerContext) {
        return new NativeQueryMaker(this.queryLifecycleFactory, plannerContext, this.jsonMapper, (List<Pair<Integer, String>>)relRoot.fields);
    }

    @Override
    public QueryMaker buildQueryMakerForInsert(String targetDataSource, RelRoot relRoot, PlannerContext plannerContext) {
        throw new UnsupportedOperationException();
    }
}

