/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.CannotBuildQueryException;
import org.apache.druid.sql.calcite.rel.DruidConvention;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.DruidRel;
import org.apache.druid.sql.calcite.rel.DruidRels;
import org.apache.druid.sql.calcite.rel.PartialDruidQuery;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class DruidUnionDataSourceRel
extends DruidRel<DruidUnionDataSourceRel> {
    private static final TableDataSource DUMMY_DATA_SOURCE = new TableDataSource("__union__");
    private final Union unionRel;
    private final List<String> unionColumnNames;
    private final PartialDruidQuery partialQuery;

    private DruidUnionDataSourceRel(RelOptCluster cluster, RelTraitSet traitSet, Union unionRel, List<String> unionColumnNames, PartialDruidQuery partialQuery, PlannerContext plannerContext) {
        super(cluster, traitSet, plannerContext);
        this.unionRel = unionRel;
        this.unionColumnNames = unionColumnNames;
        this.partialQuery = partialQuery;
    }

    public static DruidUnionDataSourceRel create(Union unionRel, List<String> unionColumnNames, PlannerContext plannerContext) {
        return new DruidUnionDataSourceRel(unionRel.getCluster(), unionRel.getTraitSet(), unionRel, unionColumnNames, PartialDruidQuery.create((RelNode)unionRel), plannerContext);
    }

    public List<String> getUnionColumnNames() {
        return this.unionColumnNames;
    }

    @Override
    public PartialDruidQuery getPartialDruidQuery() {
        return this.partialQuery;
    }

    @Override
    public DruidUnionDataSourceRel withPartialQuery(PartialDruidQuery newQueryBuilder) {
        return new DruidUnionDataSourceRel(this.getCluster(), this.getTraitSet().plusAll(newQueryBuilder.getRelTraits()), this.unionRel, this.unionColumnNames, newQueryBuilder, this.getPlannerContext());
    }

    @Override
    public DruidQuery toDruidQuery(boolean finalizeAggregations) {
        ArrayList<TableDataSource> dataSources = new ArrayList<TableDataSource>();
        RowSignature signature = null;
        for (RelNode relNode : this.unionRel.getInputs()) {
            DruidRel druidRel = (DruidRel)relNode;
            if (!DruidRels.isScanOrMapping(druidRel, false)) {
                this.getPlannerContext().setPlanningError("SQL requires union between inputs that are not simple table scans and involve a filter or aliasing", new Object[0]);
                throw new CannotBuildQueryException((RelNode)druidRel);
            }
            DruidQuery query = druidRel.toDruidQuery(false);
            DataSource dataSource = query.getDataSource();
            if (!(dataSource instanceof TableDataSource)) {
                this.getPlannerContext().setPlanningError("SQL requires union with input of '%s' type that is not supported. Union operation is only supported between regular tables. ", dataSource.getClass().getSimpleName());
                throw new CannotBuildQueryException((RelNode)druidRel);
            }
            if (signature == null) {
                signature = query.getOutputRowSignature();
            }
            if (signature.getColumnNames().equals(query.getOutputRowSignature().getColumnNames())) {
                dataSources.add((TableDataSource)dataSource);
                continue;
            }
            this.getPlannerContext().setPlanningError("There is a mismatch between the output row signature of input tables and the row signature of union output.", new Object[0]);
            throw new CannotBuildQueryException((RelNode)druidRel);
        }
        if (signature == null) {
            throw new CannotBuildQueryException((RelNode)this.unionRel);
        }
        if (!signature.getColumnNames().equals(this.unionColumnNames)) {
            throw new CannotBuildQueryException((RelNode)this.unionRel);
        }
        return this.partialQuery.build((DataSource)new UnionDataSource(dataSources), signature, this.getPlannerContext(), this.getCluster().getRexBuilder(), finalizeAggregations);
    }

    @Override
    public DruidQuery toDruidQueryForExplaining() {
        return this.partialQuery.build((DataSource)DUMMY_DATA_SOURCE, RowSignatures.fromRelDataType(this.unionRel.getRowType().getFieldNames(), this.unionRel.getRowType()), this.getPlannerContext(), this.getCluster().getRexBuilder(), false);
    }

    @Override
    public DruidUnionDataSourceRel asDruidConvention() {
        return new DruidUnionDataSourceRel(this.getCluster(), this.getTraitSet().replace((RelTrait)DruidConvention.instance()), (Union)this.unionRel.copy(this.unionRel.getTraitSet(), this.unionRel.getInputs().stream().map(input -> RelOptRule.convert((RelNode)input, (RelTrait)DruidConvention.instance())).collect(Collectors.toList())), this.unionColumnNames, this.partialQuery, this.getPlannerContext());
    }

    public List<RelNode> getInputs() {
        return this.unionRel.getInputs();
    }

    public void replaceInput(int ordinalInParent, RelNode p) {
        this.unionRel.replaceInput(ordinalInParent, p);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DruidUnionDataSourceRel(this.getCluster(), traitSet, (Union)this.unionRel.copy(this.unionRel.getTraitSet(), inputs), this.unionColumnNames, this.partialQuery, this.getPlannerContext());
    }

    @Override
    public Set<String> getDataSourceNames() {
        HashSet<String> retVal = new HashSet<String>();
        for (RelNode input : this.unionRel.getInputs()) {
            retVal.addAll(((DruidRel)input).getDataSourceNames());
        }
        return retVal;
    }

    public RelWriter explainTerms(RelWriter pw) {
        String queryString;
        DruidQuery druidQuery = this.toDruidQueryForExplaining();
        try {
            queryString = this.getPlannerContext().getJsonMapper().writeValueAsString((Object)druidQuery.getQuery());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < this.unionRel.getInputs().size(); ++i) {
            pw.input(StringUtils.format((String)"input#%d", (Object[])new Object[]{i}), (RelNode)this.unionRel.getInputs().get(i));
        }
        return pw.item("query", (Object)queryString).item("signature", (Object)druidQuery.getOutputRowSignature());
    }

    protected RelDataType deriveRowType() {
        return this.partialQuery.getRowType();
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeZeroCost();
    }
}

