/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Properties;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.ValidationException;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.NoopEscalator;
import org.apache.druid.sql.calcite.parser.DruidSqlParserImplFactory;
import org.apache.druid.sql.calcite.planner.CalciteRulesManager;
import org.apache.druid.sql.calcite.planner.DruidConformance;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.DruidPlanner;
import org.apache.druid.sql.calcite.planner.DruidRexExecutor;
import org.apache.druid.sql.calcite.planner.DruidTypeSystem;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.convertlet.DruidConvertletTable;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.schema.DruidSchemaName;

public class PlannerFactory {
    static final SqlParser.Config PARSER_CONFIG = SqlParser.configBuilder().setCaseSensitive(true).setUnquotedCasing(Casing.UNCHANGED).setQuotedCasing(Casing.UNCHANGED).setQuoting(Quoting.DOUBLE_QUOTE).setConformance((SqlConformance)DruidConformance.instance()).setParserFactory((SqlParserImplFactory)new DruidSqlParserImplFactory()).build();
    private final DruidSchemaCatalog rootSchema;
    private final DruidOperatorTable operatorTable;
    private final ExprMacroTable macroTable;
    private final PlannerConfig plannerConfig;
    private final ObjectMapper jsonMapper;
    private final AuthorizerMapper authorizerMapper;
    private final String druidSchemaName;
    private final CalciteRulesManager calciteRuleManager;

    @Inject
    public PlannerFactory(DruidSchemaCatalog rootSchema, DruidOperatorTable operatorTable, ExprMacroTable macroTable, PlannerConfig plannerConfig, AuthorizerMapper authorizerMapper, @Json ObjectMapper jsonMapper, @DruidSchemaName String druidSchemaName, CalciteRulesManager calciteRuleManager) {
        this.rootSchema = rootSchema;
        this.operatorTable = operatorTable;
        this.macroTable = macroTable;
        this.plannerConfig = plannerConfig;
        this.authorizerMapper = authorizerMapper;
        this.jsonMapper = jsonMapper;
        this.druidSchemaName = druidSchemaName;
        this.calciteRuleManager = calciteRuleManager;
    }

    public DruidPlanner createPlanner(SqlEngine engine, String sql, QueryContext queryContext) {
        PlannerContext context = PlannerContext.create(sql, this.operatorTable, this.macroTable, this.jsonMapper, this.plannerConfig, this.rootSchema, engine, queryContext);
        return new DruidPlanner(this.buildFrameworkConfig(context), context, engine);
    }

    @VisibleForTesting
    public DruidPlanner createPlannerForTesting(SqlEngine engine, String sql, QueryContext queryContext) {
        DruidPlanner thePlanner = this.createPlanner(engine, sql, queryContext);
        thePlanner.getPlannerContext().setAuthenticationResult(NoopEscalator.getInstance().createEscalatedAuthenticationResult());
        try {
            thePlanner.validate();
        }
        catch (SqlParseException | ValidationException e) {
            throw new RuntimeException(e);
        }
        thePlanner.authorize(ra -> Access.OK, false);
        return thePlanner;
    }

    public AuthorizerMapper getAuthorizerMapper() {
        return this.authorizerMapper;
    }

    private FrameworkConfig buildFrameworkConfig(PlannerContext plannerContext) {
        SqlToRelConverter.Config sqlToRelConverterConfig = SqlToRelConverter.configBuilder().withExpand(false).withDecorrelationEnabled(false).withTrimUnusedFields(false).withInSubQueryThreshold(QueryContexts.getInSubQueryThreshold((Map)plannerContext.getQueryContext().getMergedParams())).build();
        return Frameworks.newConfigBuilder().parserConfig(PARSER_CONFIG).traitDefs(new RelTraitDef[]{ConventionTraitDef.INSTANCE, RelCollationTraitDef.INSTANCE}).convertletTable((SqlRexConvertletTable)new DruidConvertletTable(plannerContext)).operatorTable((SqlOperatorTable)this.operatorTable).programs(this.calciteRuleManager.programs(plannerContext)).executor((RexExecutor)new DruidRexExecutor(plannerContext)).typeSystem((RelDataTypeSystem)DruidTypeSystem.INSTANCE).defaultSchema(this.rootSchema.getSubSchema(this.druidSchemaName)).sqlToRelConverterConfig(sqlToRelConverterConfig).context(new Context(){

            public <C> C unwrap(Class<C> aClass) {
                if (aClass.equals(CalciteConnectionConfig.class)) {
                    Properties props = new Properties();
                    return (C)new CalciteConnectionConfigImpl(props){

                        public <T> T typeSystem(Class<T> typeSystemClass, T defaultTypeSystem) {
                            return (T)DruidTypeSystem.INSTANCE;
                        }

                        public SqlConformance conformance() {
                            return DruidConformance.instance();
                        }
                    };
                }
                return null;
            }
        }).build();
    }
}

