/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Numbers;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.QueryContext;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;
import org.apache.druid.sql.calcite.run.EngineFeature;
import org.apache.druid.sql.calcite.run.QueryMaker;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class PlannerContext {
    public static final String CTX_SQL_QUERY_ID = "sqlQueryId";
    public static final String CTX_SQL_CURRENT_TIMESTAMP = "sqlCurrentTimestamp";
    public static final String CTX_SQL_TIME_ZONE = "sqlTimeZone";
    public static final String CTX_SQL_STRINGIFY_ARRAYS = "sqlStringifyArrays";
    public static final String CTX_SQL_OUTER_LIMIT = "sqlOuterLimit";
    public static final String DATA_CTX_AUTHENTICATION_RESULT = "authenticationResult";
    private final String sql;
    private final DruidOperatorTable operatorTable;
    private final ExprMacroTable macroTable;
    private final ObjectMapper jsonMapper;
    private final PlannerConfig plannerConfig;
    private final DateTime localNow;
    private final DruidSchemaCatalog rootSchema;
    private final SqlEngine engine;
    private final QueryContext queryContext;
    private final String sqlQueryId;
    private final boolean stringifyArrays;
    private final CopyOnWriteArrayList<String> nativeQueryIds = new CopyOnWriteArrayList();
    private List<TypedValue> parameters = Collections.emptyList();
    private AuthenticationResult authenticationResult;
    private Set<ResourceAction> resourceActions;
    private Access authorizationResult;
    @Nullable
    private String planningError;
    private QueryMaker queryMaker;
    private VirtualColumnRegistry joinExpressionVirtualColumnRegistry;

    private PlannerContext(String sql, DruidOperatorTable operatorTable, ExprMacroTable macroTable, ObjectMapper jsonMapper, PlannerConfig plannerConfig, DateTime localNow, boolean stringifyArrays, DruidSchemaCatalog rootSchema, SqlEngine engine, QueryContext queryContext) {
        this.sql = sql;
        this.operatorTable = operatorTable;
        this.macroTable = macroTable;
        this.jsonMapper = jsonMapper;
        this.plannerConfig = (PlannerConfig)Preconditions.checkNotNull((Object)plannerConfig, (Object)"plannerConfig");
        this.rootSchema = rootSchema;
        this.engine = engine;
        this.queryContext = queryContext;
        this.localNow = (DateTime)Preconditions.checkNotNull((Object)localNow, (Object)"localNow");
        this.stringifyArrays = stringifyArrays;
        String sqlQueryId = (String)this.queryContext.get(CTX_SQL_QUERY_ID);
        if (Strings.isNullOrEmpty((String)sqlQueryId)) {
            sqlQueryId = UUID.randomUUID().toString();
        }
        this.sqlQueryId = sqlQueryId;
    }

    public static PlannerContext create(String sql, DruidOperatorTable operatorTable, ExprMacroTable macroTable, ObjectMapper jsonMapper, PlannerConfig plannerConfig, DruidSchemaCatalog rootSchema, SqlEngine engine, QueryContext queryContext) {
        Object stringifyParam = queryContext.get(CTX_SQL_STRINGIFY_ARRAYS);
        Object tsParam = queryContext.get(CTX_SQL_CURRENT_TIMESTAMP);
        Object tzParam = queryContext.get(CTX_SQL_TIME_ZONE);
        DateTime utcNow = tsParam != null ? new DateTime(tsParam, DateTimeZone.UTC) : new DateTime(DateTimeZone.UTC);
        DateTimeZone timeZone = tzParam != null ? DateTimes.inferTzFromString((String)String.valueOf(tzParam)) : plannerConfig.getSqlTimeZone();
        boolean stringifyArrays = stringifyParam != null ? Numbers.parseBoolean((Object)stringifyParam) : true;
        return new PlannerContext(sql, operatorTable, macroTable, jsonMapper, plannerConfig.withOverrides(queryContext), utcNow.withZone(timeZone), stringifyArrays, rootSchema, engine, queryContext);
    }

    public DruidOperatorTable getOperatorTable() {
        return this.operatorTable;
    }

    public ExprMacroTable getExprMacroTable() {
        return this.macroTable;
    }

    public ObjectMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public PlannerConfig getPlannerConfig() {
        return this.plannerConfig;
    }

    public DateTime getLocalNow() {
        return this.localNow;
    }

    public DateTimeZone getTimeZone() {
        return this.localNow.getZone();
    }

    @Nullable
    public String getSchemaResourceType(String schema, String resourceName) {
        return this.rootSchema.getResourceType(schema, resourceName);
    }

    public QueryContext getQueryContext() {
        return this.queryContext;
    }

    public boolean isStringifyArrays() {
        return this.stringifyArrays;
    }

    public List<TypedValue> getParameters() {
        return this.parameters;
    }

    public AuthenticationResult getAuthenticationResult() {
        return (AuthenticationResult)Preconditions.checkNotNull((Object)this.authenticationResult, (Object)"Authentication result not available");
    }

    public String getSql() {
        return this.sql;
    }

    public String getSqlQueryId() {
        return this.sqlQueryId;
    }

    public CopyOnWriteArrayList<String> getNativeQueryIds() {
        return this.nativeQueryIds;
    }

    public void addNativeQueryId(String queryId) {
        this.nativeQueryIds.add(queryId);
    }

    @Nullable
    public String getPlanningError() {
        return this.planningError;
    }

    public void setPlanningError(String formatText, Object ... arguments) {
        this.planningError = StringUtils.nonStrictFormat((String)formatText, (Object[])arguments);
    }

    public DataContext createDataContext(final JavaTypeFactory typeFactory, final List<TypedValue> parameters) {
        class DruidDataContext
        implements DataContext {
            private final Map<String, Object> base_context;
            private final Map<String, Object> context;

            DruidDataContext() {
                this.base_context = ImmutableMap.of((Object)DataContext.Variable.UTC_TIMESTAMP.camelName, (Object)PlannerContext.this.localNow.getMillis(), (Object)DataContext.Variable.CURRENT_TIMESTAMP.camelName, (Object)PlannerContext.this.localNow.getMillis(), (Object)DataContext.Variable.LOCAL_TIMESTAMP.camelName, (Object)new Interval((ReadableInstant)new DateTime((Object)"1970-01-01T00:00:00.000", PlannerContext.this.localNow.getZone()), (ReadableInstant)PlannerContext.this.localNow).toDurationMillis(), (Object)DataContext.Variable.TIME_ZONE.camelName, (Object)PlannerContext.this.localNow.getZone().toTimeZone().clone());
                ImmutableMap.Builder builder = ImmutableMap.builder();
                builder.putAll(this.base_context);
                int i = 0;
                for (TypedValue parameter : parameters) {
                    builder.put((Object)("?" + i), parameter.value);
                    ++i;
                }
                if (PlannerContext.this.authenticationResult != null) {
                    builder.put((Object)PlannerContext.DATA_CTX_AUTHENTICATION_RESULT, (Object)PlannerContext.this.authenticationResult);
                }
                this.context = builder.build();
            }

            public SchemaPlus getRootSchema() {
                throw new UnsupportedOperationException();
            }

            public JavaTypeFactory getTypeFactory() {
                return typeFactory;
            }

            public QueryProvider getQueryProvider() {
                throw new UnsupportedOperationException();
            }

            public Object get(String name) {
                return this.context.get(name);
            }
        }
        return new DruidDataContext();
    }

    public Access getAuthorizationResult() {
        return (Access)Preconditions.checkNotNull((Object)this.authorizationResult, (Object)"Authorization result not available");
    }

    public void setParameters(List<TypedValue> parameters) {
        this.parameters = (List)Preconditions.checkNotNull(parameters, (Object)"parameters");
    }

    public void setAuthenticationResult(AuthenticationResult authenticationResult) {
        if (this.authenticationResult != null) {
            throw new ISE("Authentication result has already been set", new Object[0]);
        }
        this.authenticationResult = (AuthenticationResult)Preconditions.checkNotNull((Object)authenticationResult, (Object)DATA_CTX_AUTHENTICATION_RESULT);
    }

    public void setAuthorizationResult(Access access) {
        if (this.authorizationResult != null) {
            throw new ISE("Authorization result has already been set", new Object[0]);
        }
        this.authorizationResult = (Access)Preconditions.checkNotNull((Object)access, (Object)"authorizationResult");
    }

    public Set<ResourceAction> getResourceActions() {
        return (Set)Preconditions.checkNotNull(this.resourceActions, (Object)"Resources not available");
    }

    public void setResourceActions(Set<ResourceAction> resourceActions) {
        if (this.resourceActions != null) {
            throw new ISE("Resources have already been set", new Object[0]);
        }
        this.resourceActions = (Set)Preconditions.checkNotNull(resourceActions, (Object)"resourceActions");
    }

    public void setQueryMaker(QueryMaker queryMaker) {
        if (this.queryMaker != null) {
            throw new ISE("QueryMaker has already been set", new Object[0]);
        }
        this.queryMaker = (QueryMaker)Preconditions.checkNotNull((Object)queryMaker, (Object)"queryMaker");
    }

    public SqlEngine getEngine() {
        return this.engine;
    }

    public boolean engineHasFeature(EngineFeature feature) {
        return this.engine.feature(feature, this);
    }

    public QueryMaker getQueryMaker() {
        return (QueryMaker)Preconditions.checkNotNull((Object)this.queryMaker, (Object)"QueryMaker not available");
    }

    public VirtualColumnRegistry getJoinExpressionVirtualColumnRegistry() {
        return this.joinExpressionVirtualColumnRegistry;
    }

    public void setJoinExpressionVirtualColumnRegistry(VirtualColumnRegistry joinExpressionVirtualColumnRegistry) {
        this.joinExpressionVirtualColumnRegistry = joinExpressionVirtualColumnRegistry;
    }
}

