/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.QueryContext;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;

public class PlannerConfig {
    public static final String CTX_KEY_USE_APPROXIMATE_COUNT_DISTINCT = "useApproximateCountDistinct";
    public static final String CTX_KEY_USE_GROUPING_SET_FOR_EXACT_DISTINCT = "useGroupingSetForExactDistinct";
    public static final String CTX_KEY_USE_APPROXIMATE_TOPN = "useApproximateTopN";
    public static final String CTX_COMPUTE_INNER_JOIN_COST_AS_FILTER = "computeInnerJoinCostAsFilter";
    public static final String CTX_KEY_USE_NATIVE_QUERY_EXPLAIN = "useNativeQueryExplain";
    public static final String CTX_KEY_FORCE_EXPRESSION_VIRTUAL_COLUMNS = "forceExpressionVirtualColumns";
    public static final String CTX_MAX_NUMERIC_IN_FILTERS = "maxNumericInFilters";
    public static final int NUM_FILTER_NOT_USED = -1;
    @JsonProperty
    private Period metadataRefreshPeriod = new Period((Object)"PT1M");
    @JsonProperty
    private int maxTopNLimit = 100000;
    @JsonProperty
    private boolean useApproximateCountDistinct = true;
    @JsonProperty
    private boolean useApproximateTopN = true;
    @JsonProperty
    private boolean requireTimeCondition = false;
    @JsonProperty
    private boolean awaitInitializationOnStart = true;
    @JsonProperty
    private DateTimeZone sqlTimeZone = DateTimeZone.UTC;
    @JsonProperty
    private boolean metadataSegmentCacheEnable = false;
    @JsonProperty
    private long metadataSegmentPollPeriod = 60000L;
    @JsonProperty
    private boolean useGroupingSetForExactDistinct = false;
    @JsonProperty
    private boolean computeInnerJoinCostAsFilter = true;
    @JsonProperty
    private boolean authorizeSystemTablesDirectly = false;
    @JsonProperty
    private boolean useNativeQueryExplain = true;
    @JsonProperty
    private boolean forceExpressionVirtualColumns = false;
    @JsonProperty
    private int maxNumericInFilters = -1;
    private boolean serializeComplexValues = true;

    public long getMetadataSegmentPollPeriod() {
        return this.metadataSegmentPollPeriod;
    }

    public int getMaxNumericInFilters() {
        return this.maxNumericInFilters;
    }

    public boolean isMetadataSegmentCacheEnable() {
        return this.metadataSegmentCacheEnable;
    }

    public Period getMetadataRefreshPeriod() {
        return this.metadataRefreshPeriod;
    }

    public int getMaxTopNLimit() {
        return this.maxTopNLimit;
    }

    public boolean isUseApproximateCountDistinct() {
        return this.useApproximateCountDistinct;
    }

    public boolean isUseGroupingSetForExactDistinct() {
        return this.useGroupingSetForExactDistinct;
    }

    public boolean isUseApproximateTopN() {
        return this.useApproximateTopN;
    }

    public boolean isRequireTimeCondition() {
        return this.requireTimeCondition;
    }

    public DateTimeZone getSqlTimeZone() {
        return this.sqlTimeZone;
    }

    public boolean isAwaitInitializationOnStart() {
        return this.awaitInitializationOnStart;
    }

    public boolean shouldSerializeComplexValues() {
        return this.serializeComplexValues;
    }

    public boolean isComputeInnerJoinCostAsFilter() {
        return this.computeInnerJoinCostAsFilter;
    }

    public boolean isAuthorizeSystemTablesDirectly() {
        return this.authorizeSystemTablesDirectly;
    }

    public boolean isUseNativeQueryExplain() {
        return this.useNativeQueryExplain;
    }

    public boolean isForceExpressionVirtualColumns() {
        return this.forceExpressionVirtualColumns;
    }

    public PlannerConfig withOverrides(QueryContext queryContext) {
        if (queryContext.isEmpty()) {
            return this;
        }
        return this.toBuilder().withOverrides(queryContext).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlannerConfig that = (PlannerConfig)o;
        return this.maxTopNLimit == that.maxTopNLimit && this.useApproximateCountDistinct == that.useApproximateCountDistinct && this.useApproximateTopN == that.useApproximateTopN && this.requireTimeCondition == that.requireTimeCondition && this.awaitInitializationOnStart == that.awaitInitializationOnStart && this.metadataSegmentCacheEnable == that.metadataSegmentCacheEnable && this.metadataSegmentPollPeriod == that.metadataSegmentPollPeriod && this.serializeComplexValues == that.serializeComplexValues && Objects.equals(this.metadataRefreshPeriod, that.metadataRefreshPeriod) && Objects.equals(this.sqlTimeZone, that.sqlTimeZone) && this.useNativeQueryExplain == that.useNativeQueryExplain && this.forceExpressionVirtualColumns == that.forceExpressionVirtualColumns;
    }

    public int hashCode() {
        return Objects.hash(this.metadataRefreshPeriod, this.maxTopNLimit, this.useApproximateCountDistinct, this.useApproximateTopN, this.requireTimeCondition, this.awaitInitializationOnStart, this.sqlTimeZone, this.metadataSegmentCacheEnable, this.metadataSegmentPollPeriod, this.serializeComplexValues, this.useNativeQueryExplain, this.forceExpressionVirtualColumns);
    }

    public String toString() {
        return "PlannerConfig{metadataRefreshPeriod=" + this.metadataRefreshPeriod + ", maxTopNLimit=" + this.maxTopNLimit + ", useApproximateCountDistinct=" + this.useApproximateCountDistinct + ", useApproximateTopN=" + this.useApproximateTopN + ", requireTimeCondition=" + this.requireTimeCondition + ", awaitInitializationOnStart=" + this.awaitInitializationOnStart + ", metadataSegmentCacheEnable=" + this.metadataSegmentCacheEnable + ", metadataSegmentPollPeriod=" + this.metadataSegmentPollPeriod + ", sqlTimeZone=" + this.sqlTimeZone + ", serializeComplexValues=" + this.serializeComplexValues + ", useNativeQueryExplain=" + this.useNativeQueryExplain + '}';
    }

    public static Builder builder() {
        return new PlannerConfig().toBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private Period metadataRefreshPeriod;
        private int maxTopNLimit;
        private boolean useApproximateCountDistinct;
        private boolean useApproximateTopN;
        private boolean requireTimeCondition;
        private boolean awaitInitializationOnStart;
        private DateTimeZone sqlTimeZone;
        private boolean metadataSegmentCacheEnable;
        private long metadataSegmentPollPeriod;
        private boolean useGroupingSetForExactDistinct;
        private boolean computeInnerJoinCostAsFilter;
        private boolean authorizeSystemTablesDirectly;
        private boolean useNativeQueryExplain;
        private boolean forceExpressionVirtualColumns;
        private int maxNumericInFilters;
        private boolean serializeComplexValues;

        public Builder(PlannerConfig base) {
            this.metadataRefreshPeriod = base.getMetadataRefreshPeriod();
            this.maxTopNLimit = base.getMaxTopNLimit();
            this.useApproximateCountDistinct = base.isUseApproximateCountDistinct();
            this.useApproximateTopN = base.isUseApproximateTopN();
            this.requireTimeCondition = base.isRequireTimeCondition();
            this.awaitInitializationOnStart = base.isAwaitInitializationOnStart();
            this.sqlTimeZone = base.getSqlTimeZone();
            this.metadataSegmentCacheEnable = base.isMetadataSegmentCacheEnable();
            this.useGroupingSetForExactDistinct = base.isUseGroupingSetForExactDistinct();
            this.metadataSegmentPollPeriod = base.getMetadataSegmentPollPeriod();
            this.computeInnerJoinCostAsFilter = base.computeInnerJoinCostAsFilter;
            this.authorizeSystemTablesDirectly = base.isAuthorizeSystemTablesDirectly();
            this.useNativeQueryExplain = base.isUseNativeQueryExplain();
            this.forceExpressionVirtualColumns = base.isForceExpressionVirtualColumns();
            this.maxNumericInFilters = base.getMaxNumericInFilters();
            this.serializeComplexValues = base.shouldSerializeComplexValues();
        }

        public Builder requireTimeCondition(boolean option) {
            this.requireTimeCondition = option;
            return this;
        }

        public Builder maxTopNLimit(int value) {
            this.maxTopNLimit = value;
            return this;
        }

        public Builder maxNumericInFilters(int value) {
            this.maxNumericInFilters = value;
            return this;
        }

        public Builder useApproximateCountDistinct(boolean option) {
            this.useApproximateCountDistinct = option;
            return this;
        }

        public Builder useApproximateTopN(boolean option) {
            this.useApproximateTopN = option;
            return this;
        }

        public Builder useGroupingSetForExactDistinct(boolean option) {
            this.useGroupingSetForExactDistinct = option;
            return this;
        }

        public Builder computeInnerJoinCostAsFilter(boolean option) {
            this.computeInnerJoinCostAsFilter = option;
            return this;
        }

        public Builder sqlTimeZone(DateTimeZone value) {
            this.sqlTimeZone = value;
            return this;
        }

        public Builder authorizeSystemTablesDirectly(boolean option) {
            this.authorizeSystemTablesDirectly = option;
            return this;
        }

        public Builder serializeComplexValues(boolean option) {
            this.serializeComplexValues = option;
            return this;
        }

        public Builder useNativeQueryExplain(boolean option) {
            this.useNativeQueryExplain = option;
            return this;
        }

        public Builder metadataRefreshPeriod(String value) {
            this.metadataRefreshPeriod = new Period((Object)value);
            return this;
        }

        public Builder withOverrides(QueryContext queryContext) {
            this.useApproximateCountDistinct = queryContext.getAsBoolean(PlannerConfig.CTX_KEY_USE_APPROXIMATE_COUNT_DISTINCT, this.useApproximateCountDistinct);
            this.useGroupingSetForExactDistinct = queryContext.getAsBoolean(PlannerConfig.CTX_KEY_USE_GROUPING_SET_FOR_EXACT_DISTINCT, this.useGroupingSetForExactDistinct);
            this.useApproximateTopN = queryContext.getAsBoolean(PlannerConfig.CTX_KEY_USE_APPROXIMATE_TOPN, this.useApproximateTopN);
            this.computeInnerJoinCostAsFilter = queryContext.getAsBoolean(PlannerConfig.CTX_COMPUTE_INNER_JOIN_COST_AS_FILTER, this.computeInnerJoinCostAsFilter);
            this.useNativeQueryExplain = queryContext.getAsBoolean(PlannerConfig.CTX_KEY_USE_NATIVE_QUERY_EXPLAIN, this.useNativeQueryExplain);
            this.forceExpressionVirtualColumns = queryContext.getAsBoolean(PlannerConfig.CTX_KEY_FORCE_EXPRESSION_VIRTUAL_COLUMNS, this.forceExpressionVirtualColumns);
            int queryContextMaxNumericInFilters = queryContext.getAsInt(PlannerConfig.CTX_MAX_NUMERIC_IN_FILTERS, this.maxNumericInFilters);
            this.maxNumericInFilters = Builder.validateMaxNumericInFilters(queryContextMaxNumericInFilters, this.maxNumericInFilters);
            return this;
        }

        private static int validateMaxNumericInFilters(int queryContextMaxNumericInFilters, int systemConfigMaxNumericInFilters) {
            if (queryContextMaxNumericInFilters == 0) {
                throw new UOE("[%s] must be greater than 0", new Object[]{PlannerConfig.CTX_MAX_NUMERIC_IN_FILTERS});
            }
            if (queryContextMaxNumericInFilters > systemConfigMaxNumericInFilters && systemConfigMaxNumericInFilters != -1) {
                throw new UOE("Expected parameter[%s] cannot exceed system set value of [%d]", new Object[]{PlannerConfig.CTX_MAX_NUMERIC_IN_FILTERS, systemConfigMaxNumericInFilters});
            }
            if (systemConfigMaxNumericInFilters == -1) {
                return systemConfigMaxNumericInFilters;
            }
            return queryContextMaxNumericInFilters;
        }

        public PlannerConfig build() {
            PlannerConfig config = new PlannerConfig();
            config.metadataRefreshPeriod = this.metadataRefreshPeriod;
            config.maxTopNLimit = this.maxTopNLimit;
            config.useApproximateCountDistinct = this.useApproximateCountDistinct;
            config.useApproximateTopN = this.useApproximateTopN;
            config.requireTimeCondition = this.requireTimeCondition;
            config.awaitInitializationOnStart = this.awaitInitializationOnStart;
            config.sqlTimeZone = this.sqlTimeZone;
            config.metadataSegmentCacheEnable = this.metadataSegmentCacheEnable;
            config.metadataSegmentPollPeriod = this.metadataSegmentPollPeriod;
            config.useGroupingSetForExactDistinct = this.useGroupingSetForExactDistinct;
            config.computeInnerJoinCostAsFilter = this.computeInnerJoinCostAsFilter;
            config.authorizeSystemTablesDirectly = this.authorizeSystemTablesDirectly;
            config.useNativeQueryExplain = this.useNativeQueryExplain;
            config.maxNumericInFilters = this.maxNumericInFilters;
            config.forceExpressionVirtualColumns = this.forceExpressionVirtualColumns;
            config.serializeComplexValues = this.serializeComplexValues;
            return config;
        }
    }
}

