/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.DataContext;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.interpreter.BindableRel;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Pair;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.query.Query;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.parser.DruidSqlInsert;
import org.apache.druid.sql.calcite.parser.DruidSqlParserUtils;
import org.apache.druid.sql.calcite.parser.DruidSqlReplace;
import org.apache.druid.sql.calcite.planner.CalcitePlanner;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.OffsetLimit;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.PlannerResult;
import org.apache.druid.sql.calcite.planner.PrepareResult;
import org.apache.druid.sql.calcite.planner.RelParameterizerShuttle;
import org.apache.druid.sql.calcite.planner.SqlParameterizerShuttle;
import org.apache.druid.sql.calcite.planner.SqlResourceCollectorShuttle;
import org.apache.druid.sql.calcite.planner.UnsupportedSQLQueryException;
import org.apache.druid.sql.calcite.rel.DruidConvention;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.DruidRel;
import org.apache.druid.sql.calcite.rel.DruidUnionRel;
import org.apache.druid.sql.calcite.run.EngineFeature;
import org.apache.druid.sql.calcite.run.QueryMaker;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.table.DruidTable;
import org.apache.druid.utils.Throwables;
import org.joda.time.DateTimeZone;

public class DruidPlanner
implements Closeable {
    private static final EmittingLogger log = new EmittingLogger(DruidPlanner.class);
    private static final Pattern UNNAMED_COLUMN_PATTERN = Pattern.compile("^EXPR\\$\\d+$", 2);
    @VisibleForTesting
    public static final String UNNAMED_INGESTION_COLUMN_ERROR = "Cannot ingest expressions that do not have an alias or columns with names like EXPR$[digit].\nE.g. if you are ingesting \"func(X)\", then you can rewrite it as \"func(X) as myColumn\"";
    private final FrameworkConfig frameworkConfig;
    private final CalcitePlanner planner;
    private final PlannerContext plannerContext;
    private final SqlEngine engine;
    private State state = State.START;
    private ParsedNodes parsed;
    private SqlNode validatedQueryNode;
    private boolean authorized;
    private PrepareResult prepareResult;
    private Set<ResourceAction> resourceActions;
    private RelRoot rootQueryRel;
    private RexBuilder rexBuilder;

    DruidPlanner(FrameworkConfig frameworkConfig, PlannerContext plannerContext, SqlEngine engine) {
        this.frameworkConfig = frameworkConfig;
        this.planner = new CalcitePlanner(frameworkConfig);
        this.plannerContext = plannerContext;
        this.engine = engine;
    }

    public void validate() throws SqlParseException, ValidationException {
        Preconditions.checkState((this.state == State.START ? 1 : 0) != 0);
        this.engine.validateContext(this.plannerContext.getQueryContext());
        SqlNode root = this.planner.parse(this.plannerContext.getSql());
        this.parsed = ParsedNodes.create(root, this.plannerContext.getTimeZone());
        if (this.parsed.isSelect() && !this.plannerContext.engineHasFeature(EngineFeature.CAN_SELECT)) {
            throw new ValidationException(StringUtils.format((String)"Cannot execute SELECT with SQL engine '%s'.", (Object[])new Object[]{this.engine.name()}));
        }
        if (this.parsed.isInsert() && !this.plannerContext.engineHasFeature(EngineFeature.CAN_INSERT)) {
            throw new ValidationException(StringUtils.format((String)"Cannot execute INSERT with SQL engine '%s'.", (Object[])new Object[]{this.engine.name()}));
        }
        if (this.parsed.isReplace() && !this.plannerContext.engineHasFeature(EngineFeature.CAN_REPLACE)) {
            throw new ValidationException(StringUtils.format((String)"Cannot execute REPLACE with SQL engine '%s'.", (Object[])new Object[]{this.engine.name()}));
        }
        try {
            if (this.parsed.getIngestionGranularity() != null) {
                this.plannerContext.getQueryContext().addSystemParam("sqlInsertSegmentGranularity", (Object)this.plannerContext.getJsonMapper().writeValueAsString((Object)this.parsed.getIngestionGranularity()));
            }
        }
        catch (JsonProcessingException e) {
            throw new ValidationException("Unable to serialize partition granularity.");
        }
        if (this.parsed.getReplaceIntervals() != null) {
            this.plannerContext.getQueryContext().addSystemParam("sqlReplaceTimeChunks", (Object)String.join((CharSequence)",", this.parsed.getReplaceIntervals()));
        }
        try {
            SqlNode queryNode = this.parsed.getQueryNode();
            if (!this.plannerContext.getParameters().isEmpty()) {
                queryNode = (SqlNode)queryNode.accept((SqlVisitor)new SqlParameterizerShuttle(this.plannerContext));
            }
            this.validatedQueryNode = this.planner.validate(queryNode);
        }
        catch (RuntimeException e) {
            throw new ValidationException((Throwable)e);
        }
        SqlValidator validator = this.planner.getValidator();
        SqlResourceCollectorShuttle resourceCollectorShuttle = new SqlResourceCollectorShuttle(validator, this.plannerContext);
        this.validatedQueryNode.accept((SqlVisitor)resourceCollectorShuttle);
        this.resourceActions = new HashSet<ResourceAction>(resourceCollectorShuttle.getResourceActions());
        if (this.parsed.isInsert() || this.parsed.isReplace()) {
            if (this.plannerContext.getQueryContext().get("sqlOuterLimit") != null) {
                throw new ValidationException(StringUtils.format((String)"%s cannot be provided with %s.", (Object[])new Object[]{"sqlOuterLimit", this.parsed.getInsertOrReplace().getOperator().getName()}));
            }
            String targetDataSource = this.validateAndGetDataSourceForIngest(this.parsed.getInsertOrReplace());
            this.resourceActions.add(new ResourceAction(new Resource(targetDataSource, "DATASOURCE"), Action.WRITE));
        }
        this.state = State.VALIDATED;
        this.plannerContext.setResourceActions(this.resourceActions);
    }

    public PrepareResult prepare() {
        Preconditions.checkState((this.state == State.VALIDATED ? 1 : 0) != 0);
        this.rootQueryRel = this.planner.rel(this.validatedQueryNode);
        this.doPrepare();
        this.state = State.PREPARED;
        return this.prepareResult;
    }

    private void doPrepare() {
        RelDataType returnedRowType;
        RelDataTypeFactory typeFactory = this.rootQueryRel.rel.getCluster().getTypeFactory();
        SqlValidator validator = this.planner.getValidator();
        RelDataType parameterTypes = validator.getParameterRowType(this.validatedQueryNode);
        if (this.parsed.getExplainNode() != null) {
            returnedRowType = DruidPlanner.getExplainStructType(typeFactory);
        } else if (this.parsed.isSelect()) {
            returnedRowType = this.engine.resultTypeForSelect(typeFactory, this.rootQueryRel.validatedRowType);
        } else {
            assert (this.parsed.insertOrReplace != null);
            returnedRowType = this.engine.resultTypeForInsert(typeFactory, this.rootQueryRel.validatedRowType);
        }
        this.prepareResult = new PrepareResult(this.rootQueryRel.validatedRowType, returnedRowType, parameterTypes);
    }

    public Access authorize(Function<Set<ResourceAction>, Access> authorizer, boolean authorizeContextParams) {
        Preconditions.checkState((this.state == State.VALIDATED ? 1 : 0) != 0);
        Access access = authorizer.apply(this.resourceActions(authorizeContextParams));
        this.plannerContext.setAuthorizationResult(access);
        this.authorized = true;
        return access;
    }

    public Set<ResourceAction> resourceActions(boolean includeContext) {
        if (includeContext) {
            HashSet<ResourceAction> actions = new HashSet<ResourceAction>(this.resourceActions);
            this.plannerContext.getQueryContext().getUserParams().keySet().forEach(contextParam -> actions.add(new ResourceAction(new Resource(contextParam, "QUERY_CONTEXT"), Action.WRITE)));
            return actions;
        }
        return this.resourceActions;
    }

    public PlannerResult plan() throws ValidationException {
        Preconditions.checkState((this.state == State.VALIDATED || this.state == State.PREPARED ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.authorized);
        if (this.state == State.VALIDATED) {
            this.rootQueryRel = this.planner.rel(this.validatedQueryNode);
        }
        Set<RelOptTable> bindableTables = DruidPlanner.getBindableTables(this.rootQueryRel.rel);
        this.rexBuilder = new RexBuilder((RelDataTypeFactory)this.planner.getTypeFactory());
        this.state = State.PLANNED;
        try {
            if (!bindableTables.isEmpty()) {
                if (this.parsed.isInsert() || this.parsed.isReplace()) {
                    this.validateAndGetDataSourceForIngest(this.parsed.getInsertOrReplace());
                }
                if (!this.plannerContext.engineHasFeature(EngineFeature.ALLOW_BINDABLE_PLAN)) {
                    throw new ValidationException(StringUtils.format((String)"Cannot query table%s [%s] with SQL engine '%s'.", (Object[])new Object[]{bindableTables.size() != 1 ? "s" : "", bindableTables.stream().map(table -> Joiner.on((String)".").join((Iterable)table.getQualifiedName())).collect(Collectors.joining(", ")), this.engine.name()}));
                }
                return this.planWithBindableConvention(this.rootQueryRel, this.parsed.getExplainNode());
            }
            return this.planWithDruidConvention(this.rootQueryRel, this.parsed.getExplainNode(), this.parsed.getInsertOrReplace());
        }
        catch (Exception e) {
            Throwable cannotPlanException = Throwables.getCauseOfType((Throwable)e, RelOptPlanner.CannotPlanException.class);
            if (null == cannotPlanException) {
                throw e;
            }
            EmittingLogger logger = log;
            if (!this.plannerContext.getQueryContext().isDebug()) {
                logger = log.noStackTrace();
            }
            String errorMessage = this.buildSQLPlanningErrorMessage(cannotPlanException);
            logger.warn((Throwable)e, errorMessage, new Object[0]);
            throw new UnsupportedSQLQueryException(errorMessage, new Object[0]);
        }
    }

    public PlannerContext getPlannerContext() {
        return this.plannerContext;
    }

    public PrepareResult prepareResult() {
        return this.prepareResult;
    }

    @Override
    public void close() {
        this.planner.close();
    }

    private PlannerResult planWithDruidConvention(RelRoot root, @Nullable SqlExplain explain, @Nullable SqlInsert insertOrReplace) throws ValidationException {
        RelDataType rowType;
        RelRoot possiblyLimitedRoot = this.possiblyWrapRootWithOuterLimitFromContext(root);
        QueryMaker queryMaker = this.buildQueryMaker(possiblyLimitedRoot, insertOrReplace);
        this.plannerContext.setQueryMaker(queryMaker);
        if (this.prepareResult == null) {
            this.doPrepare();
        }
        RelNode parameterized = possiblyLimitedRoot.rel.accept((RelShuttle)new RelParameterizerShuttle(this.plannerContext));
        DruidRel druidRel = (DruidRel)this.planner.transform(0, this.planner.getEmptyTraitSet().replace((RelTrait)DruidConvention.instance()).plus((RelTrait)root.collation), parameterized);
        if (explain != null) {
            return this.planExplanation((RelNode)druidRel, explain, true);
        }
        RelDataTypeFactory typeFactory = this.rootQueryRel.rel.getCluster().getTypeFactory();
        if (this.parsed.isSelect()) {
            rowType = this.engine.resultTypeForSelect(typeFactory, this.rootQueryRel.validatedRowType);
        } else {
            assert (this.parsed.insertOrReplace != null);
            rowType = this.engine.resultTypeForInsert(typeFactory, this.rootQueryRel.validatedRowType);
        }
        Supplier resultsSupplier = () -> {
            Set readResourceActions = this.plannerContext.getResourceActions().stream().filter(action -> action.getAction() == Action.READ).collect(Collectors.toSet());
            Preconditions.checkState((readResourceActions.isEmpty() == druidRel.getDataSourceNames().isEmpty() || readResourceActions.size() >= druidRel.getDataSourceNames().size() ? 1 : 0) != 0, (Object)"Authorization sanity check failed");
            return druidRel.runQuery();
        };
        return new PlannerResult((Supplier<Sequence<Object[]>>)resultsSupplier, rowType);
    }

    private PlannerResult planWithBindableConvention(RelRoot root, @Nullable SqlExplain explain) {
        if (this.prepareResult == null) {
            this.doPrepare();
        }
        BindableRel bindableRel = (BindableRel)this.planner.transform(1, this.planner.getEmptyTraitSet().replace((RelTrait)BindableConvention.INSTANCE).plus((RelTrait)root.collation), root.rel);
        if (!root.isRefTrivial()) {
            ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>();
            RexBuilder rexBuilder = bindableRel.getCluster().getRexBuilder();
            Iterator iterator = Pair.left((List)root.fields).iterator();
            while (iterator.hasNext()) {
                int field = (Integer)iterator.next();
                projects.add(rexBuilder.makeInputRef((RelNode)bindableRel, field));
            }
            bindableRel = new Bindables.BindableProject(bindableRel.getCluster(), bindableRel.getTraitSet(), (RelNode)bindableRel, projects, root.validatedRowType);
        }
        if (explain != null) {
            return this.planExplanation((RelNode)bindableRel, explain, false);
        }
        BindableRel theRel = bindableRel;
        DataContext dataContext = this.plannerContext.createDataContext(this.planner.getTypeFactory(), this.plannerContext.getParameters());
        Supplier resultsSupplier = () -> {
            Enumerable enumerable = theRel.bind(dataContext);
            final Enumerator enumerator = enumerable.enumerator();
            return Sequences.withBaggage((Sequence)new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Object[], EnumeratorIterator<Object[]>>(){

                public EnumeratorIterator<Object[]> make() {
                    return new EnumeratorIterator<Object[]>(new Iterator<Object[]>(){

                        @Override
                        public boolean hasNext() {
                            return enumerator.moveNext();
                        }

                        @Override
                        public Object[] next() {
                            return (Object[])enumerator.current();
                        }
                    });
                }

                public void cleanup(EnumeratorIterator<Object[]> iterFromMake) {
                }
            }), () -> ((Enumerator)enumerator).close());
        };
        return new PlannerResult((Supplier<Sequence<Object[]>>)resultsSupplier, root.validatedRowType);
    }

    private PlannerResult planExplanation(RelNode rel, SqlExplain explain, boolean isDruidConventionExplanation) {
        String resourcesString;
        String explanation = RelOptUtil.dumpPlan((String)"", (RelNode)rel, (SqlExplainFormat)explain.getFormat(), (SqlExplainLevel)explain.getDetailLevel());
        try {
            if (isDruidConventionExplanation && rel instanceof DruidRel && this.plannerContext.getPlannerConfig().isUseNativeQueryExplain()) {
                DruidRel druidRel = (DruidRel)rel;
                try {
                    explanation = this.explainSqlPlanAsNativeQueries(druidRel);
                }
                catch (Exception ex) {
                    log.warn((Throwable)ex, "Unable to translate to a native Druid query. Resorting to legacy Druid explain plan", new Object[0]);
                }
            }
            Set resources = this.plannerContext.getResourceActions().stream().map(ResourceAction::getResource).collect(Collectors.toSet());
            resourcesString = this.plannerContext.getJsonMapper().writeValueAsString(resources);
        }
        catch (JsonProcessingException jpe) {
            log.error((Throwable)jpe, "Encountered exception while serializing Resources for explain output", new Object[0]);
            resourcesString = null;
        }
        Supplier resultsSupplier = Suppliers.ofInstance((Object)Sequences.simple((Iterable)ImmutableList.of((Object)new Object[]{explanation, resourcesString})));
        return new PlannerResult((Supplier<Sequence<Object[]>>)resultsSupplier, DruidPlanner.getExplainStructType(rel.getCluster().getTypeFactory()));
    }

    private String explainSqlPlanAsNativeQueries(DruidRel<?> rel) throws JsonProcessingException {
        ObjectMapper jsonMapper = this.plannerContext.getJsonMapper();
        List druidQueryList = this.flattenOutermostRel(rel).stream().map(druidRel -> druidRel.toDruidQuery(false)).collect(Collectors.toList());
        ArrayNode nativeQueriesArrayNode = jsonMapper.createArrayNode();
        for (DruidQuery druidQuery : druidQueryList) {
            Query nativeQuery = druidQuery.getQuery();
            ObjectNode objectNode = jsonMapper.createObjectNode();
            objectNode.put("query", (JsonNode)jsonMapper.convertValue((Object)nativeQuery, ObjectNode.class));
            objectNode.put("signature", (JsonNode)jsonMapper.convertValue((Object)druidQuery.getOutputRowSignature(), ArrayNode.class));
            nativeQueriesArrayNode.add((JsonNode)objectNode);
        }
        return jsonMapper.writeValueAsString((Object)nativeQueriesArrayNode);
    }

    private List<DruidRel<?>> flattenOutermostRel(DruidRel<?> outermostDruidRel) {
        ArrayList druidRels = new ArrayList();
        this.flattenOutermostRel(outermostDruidRel, druidRels);
        return druidRels;
    }

    private void flattenOutermostRel(DruidRel<?> druidRel, List<DruidRel<?>> flattendListAccumulator) {
        if (druidRel instanceof DruidUnionRel) {
            DruidUnionRel druidUnionRel = (DruidUnionRel)druidRel;
            druidUnionRel.getInputs().forEach(innerRelNode -> {
                DruidRel innerDruidRelNode = (DruidRel)((Object)innerRelNode);
                this.flattenOutermostRel(innerDruidRelNode, flattendListAccumulator);
            });
        } else {
            flattendListAccumulator.add(druidRel);
        }
    }

    @Nullable
    private RelRoot possiblyWrapRootWithOuterLimitFromContext(RelRoot root) {
        LogicalSort newRootRel;
        Object outerLimitObj = this.plannerContext.getQueryContext().get("sqlOuterLimit");
        Long outerLimit = DimensionHandlerUtils.convertObjectToLong((Object)outerLimitObj, (boolean)true);
        if (outerLimit == null) {
            return root;
        }
        if (root.rel instanceof Sort) {
            Sort sort = (Sort)root.rel;
            OffsetLimit originalOffsetLimit = OffsetLimit.fromSort(sort);
            OffsetLimit newOffsetLimit = originalOffsetLimit.andThen(new OffsetLimit(0L, outerLimit));
            if (newOffsetLimit.equals(originalOffsetLimit)) {
                return root;
            }
            newRootRel = LogicalSort.create((RelNode)sort.getInput(), (RelCollation)sort.collation, (RexNode)newOffsetLimit.getOffsetAsRexNode(this.rexBuilder), (RexNode)newOffsetLimit.getLimitAsRexNode(this.rexBuilder));
        } else {
            newRootRel = LogicalSort.create((RelNode)root.rel, (RelCollation)root.collation, null, (RexNode)new OffsetLimit(0L, outerLimit).getLimitAsRexNode(this.rexBuilder));
        }
        return new RelRoot((RelNode)newRootRel, root.validatedRowType, root.kind, (List)root.fields, root.collation);
    }

    private QueryMaker buildQueryMaker(RelRoot rootQueryRel, @Nullable SqlInsert insertOrReplace) throws ValidationException {
        if (insertOrReplace != null) {
            String targetDataSource = this.validateAndGetDataSourceForIngest(insertOrReplace);
            this.validateColumnsForIngestion(rootQueryRel);
            return this.engine.buildQueryMakerForInsert(targetDataSource, rootQueryRel, this.plannerContext);
        }
        return this.engine.buildQueryMakerForSelect(rootQueryRel, this.plannerContext);
    }

    private static RelDataType getExplainStructType(RelDataTypeFactory typeFactory) {
        return typeFactory.createStructType((List)ImmutableList.of((Object)Calcites.createSqlType(typeFactory, SqlTypeName.VARCHAR), (Object)Calcites.createSqlType(typeFactory, SqlTypeName.VARCHAR)), (List)ImmutableList.of((Object)"PLAN", (Object)"RESOURCES"));
    }

    private String validateAndGetDataSourceForIngest(SqlInsert insert) throws ValidationException {
        String dataSource;
        String operatorName = insert.getOperator().getName();
        if (insert.isUpsert()) {
            throw new ValidationException("UPSERT is not supported.");
        }
        if (insert.getTargetColumnList() != null) {
            throw new ValidationException(operatorName + " with target column list is not supported.");
        }
        SqlIdentifier tableIdentifier = (SqlIdentifier)insert.getTargetTable();
        if (tableIdentifier.names.isEmpty()) {
            throw new ValidationException(operatorName + " requires target table.");
        }
        if (tableIdentifier.names.size() == 1) {
            dataSource = (String)Iterables.getOnlyElement((Iterable)tableIdentifier.names);
        } else {
            String defaultSchemaName = (String)Iterables.getOnlyElement((Iterable)CalciteSchema.from((SchemaPlus)this.frameworkConfig.getDefaultSchema()).path(null));
            if (tableIdentifier.names.size() == 2 && defaultSchemaName.equals(tableIdentifier.names.get(0))) {
                dataSource = (String)tableIdentifier.names.get(1);
            } else {
                throw new ValidationException(StringUtils.format((String)"Cannot %s into [%s] because it is not a Druid datasource (schema = %s).", (Object[])new Object[]{operatorName, tableIdentifier, defaultSchemaName}));
            }
        }
        try {
            IdUtils.validateId((String)(operatorName + " dataSource"), (String)dataSource);
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException(e.getMessage());
        }
        return dataSource;
    }

    private void validateColumnsForIngestion(RelRoot rootQueryRel) throws ValidationException {
        for (Pair field : rootQueryRel.fields) {
            if (!UNNAMED_COLUMN_PATTERN.matcher((CharSequence)field.right).matches()) continue;
            throw new ValidationException(UNNAMED_INGESTION_COLUMN_ERROR);
        }
    }

    private String buildSQLPlanningErrorMessage(Throwable exception) {
        String errorMessage = this.plannerContext.getPlanningError();
        if (null == errorMessage && exception instanceof UnsupportedSQLQueryException) {
            errorMessage = exception.getMessage();
        }
        errorMessage = null == errorMessage ? "Please check Broker logs for additional details." : "Possible error: " + errorMessage;
        return StringUtils.format((String)"Query not supported. %s SQL was: %s", (Object[])new Object[]{errorMessage, this.plannerContext.getSql()});
    }

    private static Set<RelOptTable> getBindableTables(RelNode relNode) {
        class HasBindableVisitor
        extends RelVisitor {
            private final Set<RelOptTable> found = new HashSet<RelOptTable>();

            HasBindableVisitor() {
            }

            public void visit(RelNode node, int ordinal, RelNode parent) {
                RelOptTable table;
                if (node instanceof TableScan && (table = node.getTable()).unwrap(ScannableTable.class) != null && table.unwrap(DruidTable.class) == null) {
                    this.found.add(table);
                    return;
                }
                super.visit(node, ordinal, parent);
            }
        }
        HasBindableVisitor visitor = new HasBindableVisitor();
        visitor.go(relNode);
        return visitor.found;
    }

    private static class ParsedNodes {
        @Nullable
        private final SqlExplain explain;
        @Nullable
        private final SqlInsert insertOrReplace;
        private final SqlNode query;
        @Nullable
        private final Granularity ingestionGranularity;
        @Nullable
        private final List<String> replaceIntervals;

        private ParsedNodes(@Nullable SqlExplain explain, @Nullable SqlInsert insertOrReplace, SqlNode query, @Nullable Granularity ingestionGranularity, @Nullable List<String> replaceIntervals) {
            this.explain = explain;
            this.insertOrReplace = insertOrReplace;
            this.query = query;
            this.ingestionGranularity = ingestionGranularity;
            this.replaceIntervals = replaceIntervals;
        }

        static ParsedNodes create(SqlNode node, DateTimeZone dateTimeZone) throws ValidationException {
            SqlNode query = node;
            SqlExplain explain = null;
            if (query.getKind() == SqlKind.EXPLAIN) {
                explain = (SqlExplain)query;
                query = explain.getExplicandum();
            }
            if (query.getKind() == SqlKind.INSERT) {
                if (query instanceof DruidSqlInsert) {
                    return ParsedNodes.handleInsert(explain, (DruidSqlInsert)query);
                }
                if (query instanceof DruidSqlReplace) {
                    return ParsedNodes.handleReplace(explain, (DruidSqlReplace)query, dateTimeZone);
                }
            }
            if (!query.isA((Set)SqlKind.QUERY)) {
                throw new ValidationException(StringUtils.format((String)"Cannot execute [%s].", (Object[])new Object[]{query.getKind()}));
            }
            return new ParsedNodes(explain, null, query, null, null);
        }

        static ParsedNodes handleInsert(SqlExplain explain, DruidSqlInsert druidSqlInsert) throws ValidationException {
            SqlNode query = druidSqlInsert.getSource();
            if (query instanceof SqlOrderBy) {
                SqlOrderBy sqlOrderBy = (SqlOrderBy)query;
                SqlNodeList orderByList = sqlOrderBy.orderList;
                if (orderByList != null && !orderByList.equals(SqlNodeList.EMPTY)) {
                    throw new ValidationException("Cannot have ORDER BY on an INSERT query, use CLUSTERED BY instead.");
                }
            }
            Granularity ingestionGranularity = druidSqlInsert.getPartitionedBy();
            if (druidSqlInsert.getClusteredBy() != null) {
                query = DruidSqlParserUtils.convertClusterByToOrderBy(query, druidSqlInsert.getClusteredBy());
            }
            if (!query.isA((Set)SqlKind.QUERY)) {
                throw new ValidationException(StringUtils.format((String)"Cannot execute [%s].", (Object[])new Object[]{query.getKind()}));
            }
            return new ParsedNodes(explain, druidSqlInsert, query, ingestionGranularity, null);
        }

        static ParsedNodes handleReplace(SqlExplain explain, DruidSqlReplace druidSqlReplace, DateTimeZone dateTimeZone) throws ValidationException {
            SqlNode replaceTimeQuery;
            SqlNode query = druidSqlReplace.getSource();
            if (query instanceof SqlOrderBy) {
                SqlOrderBy sqlOrderBy = (SqlOrderBy)query;
                SqlNodeList orderByList = sqlOrderBy.orderList;
                if (orderByList != null && !orderByList.equals(SqlNodeList.EMPTY)) {
                    throw new ValidationException("Cannot have ORDER BY on a REPLACE query, use CLUSTERED BY instead.");
                }
            }
            if ((replaceTimeQuery = druidSqlReplace.getReplaceTimeQuery()) == null) {
                throw new ValidationException("Missing time chunk information in OVERWRITE clause for REPLACE, set it to OVERWRITE WHERE <__time based condition> or set it to overwrite the entire table with OVERWRITE ALL.");
            }
            Granularity ingestionGranularity = druidSqlReplace.getPartitionedBy();
            List<String> replaceIntervals = DruidSqlParserUtils.validateQueryAndConvertToIntervals(replaceTimeQuery, ingestionGranularity, dateTimeZone);
            if (druidSqlReplace.getClusteredBy() != null) {
                query = DruidSqlParserUtils.convertClusterByToOrderBy(query, druidSqlReplace.getClusteredBy());
            }
            if (!query.isA((Set)SqlKind.QUERY)) {
                throw new ValidationException(StringUtils.format((String)"Cannot execute [%s].", (Object[])new Object[]{query.getKind()}));
            }
            return new ParsedNodes(explain, druidSqlReplace, query, ingestionGranularity, replaceIntervals);
        }

        @Nullable
        public SqlExplain getExplainNode() {
            return this.explain;
        }

        public boolean isSelect() {
            return this.insertOrReplace == null;
        }

        public boolean isInsert() {
            return this.insertOrReplace != null && !this.isReplace();
        }

        public boolean isReplace() {
            return this.insertOrReplace instanceof DruidSqlReplace;
        }

        @Nullable
        public SqlInsert getInsertOrReplace() {
            return this.insertOrReplace;
        }

        @Nullable
        public List<String> getReplaceIntervals() {
            return this.replaceIntervals;
        }

        public SqlNode getQueryNode() {
            return this.query;
        }

        @Nullable
        public Granularity getIngestionGranularity() {
            return this.ingestionGranularity;
        }
    }

    private static class EnumeratorIterator<T>
    implements Iterator<T> {
        private final Iterator<T> it;

        EnumeratorIterator(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            return this.it.next();
        }
    }

    public static enum State {
        START,
        VALIDATED,
        PREPARED,
        PLANNED;

    }
}

