/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.plan.RelOptLattice;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.plan.volcano.AbstractConverter;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.rules.AggregateCaseToFilterRule;
import org.apache.calcite.rel.rules.AggregateExpandDistinctAggregatesRule;
import org.apache.calcite.rel.rules.AggregateJoinTransposeRule;
import org.apache.calcite.rel.rules.AggregateProjectMergeRule;
import org.apache.calcite.rel.rules.AggregateProjectPullUpConstantsRule;
import org.apache.calcite.rel.rules.AggregateReduceFunctionsRule;
import org.apache.calcite.rel.rules.AggregateRemoveRule;
import org.apache.calcite.rel.rules.AggregateStarTableRule;
import org.apache.calcite.rel.rules.AggregateValuesRule;
import org.apache.calcite.rel.rules.CalcRemoveRule;
import org.apache.calcite.rel.rules.ExchangeRemoveConstantKeysRule;
import org.apache.calcite.rel.rules.FilterAggregateTransposeRule;
import org.apache.calcite.rel.rules.FilterMergeRule;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.rules.FilterTableScanRule;
import org.apache.calcite.rel.rules.IntersectToDistinctRule;
import org.apache.calcite.rel.rules.JoinPushExpressionsRule;
import org.apache.calcite.rel.rules.MatchRule;
import org.apache.calcite.rel.rules.ProjectFilterTransposeRule;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rel.rules.ProjectTableScanRule;
import org.apache.calcite.rel.rules.ProjectToWindowRule;
import org.apache.calcite.rel.rules.ProjectWindowTransposeRule;
import org.apache.calcite.rel.rules.PruneEmptyRules;
import org.apache.calcite.rel.rules.ReduceExpressionsRule;
import org.apache.calcite.rel.rules.SortJoinTransposeRule;
import org.apache.calcite.rel.rules.SortProjectTransposeRule;
import org.apache.calcite.rel.rules.SortRemoveConstantKeysRule;
import org.apache.calcite.rel.rules.SortRemoveRule;
import org.apache.calcite.rel.rules.SortUnionTransposeRule;
import org.apache.calcite.rel.rules.TableScanRule;
import org.apache.calcite.rel.rules.UnionPullUpConstantsRule;
import org.apache.calcite.rel.rules.UnionToDistinctRule;
import org.apache.calcite.rel.rules.ValuesReduceRule;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.sql2rel.RelFieldTrimmer;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.tools.RelBuilder;
import org.apache.druid.sql.calcite.external.ExternalTableScanRule;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rule.DruidLogicalValuesRule;
import org.apache.druid.sql.calcite.rule.DruidRelToDruidRule;
import org.apache.druid.sql.calcite.rule.DruidRules;
import org.apache.druid.sql.calcite.rule.DruidTableScanRule;
import org.apache.druid.sql.calcite.rule.ExtensionCalciteRuleProvider;
import org.apache.druid.sql.calcite.rule.FilterJoinExcludePushToChildRule;
import org.apache.druid.sql.calcite.rule.ProjectAggregatePruneUnusedCallRule;
import org.apache.druid.sql.calcite.rule.SortCollapseRule;

public class CalciteRulesManager {
    public static final int DRUID_CONVENTION_RULES = 0;
    public static final int BINDABLE_CONVENTION_RULES = 1;
    private static final String HEP_DEFAULT_MATCH_LIMIT_CONFIG_STRING = "druid.sql.planner.hepMatchLimit";
    private final int HEP_DEFAULT_MATCH_LIMIT = Integer.valueOf(System.getProperty("druid.sql.planner.hepMatchLimit", "1200"));
    private final List<RelOptRule> BASE_RULES = ImmutableList.of((Object)AggregateStarTableRule.INSTANCE, (Object)AggregateStarTableRule.INSTANCE2, (Object)TableScanRule.INSTANCE, (Object)ProjectMergeRule.INSTANCE, (Object)FilterTableScanRule.INSTANCE, (Object)ProjectFilterTransposeRule.INSTANCE, (Object)FilterProjectTransposeRule.INSTANCE, (Object)JoinPushExpressionsRule.INSTANCE, (Object)AggregateCaseToFilterRule.INSTANCE, (Object)FilterAggregateTransposeRule.INSTANCE, (Object)ProjectWindowTransposeRule.INSTANCE, (Object)MatchRule.INSTANCE, (Object[])new RelOptRule[]{SortProjectTransposeRule.INSTANCE, SortJoinTransposeRule.INSTANCE, SortRemoveConstantKeysRule.INSTANCE, SortUnionTransposeRule.INSTANCE, ExchangeRemoveConstantKeysRule.EXCHANGE_INSTANCE, ExchangeRemoveConstantKeysRule.SORT_EXCHANGE_INSTANCE});
    private final List<RelOptRule> DEFAULT_BINDABLE_RULES = ImmutableList.of((Object)Bindables.BINDABLE_TABLE_SCAN_RULE, (Object)ProjectTableScanRule.INSTANCE, (Object)ProjectTableScanRule.INTERPRETER);
    private final List<RelOptRule> REDUCTION_RULES = ImmutableList.of((Object)ReduceExpressionsRule.PROJECT_INSTANCE, (Object)ReduceExpressionsRule.FILTER_INSTANCE, (Object)ReduceExpressionsRule.CALC_INSTANCE, (Object)ReduceExpressionsRule.WINDOW_INSTANCE, (Object)ValuesReduceRule.FILTER_INSTANCE, (Object)ValuesReduceRule.PROJECT_FILTER_INSTANCE, (Object)ValuesReduceRule.PROJECT_INSTANCE, (Object)AggregateValuesRule.INSTANCE);
    private final List<RelOptRule> ABSTRACT_RULES = ImmutableList.of((Object)AggregateProjectPullUpConstantsRule.INSTANCE2, (Object)UnionPullUpConstantsRule.INSTANCE, (Object)PruneEmptyRules.UNION_INSTANCE, (Object)PruneEmptyRules.INTERSECT_INSTANCE, (Object)PruneEmptyRules.MINUS_INSTANCE, (Object)PruneEmptyRules.PROJECT_INSTANCE, (Object)PruneEmptyRules.FILTER_INSTANCE, (Object)PruneEmptyRules.SORT_INSTANCE, (Object)PruneEmptyRules.AGGREGATE_INSTANCE, (Object)PruneEmptyRules.JOIN_LEFT_INSTANCE, (Object)PruneEmptyRules.JOIN_RIGHT_INSTANCE, (Object)PruneEmptyRules.SORT_FETCH_ZERO_INSTANCE, (Object[])new RelOptRule[]{ProjectToWindowRule.PROJECT, FilterMergeRule.INSTANCE, IntersectToDistinctRule.INSTANCE});
    private final List<RelOptRule> ABSTRACT_RELATIONAL_RULES = ImmutableList.of((Object)AbstractConverter.ExpandConversionRule.INSTANCE, (Object)AggregateRemoveRule.INSTANCE, (Object)UnionToDistinctRule.INSTANCE, (Object)ProjectRemoveRule.INSTANCE, (Object)AggregateJoinTransposeRule.INSTANCE, (Object)AggregateProjectMergeRule.INSTANCE, (Object)CalcRemoveRule.INSTANCE, (Object)SortRemoveRule.INSTANCE);
    private final Set<ExtensionCalciteRuleProvider> extensionCalciteRuleProviderSet;

    @Inject
    public CalciteRulesManager(Set<ExtensionCalciteRuleProvider> extensionCalciteRuleProviderSet) {
        this.extensionCalciteRuleProviderSet = extensionCalciteRuleProviderSet;
    }

    public List<Program> programs(PlannerContext plannerContext) {
        Program preProgram = Programs.sequence((Program[])new Program[]{Programs.subQuery((RelMetadataProvider)DefaultRelMetadataProvider.INSTANCE), DecorrelateAndTrimFieldsProgram.INSTANCE, this.buildHepProgram(this.REDUCTION_RULES, true, (RelMetadataProvider)DefaultRelMetadataProvider.INSTANCE, this.HEP_DEFAULT_MATCH_LIMIT)});
        return ImmutableList.of((Object)Programs.sequence((Program[])new Program[]{preProgram, Programs.ofRules(this.druidConventionRuleSet(plannerContext))}), (Object)Programs.sequence((Program[])new Program[]{preProgram, Programs.ofRules(this.bindableConventionRuleSet(plannerContext))}));
    }

    public Program buildHepProgram(Iterable<? extends RelOptRule> rules, boolean noDag, RelMetadataProvider metadataProvider, int matchLimit) {
        HepProgramBuilder builder = HepProgram.builder();
        builder.addMatchLimit(matchLimit);
        for (RelOptRule relOptRule : rules) {
            builder.addRuleInstance(relOptRule);
        }
        return Programs.of((HepProgram)builder.build(), (boolean)noDag, (RelMetadataProvider)metadataProvider);
    }

    public List<RelOptRule> druidConventionRuleSet(PlannerContext plannerContext) {
        ImmutableList.Builder retVal = ImmutableList.builder().addAll(this.baseRuleSet(plannerContext)).add((Object)DruidRelToDruidRule.instance()).add((Object)new DruidTableScanRule(plannerContext)).add((Object)new DruidLogicalValuesRule(plannerContext)).add((Object)new ExternalTableScanRule(plannerContext)).addAll(DruidRules.rules(plannerContext));
        for (ExtensionCalciteRuleProvider extensionCalciteRuleProvider : this.extensionCalciteRuleProviderSet) {
            retVal.add((Object)extensionCalciteRuleProvider.getRule(plannerContext));
        }
        return retVal.build();
    }

    public List<RelOptRule> bindableConventionRuleSet(PlannerContext plannerContext) {
        return ImmutableList.builder().addAll(this.baseRuleSet(plannerContext)).addAll((Iterable)Bindables.RULES).addAll(this.DEFAULT_BINDABLE_RULES).add((Object)AggregateReduceFunctionsRule.INSTANCE).build();
    }

    public List<RelOptRule> baseRuleSet(PlannerContext plannerContext) {
        PlannerConfig plannerConfig = plannerContext.getPlannerConfig();
        ImmutableList.Builder rules = ImmutableList.builder();
        rules.addAll(this.BASE_RULES);
        rules.addAll(this.ABSTRACT_RULES);
        rules.addAll(this.ABSTRACT_RELATIONAL_RULES);
        if (!plannerConfig.isUseApproximateCountDistinct()) {
            if (plannerConfig.isUseGroupingSetForExactDistinct()) {
                rules.add((Object)AggregateExpandDistinctAggregatesRule.INSTANCE);
            } else {
                rules.add((Object)AggregateExpandDistinctAggregatesRule.JOIN);
            }
        }
        rules.add((Object)FilterJoinExcludePushToChildRule.FILTER_ON_JOIN_EXCLUDE_PUSH_TO_CHILD);
        rules.add((Object)SortCollapseRule.instance());
        rules.add((Object)ProjectAggregatePruneUnusedCallRule.instance());
        return rules.build();
    }

    private static class DecorrelateAndTrimFieldsProgram
    implements Program {
        private static final DecorrelateAndTrimFieldsProgram INSTANCE = new DecorrelateAndTrimFieldsProgram();

        private DecorrelateAndTrimFieldsProgram() {
        }

        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits, List<RelOptMaterialization> materializations, List<RelOptLattice> lattices) {
            RelBuilder relBuilder = RelFactories.LOGICAL_BUILDER.create(rel.getCluster(), null);
            RelNode decorrelatedRel = RelDecorrelator.decorrelateQuery((RelNode)rel, (RelBuilder)relBuilder);
            return new RelFieldTrimmer(null, relBuilder).trim(decorrelatedRel);
        }
    }
}

