/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.parser;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlTimestampLiteral;
import org.apache.calcite.tools.ValidationException;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.GranularityType;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.sql.calcite.expression.TimeUnits;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.filtration.MoveTimeFiltersToIntervals;
import org.apache.druid.sql.calcite.parser.ParseException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.base.AbstractInterval;

public class DruidSqlParserUtils {
    private static final Logger log = new Logger(DruidSqlParserUtils.class);
    public static final String ALL = "all";

    public static Granularity convertSqlNodeToGranularityThrowingParseExceptions(SqlNode sqlNode) throws ParseException {
        try {
            return DruidSqlParserUtils.convertSqlNodeToGranularity(sqlNode);
        }
        catch (Exception e) {
            log.debug((Throwable)e, StringUtils.format((String)"Unable to convert %s to a valid granularity.", (Object[])new Object[]{sqlNode.toString()}), new Object[0]);
            throw new ParseException(e.getMessage());
        }
    }

    public static Granularity convertSqlNodeToGranularity(SqlNode sqlNode) throws ParseException {
        String genericParseFailedMessageFormatString = "Encountered %s after PARTITIONED BY. Expected HOUR, DAY, MONTH, YEAR, ALL TIME, FLOOR function or %s function";
        if (!(sqlNode instanceof SqlCall)) {
            throw new ParseException(StringUtils.format((String)"Encountered %s after PARTITIONED BY. Expected HOUR, DAY, MONTH, YEAR, ALL TIME, FLOOR function or %s function", (Object[])new Object[]{sqlNode.toString(), "TIME_FLOOR"}));
        }
        SqlCall sqlCall = (SqlCall)sqlNode;
        String operatorName = sqlCall.getOperator().getName();
        Preconditions.checkArgument(("FLOOR".equalsIgnoreCase(operatorName) || "TIME_FLOOR".equalsIgnoreCase(operatorName) ? 1 : 0) != 0, (Object)StringUtils.format((String)"PARTITIONED BY clause only supports FLOOR(__time TO <unit> and %s(__time, period) functions", (Object[])new Object[]{"TIME_FLOOR"}));
        List operandList = sqlCall.getOperandList();
        Preconditions.checkArgument((operandList.size() == 2 ? 1 : 0) != 0, (Object)StringUtils.format((String)"%s in PARTITIONED BY clause must have two arguments", (Object[])new Object[]{operatorName}));
        SqlNode timeOperandSqlNode = (SqlNode)operandList.get(0);
        Preconditions.checkArgument((boolean)timeOperandSqlNode.getKind().equals((Object)SqlKind.IDENTIFIER), (Object)StringUtils.format((String)"First argument to %s in PARTITIONED BY clause can only be __time", (Object[])new Object[]{operatorName}));
        SqlIdentifier timeOperandSqlIdentifier = (SqlIdentifier)timeOperandSqlNode;
        Preconditions.checkArgument((boolean)timeOperandSqlIdentifier.getSimple().equals("__time"), (Object)StringUtils.format((String)"First argument to %s in PARTITIONED BY clause can only be __time", (Object[])new Object[]{operatorName}));
        if (operatorName.equalsIgnoreCase("TIME_FLOOR")) {
            Period period;
            SqlNode granularitySqlNode = (SqlNode)operandList.get(1);
            Preconditions.checkArgument((boolean)granularitySqlNode.getKind().equals((Object)SqlKind.LITERAL), (Object)"Second argument to TIME_FLOOR in PARTITIONED BY clause must be a period like 'PT1H'");
            String granularityString = SqlLiteral.unchain((SqlNode)granularitySqlNode).toValue();
            try {
                period = new Period((Object)granularityString);
            }
            catch (IllegalArgumentException e) {
                throw new ParseException(StringUtils.format((String)"%s is an invalid period string", (Object[])new Object[]{granularitySqlNode.toString()}));
            }
            return new PeriodGranularity(period, null, null);
        }
        if ("FLOOR".equalsIgnoreCase(operatorName)) {
            SqlNode granularitySqlNode = (SqlNode)operandList.get(1);
            Preconditions.checkArgument((boolean)(granularitySqlNode instanceof SqlIntervalQualifier), (Object)"Second argument to the FLOOR function in PARTITIONED BY clause is not a valid granularity. Please refer to the documentation of FLOOR function");
            SqlIntervalQualifier granularityIntervalQualifier = (SqlIntervalQualifier)granularitySqlNode;
            Period period = TimeUnits.toPeriod(granularityIntervalQualifier.timeUnitRange);
            Preconditions.checkNotNull((Object)period, (Object)StringUtils.format((String)"%s is not a valid granularity for ingestion", (Object[])new Object[]{granularityIntervalQualifier.timeUnitRange.toString()}));
            return new PeriodGranularity(period, null, null);
        }
        throw new ParseException(StringUtils.format((String)"Encountered %s after PARTITIONED BY. Expected HOUR, DAY, MONTH, YEAR, ALL TIME, FLOOR function or %s function", (Object[])new Object[]{sqlNode.toString(), "TIME_FLOOR"}));
    }

    public static List<String> validateQueryAndConvertToIntervals(SqlNode replaceTimeQuery, Granularity granularity, DateTimeZone dateTimeZone) throws ValidationException {
        if (replaceTimeQuery instanceof SqlLiteral && ALL.equalsIgnoreCase(((SqlLiteral)replaceTimeQuery).toValue())) {
            return ImmutableList.of((Object)ALL);
        }
        DimFilter dimFilter = DruidSqlParserUtils.convertQueryToDimFilter(replaceTimeQuery, dateTimeZone);
        Filtration filtration = Filtration.create(dimFilter);
        filtration = MoveTimeFiltersToIntervals.instance().apply(filtration);
        List<Interval> intervals = filtration.getIntervals();
        if (filtration.getDimFilter() != null) {
            throw new ValidationException("Only __time column is supported in OVERWRITE WHERE clause");
        }
        if (intervals.isEmpty()) {
            throw new ValidationException("Intervals for replace are empty");
        }
        for (Interval interval : intervals) {
            DateTime intervalStart = interval.getStart();
            DateTime intervalEnd = interval.getEnd();
            if (granularity.bucketStart(intervalStart).equals((Object)intervalStart) && granularity.bucketStart(intervalEnd).equals((Object)intervalEnd)) continue;
            throw new ValidationException("OVERWRITE WHERE clause contains an interval " + intervals + " which is not aligned with PARTITIONED BY granularity " + granularity);
        }
        return intervals.stream().map(AbstractInterval::toString).collect(Collectors.toList());
    }

    public static SqlOrderBy convertClusterByToOrderBy(SqlNode query, SqlNodeList clusteredByList) {
        SqlNode offset = null;
        SqlNode fetch = null;
        if (query instanceof SqlOrderBy) {
            SqlOrderBy sqlOrderBy = (SqlOrderBy)query;
            query = sqlOrderBy.query;
            offset = sqlOrderBy.offset;
            fetch = sqlOrderBy.fetch;
        }
        return new SqlOrderBy(query.getParserPosition(), query, clusteredByList, offset, fetch);
    }

    public static DimFilter convertQueryToDimFilter(SqlNode replaceTimeQuery, DateTimeZone dateTimeZone) throws ValidationException {
        if (!(replaceTimeQuery instanceof SqlBasicCall)) {
            log.error("Expected SqlBasicCall during parsing, but found " + replaceTimeQuery.getClass().getName(), new Object[0]);
            throw new ValidationException("Invalid OVERWRITE WHERE clause");
        }
        SqlBasicCall sqlBasicCall = (SqlBasicCall)replaceTimeQuery;
        List operandList = sqlBasicCall.getOperandList();
        switch (sqlBasicCall.getOperator().getKind()) {
            case AND: {
                ArrayList<DimFilter> dimFilters = new ArrayList<DimFilter>();
                for (SqlNode sqlNode : sqlBasicCall.getOperandList()) {
                    dimFilters.add(DruidSqlParserUtils.convertQueryToDimFilter(sqlNode, dateTimeZone));
                }
                return new AndDimFilter(dimFilters);
            }
            case OR: {
                ArrayList<DimFilter> dimFilters = new ArrayList<DimFilter>();
                for (SqlNode sqlNode : sqlBasicCall.getOperandList()) {
                    dimFilters.add(DruidSqlParserUtils.convertQueryToDimFilter(sqlNode, dateTimeZone));
                }
                return new OrDimFilter(dimFilters);
            }
            case NOT: {
                return new NotDimFilter(DruidSqlParserUtils.convertQueryToDimFilter((SqlNode)sqlBasicCall.getOperandList().get(0), dateTimeZone));
            }
            case GREATER_THAN_OR_EQUAL: {
                String columnName = DruidSqlParserUtils.parseColumnName((SqlNode)operandList.get(0));
                return new BoundDimFilter(columnName, DruidSqlParserUtils.parseTimeStampWithTimeZone((SqlNode)operandList.get(1), dateTimeZone), null, Boolean.valueOf(false), null, null, null, StringComparators.NUMERIC);
            }
            case LESS_THAN_OR_EQUAL: {
                String columnName = DruidSqlParserUtils.parseColumnName((SqlNode)operandList.get(0));
                return new BoundDimFilter(columnName, null, DruidSqlParserUtils.parseTimeStampWithTimeZone((SqlNode)operandList.get(1), dateTimeZone), null, Boolean.valueOf(false), null, null, StringComparators.NUMERIC);
            }
            case GREATER_THAN: {
                String columnName = DruidSqlParserUtils.parseColumnName((SqlNode)operandList.get(0));
                return new BoundDimFilter(columnName, DruidSqlParserUtils.parseTimeStampWithTimeZone((SqlNode)operandList.get(1), dateTimeZone), null, Boolean.valueOf(true), null, null, null, StringComparators.NUMERIC);
            }
            case LESS_THAN: {
                String columnName = DruidSqlParserUtils.parseColumnName((SqlNode)operandList.get(0));
                return new BoundDimFilter(columnName, null, DruidSqlParserUtils.parseTimeStampWithTimeZone((SqlNode)operandList.get(1), dateTimeZone), null, Boolean.valueOf(true), null, null, StringComparators.NUMERIC);
            }
            case BETWEEN: {
                String columnName = DruidSqlParserUtils.parseColumnName((SqlNode)operandList.get(0));
                return new BoundDimFilter(columnName, DruidSqlParserUtils.parseTimeStampWithTimeZone((SqlNode)operandList.get(1), dateTimeZone), DruidSqlParserUtils.parseTimeStampWithTimeZone((SqlNode)operandList.get(2), dateTimeZone), Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC);
            }
        }
        throw new ValidationException("Unsupported operation in OVERWRITE WHERE clause: " + sqlBasicCall.getOperator().getName());
    }

    public static String parseColumnName(SqlNode sqlNode) throws ValidationException {
        if (!(sqlNode instanceof SqlIdentifier)) {
            throw new ValidationException("Expressions must be of the form __time <operator> TIMESTAMP");
        }
        return ((SqlIdentifier)sqlNode).getSimple();
    }

    public static String parseTimeStampWithTimeZone(SqlNode sqlNode, DateTimeZone timeZone) throws ValidationException {
        if (!(sqlNode instanceof SqlTimestampLiteral)) {
            throw new ValidationException("Expressions must be of the form __time <operator> TIMESTAMP");
        }
        Timestamp sqlTimestamp = Timestamp.valueOf(((SqlTimestampLiteral)sqlNode).toFormattedString());
        ZonedDateTime zonedTimestamp = sqlTimestamp.toLocalDateTime().atZone(timeZone.toTimeZone().toZoneId());
        return String.valueOf(zonedTimestamp.toInstant().toEpochMilli());
    }

    public static void throwIfUnsupportedGranularityInPartitionedBy(Granularity granularity) {
        if (!GranularityType.isStandard((Granularity)granularity)) {
            throw new IAE("The granularity specified in PARTITIONED BY is not supported. Please use an equivalent of these granularities: %s.", new Object[]{Arrays.stream(GranularityType.values()).filter(granularityType -> !granularityType.equals((Object)GranularityType.NONE)).map(Enum::name).map(StringUtils::toLowerCase).collect(Collectors.joining(", "))});
        }
    }
}

