/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.filtration;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.FalseDimFilter;
import org.apache.druid.query.filter.TrueDimFilter;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.filtration.CombineAndSimplifyBounds;
import org.apache.druid.sql.calcite.filtration.ConvertBoundsToSelectors;
import org.apache.druid.sql.calcite.filtration.ConvertSelectorsToIns;
import org.apache.druid.sql.calcite.filtration.MoveMarkerFiltersToIntervals;
import org.apache.druid.sql.calcite.filtration.MoveTimeFiltersToIntervals;
import org.apache.druid.sql.calcite.filtration.ValidateNoMarkerFiltersRemain;
import org.joda.time.Interval;

public class Filtration {
    private static final DimFilter MATCH_NOTHING = FalseDimFilter.instance();
    private static final DimFilter MATCH_EVERYTHING = TrueDimFilter.instance();
    private final DimFilter dimFilter;
    private final List<Interval> intervals;

    private Filtration(DimFilter dimFilter, List<Interval> intervals) {
        this.intervals = intervals != null ? intervals : Intervals.ONLY_ETERNITY;
        this.dimFilter = dimFilter;
    }

    public static Interval eternity() {
        return Intervals.ETERNITY;
    }

    public static DimFilter matchNothing() {
        return MATCH_NOTHING;
    }

    public static DimFilter matchEverything() {
        return MATCH_EVERYTHING;
    }

    public static Filtration create(DimFilter dimFilter) {
        return new Filtration(dimFilter, null);
    }

    public static Filtration create(DimFilter dimFilter, List<Interval> intervals) {
        return new Filtration(dimFilter, intervals);
    }

    private static Filtration transform(Filtration filtration, List<Function<Filtration, Filtration>> fns) {
        Filtration retVal = filtration;
        for (Function<Filtration, Filtration> fn : fns) {
            retVal = (Filtration)fn.apply((Object)retVal);
        }
        return retVal;
    }

    public QuerySegmentSpec getQuerySegmentSpec() {
        return new MultipleIntervalSegmentSpec(this.intervals);
    }

    public List<Interval> getIntervals() {
        return this.intervals;
    }

    public DimFilter getDimFilter() {
        return this.dimFilter;
    }

    public Filtration optimize(RowSignature rowSignature) {
        return Filtration.transform(this, (List<Function<Filtration, Filtration>>)ImmutableList.of((Object)CombineAndSimplifyBounds.instance(), (Object)MoveTimeFiltersToIntervals.instance(), (Object)ConvertBoundsToSelectors.create(rowSignature), (Object)ConvertSelectorsToIns.create(rowSignature), (Object)MoveMarkerFiltersToIntervals.instance(), (Object)ValidateNoMarkerFiltersRemain.instance()));
    }

    public Filtration optimizeFilterOnly(RowSignature rowSignature) {
        if (!this.intervals.equals(ImmutableList.of((Object)Filtration.eternity()))) {
            throw new ISE("Cannot optimizeFilterOnly when intervals are set", new Object[0]);
        }
        Filtration transformed = Filtration.transform(this, (List<Function<Filtration, Filtration>>)ImmutableList.of((Object)CombineAndSimplifyBounds.instance(), (Object)ConvertBoundsToSelectors.create(rowSignature), (Object)ConvertSelectorsToIns.create(rowSignature)));
        if (!transformed.getIntervals().equals(ImmutableList.of((Object)Filtration.eternity()))) {
            throw new ISE("optimizeFilterOnly was about to return filtration with intervals", new Object[0]);
        }
        return transformed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Filtration that = (Filtration)o;
        if (!Objects.equals(this.intervals, that.intervals)) {
            return false;
        }
        return Objects.equals(this.dimFilter, that.dimFilter);
    }

    public int hashCode() {
        int result = this.intervals != null ? this.intervals.hashCode() : 0;
        result = 31 * result + (this.dimFilter != null ? this.dimFilter.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Filtration{intervals=" + this.intervals + ", dimFilter=" + this.dimFilter + '}';
    }
}

