/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.filtration;

import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.SimpleExtraction;
import org.apache.druid.sql.calcite.filtration.BottomUpTransform;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class ConvertBoundsToSelectors
extends BottomUpTransform {
    private final RowSignature rowSignature;

    private ConvertBoundsToSelectors(RowSignature rowSignature) {
        this.rowSignature = rowSignature;
    }

    public static ConvertBoundsToSelectors create(RowSignature rowSignature) {
        return new ConvertBoundsToSelectors(rowSignature);
    }

    @Override
    public DimFilter process(DimFilter filter) {
        if (filter instanceof BoundDimFilter) {
            BoundDimFilter bound = (BoundDimFilter)filter;
            StringComparator comparator = RowSignatures.getNaturalStringComparator(this.rowSignature, SimpleExtraction.of(bound.getDimension(), bound.getExtractionFn()));
            if (bound.hasUpperBound() && bound.hasLowerBound() && bound.getUpper().equals(bound.getLower()) && !bound.isUpperStrict() && !bound.isLowerStrict() && bound.getOrdering().equals(comparator)) {
                return new SelectorDimFilter(bound.getDimension(), bound.getUpper(), bound.getExtractionFn());
            }
            return filter;
        }
        return filter;
    }
}

