/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.external;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.DataSource;
import org.apache.druid.segment.column.RowSignature;

@JsonTypeName(value="external")
public class ExternalDataSource
implements DataSource {
    private final InputSource inputSource;
    private final InputFormat inputFormat;
    private final RowSignature signature;

    @JsonCreator
    public ExternalDataSource(@JsonProperty(value="inputSource") InputSource inputSource, @JsonProperty(value="inputFormat") InputFormat inputFormat, @JsonProperty(value="signature") RowSignature signature) {
        this.inputSource = (InputSource)Preconditions.checkNotNull((Object)inputSource, (Object)"inputSource");
        this.inputFormat = (InputFormat)Preconditions.checkNotNull((Object)inputFormat, (Object)"inputFormat");
        this.signature = (RowSignature)Preconditions.checkNotNull((Object)signature, (Object)"signature");
    }

    @JsonProperty
    public InputSource getInputSource() {
        return this.inputSource;
    }

    @JsonProperty
    public InputFormat getInputFormat() {
        return this.inputFormat;
    }

    @JsonProperty
    public RowSignature getSignature() {
        return this.signature;
    }

    public Set<String> getTableNames() {
        return Collections.emptySet();
    }

    public List<DataSource> getChildren() {
        return Collections.emptyList();
    }

    public DataSource withChildren(List<DataSource> children) {
        if (!children.isEmpty()) {
            throw new IAE("Cannot accept children", new Object[0]);
        }
        return this;
    }

    public boolean isCacheable(boolean isBroker) {
        return false;
    }

    public boolean isGlobal() {
        return false;
    }

    public boolean isConcrete() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalDataSource that = (ExternalDataSource)o;
        return Objects.equals(this.inputSource, that.inputSource) && Objects.equals(this.inputFormat, that.inputFormat) && Objects.equals(this.signature, that.signature);
    }

    public int hashCode() {
        return Objects.hash(this.inputSource, this.inputFormat, this.signature);
    }

    public String toString() {
        return "ExternalDataSource{inputSource=" + this.inputSource + ", inputFormat=" + this.inputFormat + ", signature=" + this.signature + '}';
    }
}

