/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransform;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.calcite.sql2rel.SqlRexConvertlet;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.nested.NestedDataComplexTypeSerde;
import org.apache.druid.segment.nested.NestedPathFinder;
import org.apache.druid.segment.virtual.NestedFieldVirtualColumn;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.UnsupportedSQLQueryException;
import org.apache.druid.sql.calcite.planner.convertlet.DruidConvertletFactory;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class NestedDataOperatorConversions {
    public static final DruidJsonValueConvertletFactory DRUID_JSON_VALUE_CONVERTLET_FACTORY_INSTANCE = new DruidJsonValueConvertletFactory();
    public static final SqlReturnTypeInference NESTED_RETURN_TYPE_INFERENCE = opBinding -> RowSignatures.makeComplexType(opBinding.getTypeFactory(), NestedDataComplexTypeSerde.TYPE, true);

    public static class TryParseJsonOperatorConversion
    implements SqlOperatorConversion {
        private static final String FUNCTION_NAME = "try_parse_json";
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder(StringUtils.toUpperCase((String)"try_parse_json")).operandTypes(SqlTypeFamily.STRING).returnTypeInference(NESTED_RETURN_TYPE_INFERENCE).functionCategory(SqlFunctionCategory.USER_DEFINED_FUNCTION).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }

        @Override
        @Nullable
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, druidExpressions -> DruidExpression.ofExpression(NestedDataComplexTypeSerde.TYPE, DruidExpression.functionCall(FUNCTION_NAME), druidExpressions));
        }
    }

    public static class ParseJsonOperatorConversion
    implements SqlOperatorConversion {
        private static final String FUNCTION_NAME = "parse_json";
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder(StringUtils.toUpperCase((String)"parse_json")).operandTypes(SqlTypeFamily.STRING).returnTypeInference(NESTED_RETURN_TYPE_INFERENCE).functionCategory(SqlFunctionCategory.USER_DEFINED_FUNCTION).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }

        @Override
        @Nullable
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, druidExpressions -> DruidExpression.ofExpression(NestedDataComplexTypeSerde.TYPE, DruidExpression.functionCall(FUNCTION_NAME), druidExpressions));
        }
    }

    public static class ToJsonStringOperatorConversion
    implements SqlOperatorConversion {
        private static final String FUNCTION_NAME = "to_json_string";
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder(StringUtils.toUpperCase((String)"to_json_string")).operandTypes(SqlTypeFamily.ANY).returnTypeCascadeNullable(SqlTypeName.VARCHAR).functionCategory(SqlFunctionCategory.USER_DEFINED_FUNCTION).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }

        @Override
        @Nullable
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, druidExpressions -> DruidExpression.ofExpression(NestedDataComplexTypeSerde.TYPE, DruidExpression.functionCall(FUNCTION_NAME), druidExpressions));
        }
    }

    public static class JsonObjectOperatorConversion
    implements SqlOperatorConversion {
        private static final String FUNCTION_NAME = "json_object";
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("json_object").operandTypeChecker(OperandTypes.variadic((SqlOperandCountRange)SqlOperandCountRanges.from((int)1))).operandTypeInference((callBinding, returnType, operandTypes) -> {
            RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
            for (int i = 0; i < operandTypes.length; ++i) {
                operandTypes[i] = i % 2 == 0 ? typeFactory.createSqlType(SqlTypeName.VARCHAR) : typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true);
            }
        }).returnTypeInference(NESTED_RETURN_TYPE_INFERENCE).functionCategory(SqlFunctionCategory.SYSTEM).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }

        @Override
        @Nullable
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            DruidExpression.DruidExpressionCreator expressionFunction = druidExpressions -> DruidExpression.ofExpression(NestedDataComplexTypeSerde.TYPE, null, DruidExpression.functionCall(FUNCTION_NAME), druidExpressions);
            RexCall call = (RexCall)rexNode;
            List<DruidExpression> druidExpressions2 = Expressions.toDruidExpressions(plannerContext, rowSignature, call.getOperands().subList(1, call.getOperands().size()));
            if (druidExpressions2 == null) {
                return null;
            }
            return expressionFunction.create(druidExpressions2);
        }
    }

    public static class JsonValueAnyOperatorConversion
    implements SqlOperatorConversion {
        private static final SqlFunction FUNCTION = OperatorConversions.operatorBuilder("JSON_VALUE_ANY").operandTypeChecker(OperandTypes.or((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.sequence((String)"(expr,path)", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.CHARACTER, SqlTypeFamily.ANY, SqlTypeFamily.ANY, SqlTypeFamily.ANY, SqlTypeFamily.ANY, SqlTypeFamily.ANY})})).operandTypeInference((callBinding, returnType, operandTypes) -> {
            RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
            if (operandTypes.length > 5) {
                operandTypes[3] = typeFactory.createSqlType(SqlTypeName.ANY);
                operandTypes[5] = typeFactory.createSqlType(SqlTypeName.ANY);
            }
        }).returnTypeInference((SqlReturnTypeInference)ReturnTypes.cascade(opBinding -> opBinding.getTypeFactory().createTypeWithNullability(opBinding.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), true), (SqlTypeTransform[])new SqlTypeTransform[]{SqlTypeTransforms.FORCE_NULLABLE})).functionCategory(SqlFunctionCategory.SYSTEM).build();

        @Override
        public SqlOperator calciteOperator() {
            return FUNCTION;
        }

        @Override
        @Nullable
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            List parts;
            RexCall call = (RexCall)rexNode;
            List<DruidExpression> druidExpressions = Expressions.toDruidExpressions(plannerContext, rowSignature, call.getOperands().size() > 2 ? call.getOperands().subList(0, 2) : call.getOperands());
            if (druidExpressions == null || druidExpressions.size() != 2) {
                return null;
            }
            Expr pathExpr = Parser.parse((String)druidExpressions.get(1).getExpression(), (ExprMacroTable)plannerContext.getExprMacroTable());
            if (!pathExpr.isLiteral()) {
                return null;
            }
            String path = (String)pathExpr.eval(InputBindings.nilBindings()).value();
            try {
                parts = NestedPathFinder.parseJsonPath((String)path);
            }
            catch (IllegalArgumentException iae) {
                throw new UnsupportedSQLQueryException("Cannot use [%s]: [%s]", call.getOperator().getName(), iae.getMessage());
            }
            String jsonPath = NestedPathFinder.toNormalizedJsonPath((List)parts);
            DruidExpression.ExpressionGenerator builder = args -> "json_value(" + ((DruidExpression)args.get(0)).getExpression() + ",'" + jsonPath + "')";
            ColumnType columnType = ColumnType.STRING;
            if (druidExpressions.get(0).isSimpleExtraction()) {
                return DruidExpression.ofVirtualColumn(columnType, builder, (List<DruidExpression>)ImmutableList.of((Object)DruidExpression.ofColumn(NestedDataComplexTypeSerde.TYPE, druidExpressions.get(0).getDirectColumn())), (name, outputType, expression, macroTable) -> new NestedFieldVirtualColumn(((DruidExpression)druidExpressions.get(0)).getDirectColumn(), name, outputType, parts, Boolean.valueOf(false), null, null));
            }
            return DruidExpression.ofExpression(columnType, builder, druidExpressions);
        }
    }

    public static class JsonValueVarcharOperatorConversion
    extends JsonValueReturningTypeOperatorConversion {
        private static final SqlFunction FUNCTION = JsonValueVarcharOperatorConversion.buildFunction("JSON_VALUE_VARCHAR", SqlTypeName.VARCHAR);

        public JsonValueVarcharOperatorConversion() {
            super(FUNCTION, ColumnType.STRING);
        }
    }

    public static class JsonValueDoubleOperatorConversion
    extends JsonValueReturningTypeOperatorConversion {
        private static final SqlFunction FUNCTION = JsonValueDoubleOperatorConversion.buildFunction("JSON_VALUE_DOUBLE", SqlTypeName.DOUBLE);

        public JsonValueDoubleOperatorConversion() {
            super(FUNCTION, ColumnType.DOUBLE);
        }
    }

    public static class JsonValueBigintOperatorConversion
    extends JsonValueReturningTypeOperatorConversion {
        private static final SqlFunction FUNCTION = JsonValueBigintOperatorConversion.buildFunction("JSON_VALUE_BIGINT", SqlTypeName.BIGINT);

        public JsonValueBigintOperatorConversion() {
            super(FUNCTION, ColumnType.LONG);
        }
    }

    public static abstract class JsonValueReturningTypeOperatorConversion
    implements SqlOperatorConversion {
        private final SqlFunction function;
        private final ColumnType druidType;

        public JsonValueReturningTypeOperatorConversion(SqlFunction function, ColumnType druidType) {
            this.druidType = druidType;
            this.function = function;
        }

        @Override
        public SqlOperator calciteOperator() {
            return this.function;
        }

        @Override
        @Nullable
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            List parts;
            RexCall call = (RexCall)rexNode;
            List<DruidExpression> druidExpressions = Expressions.toDruidExpressions(plannerContext, rowSignature, call.getOperands());
            if (druidExpressions == null || druidExpressions.size() != 2) {
                return null;
            }
            Expr pathExpr = Parser.parse((String)druidExpressions.get(1).getExpression(), (ExprMacroTable)plannerContext.getExprMacroTable());
            if (!pathExpr.isLiteral()) {
                return null;
            }
            String path = (String)pathExpr.eval(InputBindings.nilBindings()).value();
            try {
                parts = NestedPathFinder.parseJsonPath((String)path);
            }
            catch (IllegalArgumentException iae) {
                throw new UnsupportedSQLQueryException("Cannot use [%s]: [%s]", call.getOperator().getName(), iae.getMessage());
            }
            String jsonPath = NestedPathFinder.toNormalizedJsonPath((List)parts);
            DruidExpression.ExpressionGenerator builder = args -> "json_value(" + ((DruidExpression)args.get(0)).getExpression() + ",'" + jsonPath + "', '" + this.druidType.asTypeString() + "')";
            if (druidExpressions.get(0).isSimpleExtraction()) {
                return DruidExpression.ofVirtualColumn(this.druidType, builder, (List<DruidExpression>)ImmutableList.of((Object)DruidExpression.ofColumn(NestedDataComplexTypeSerde.TYPE, druidExpressions.get(0).getDirectColumn())), (name, outputType, expression, macroTable) -> new NestedFieldVirtualColumn(((DruidExpression)druidExpressions.get(0)).getDirectColumn(), name, outputType, parts, Boolean.valueOf(false), null, null));
            }
            return DruidExpression.ofExpression(this.druidType, builder, druidExpressions);
        }

        static SqlFunction buildFunction(String functionName, SqlTypeName typeName) {
            return OperatorConversions.operatorBuilder(functionName).operandTypeChecker(OperandTypes.sequence((String)"(expr,path)", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})})).returnTypeInference((SqlReturnTypeInference)ReturnTypes.cascade(opBinding -> opBinding.getTypeFactory().createSqlType(typeName), (SqlTypeTransform[])new SqlTypeTransform[]{SqlTypeTransforms.FORCE_NULLABLE})).functionCategory(SqlFunctionCategory.USER_DEFINED_FUNCTION).build();
        }
    }

    public static class DruidJsonValueConvertletFactory
    implements DruidConvertletFactory {
        @Override
        public SqlRexConvertlet createConvertlet(PlannerContext plannerContext) {
            return (cx, call) -> {
                Preconditions.checkArgument((boolean)"SQLJSONVALUEEMPTYORERRORBEHAVIOR[NULL]".equals(call.operand(2).toString()), (Object)"Unsupported JSON_VALUE parameter 'ON EMPTY' defined - please re-issue this query without this argument");
                Preconditions.checkArgument((boolean)"NULL".equals(call.operand(3).toString()), (Object)"Unsupported JSON_VALUE parameter 'ON EMPTY' defined - please re-issue this query without this argument");
                Preconditions.checkArgument((boolean)"SQLJSONVALUEEMPTYORERRORBEHAVIOR[NULL]".equals(call.operand(4).toString()), (Object)"Unsupported JSON_VALUE parameter 'ON ERROR' defined - please re-issue this query without this argument");
                Preconditions.checkArgument((boolean)"NULL".equals(call.operand(5).toString()), (Object)"Unsupported JSON_VALUE parameter 'ON ERROR' defined - please re-issue this query without this argument");
                SqlDataTypeSpec dataType = (SqlDataTypeSpec)call.operand(6);
                RelDataType sqlType = dataType.deriveType(cx.getValidator());
                SqlCall rewrite = SqlTypeName.INT_TYPES.contains(sqlType.getSqlTypeName()) ? JsonValueBigintOperatorConversion.FUNCTION.createCall(SqlParserPos.ZERO, new SqlNode[]{call.operand(0), call.operand(1)}) : (SqlTypeName.APPROX_TYPES.contains(sqlType.getSqlTypeName()) ? JsonValueDoubleOperatorConversion.FUNCTION.createCall(SqlParserPos.ZERO, new SqlNode[]{call.operand(0), call.operand(1)}) : (SqlTypeName.STRING_TYPES.contains(sqlType.getSqlTypeName()) ? JsonValueVarcharOperatorConversion.FUNCTION.createCall(SqlParserPos.ZERO, new SqlNode[]{call.operand(0), call.operand(1)}) : JsonValueAnyOperatorConversion.FUNCTION.createCall(SqlParserPos.ZERO, new SqlNode[]{call.operand(0), call.operand(1)})));
                SqlCall caster = SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, new SqlNode[]{rewrite, call.operand(6)});
                return cx.convertExpression((SqlNode)caster);
            };
        }

        @Override
        public List<SqlOperator> operators() {
            return Collections.singletonList(SqlStdOperatorTable.JSON_VALUE);
        }
    }

    public static class JsonQueryOperatorConversion
    implements SqlOperatorConversion {
        private static final String FUNCTION_NAME = StringUtils.toUpperCase((String)"json_query");
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder(FUNCTION_NAME).operandTypeChecker((SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.CHARACTER, SqlTypeFamily.ANY, SqlTypeFamily.ANY, SqlTypeFamily.ANY})).returnTypeInference(NESTED_RETURN_TYPE_INFERENCE).functionCategory(SqlFunctionCategory.SYSTEM).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }

        @Override
        @Nullable
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            List parts;
            RexCall call = (RexCall)rexNode;
            List<DruidExpression> druidExpressions = Expressions.toDruidExpressions(plannerContext, rowSignature, call.getOperands().subList(0, 2));
            if (druidExpressions == null || druidExpressions.size() != 2) {
                return null;
            }
            Expr pathExpr = Parser.parse((String)druidExpressions.get(1).getExpression(), (ExprMacroTable)plannerContext.getExprMacroTable());
            if (!pathExpr.isLiteral()) {
                return null;
            }
            String path = (String)pathExpr.eval(InputBindings.nilBindings()).value();
            try {
                parts = NestedPathFinder.parseJsonPath((String)path);
            }
            catch (IllegalArgumentException iae) {
                throw new UnsupportedSQLQueryException("Cannot use [%s]: [%s]", call.getOperator().getName(), iae.getMessage());
            }
            String jsonPath = NestedPathFinder.toNormalizedJsonPath((List)parts);
            DruidExpression.ExpressionGenerator builder = args -> "json_query(" + ((DruidExpression)args.get(0)).getExpression() + ",'" + jsonPath + "')";
            if (druidExpressions.get(0).isSimpleExtraction()) {
                return DruidExpression.ofVirtualColumn(NestedDataComplexTypeSerde.TYPE, builder, (List<DruidExpression>)ImmutableList.of((Object)DruidExpression.ofColumn(NestedDataComplexTypeSerde.TYPE, druidExpressions.get(0).getDirectColumn())), (name, outputType, expression, macroTable) -> new NestedFieldVirtualColumn(((DruidExpression)druidExpressions.get(0)).getDirectColumn(), name, outputType, parts, Boolean.valueOf(true), null, null));
            }
            return DruidExpression.ofExpression(NestedDataComplexTypeSerde.TYPE, builder, druidExpressions);
        }
    }

    public static class JsonKeysOperatorConversion
    implements SqlOperatorConversion {
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("JSON_KEYS").operandTypeChecker(OperandTypes.sequence((String)"(expr,path)", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY, OperandTypes.and((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}), OperandTypes.LITERAL})})).functionCategory(SqlFunctionCategory.USER_DEFINED_FUNCTION).returnTypeNullableArrayWithNullableElements(SqlTypeName.VARCHAR).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }

        @Override
        @Nullable
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, druidExpressions -> DruidExpression.ofExpression(ColumnType.STRING_ARRAY, DruidExpression.functionCall("json_keys"), druidExpressions));
        }
    }

    public static class JsonPathsOperatorConversion
    implements SqlOperatorConversion {
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("JSON_PATHS").operandTypeChecker((SqlOperandTypeChecker)OperandTypes.ANY).functionCategory(SqlFunctionCategory.USER_DEFINED_FUNCTION).returnTypeArrayWithNullableElements(SqlTypeName.VARCHAR).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }

        @Override
        @Nullable
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, druidExpressions -> DruidExpression.ofExpression(null, DruidExpression.functionCall("json_paths"), druidExpressions));
        }
    }
}

