/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransform;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.calcite.util.Static;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DirectOperatorConversion;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.PostAggregatorVisitor;
import org.apache.druid.sql.calcite.expression.SimpleExtraction;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.DruidTypeSystem;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class OperatorConversions {
    @Nullable
    public static DruidExpression convertDirectCall(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, String functionName) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, (List<DruidExpression> druidExpressions) -> DruidExpression.ofFunctionCall(Calcites.getColumnTypeForRelDataType(rexNode.getType()), functionName, druidExpressions));
    }

    @Nullable
    public static DruidExpression convertDirectCallWithExtraction(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, String functionName, Function<List<DruidExpression>, SimpleExtraction> simpleExtractionFunction) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, (List<DruidExpression> druidExpressions) -> DruidExpression.ofExpression(Calcites.getColumnTypeForRelDataType(rexNode.getType()), simpleExtractionFunction == null ? null : (SimpleExtraction)simpleExtractionFunction.apply(druidExpressions), DruidExpression.functionCall(functionName), druidExpressions));
    }

    @Nullable
    public static DruidExpression convertCallBuilder(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, DruidExpression.ExpressionGenerator expressionGenerator) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, (List<DruidExpression> operands) -> DruidExpression.ofExpression(Calcites.getColumnTypeForRelDataType(rexNode.getType()), expressionGenerator, operands));
    }

    @Nullable
    public static DruidExpression convertCall(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, DruidExpression.DruidExpressionCreator expressionFunction) {
        RexCall call = (RexCall)rexNode;
        List<DruidExpression> druidExpressions = Expressions.toDruidExpressions(plannerContext, rowSignature, call.getOperands());
        if (druidExpressions == null) {
            return null;
        }
        return expressionFunction.create(druidExpressions);
    }

    @Deprecated
    @Nullable
    public static DruidExpression convertCall(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, String functionName) {
        return OperatorConversions.convertDirectCall(plannerContext, rowSignature, rexNode, functionName);
    }

    @Deprecated
    @Nullable
    public static DruidExpression convertCall(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, String functionName, Function<List<DruidExpression>, SimpleExtraction> simpleExtractionFunction) {
        return OperatorConversions.convertDirectCallWithExtraction(plannerContext, rowSignature, rexNode, functionName, simpleExtractionFunction);
    }

    public static <T> T getOperandWithDefault(List<RexNode> operands, int i, Function<RexNode, T> f, T defaultReturnValue) {
        if (operands.size() > i && !RexLiteral.isNullLiteral((RexNode)operands.get(i))) {
            return f.apply(operands.get(i));
        }
        return defaultReturnValue;
    }

    @Nullable
    public static DruidExpression convertCallWithPostAggOperands(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, DruidExpression.DruidExpressionCreator expressionFunction, PostAggregatorVisitor postAggregatorVisitor) {
        RexCall call = (RexCall)rexNode;
        List<DruidExpression> druidExpressions = Expressions.toDruidExpressionsWithPostAggOperands(plannerContext, rowSignature, call.getOperands(), postAggregatorVisitor);
        if (druidExpressions == null) {
            return null;
        }
        return expressionFunction.create(druidExpressions);
    }

    @Nullable
    public static PostAggregator toPostAggregator(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, PostAggregatorVisitor postAggregatorVisitor) {
        SqlKind kind = rexNode.getKind();
        if (kind == SqlKind.INPUT_REF) {
            RexInputRef ref = (RexInputRef)rexNode;
            String columnName = rowSignature.getColumnName(ref.getIndex());
            if (columnName == null) {
                throw new ISE("PostAggregator referred to nonexistent index[%d]", new Object[]{ref.getIndex()});
            }
            return new FieldAccessPostAggregator(postAggregatorVisitor.getOutputNamePrefix() + postAggregatorVisitor.getAndIncrementCounter(), columnName);
        }
        if (rexNode instanceof RexCall) {
            SqlOperator operator = ((RexCall)rexNode).getOperator();
            SqlOperatorConversion conversion = plannerContext.getOperatorTable().lookupOperatorConversion(operator);
            if (conversion == null) {
                return null;
            }
            return conversion.toPostAggregator(plannerContext, rowSignature, rexNode, postAggregatorVisitor);
        }
        if (kind == SqlKind.LITERAL) {
            return null;
        }
        throw new IAE("Unknown rexnode kind: " + kind, new Object[0]);
    }

    public static OperatorBuilder operatorBuilder(String name) {
        return new OperatorBuilder(name);
    }

    private static SqlTypeName defaultTypeForFamily(SqlTypeFamily family) {
        switch (family) {
            case NUMERIC: 
            case APPROXIMATE_NUMERIC: {
                return SqlTypeName.DOUBLE;
            }
            case INTEGER: 
            case EXACT_NUMERIC: {
                return SqlTypeName.BIGINT;
            }
            case CHARACTER: {
                return SqlTypeName.VARCHAR;
            }
            case TIMESTAMP: {
                return SqlTypeName.TIMESTAMP;
            }
        }
        return (SqlTypeName)Iterables.getFirst((Iterable)family.getTypeNames(), (Object)SqlTypeName.NULL);
    }

    private static boolean throwOrReturn(boolean throwOnFailure, SqlCallBinding callBinding, Function<SqlCallBinding, CalciteException> exceptionMapper) {
        if (throwOnFailure) {
            throw exceptionMapper.apply(callBinding);
        }
        return false;
    }

    public static DirectOperatorConversion druidUnaryLongFn(String sqlOperator, String druidFunctionName) {
        return new DirectOperatorConversion((SqlOperator)OperatorConversions.operatorBuilder(sqlOperator).requiredOperands(1).operandTypes(SqlTypeFamily.NUMERIC).returnTypeNullable(SqlTypeName.BIGINT).functionCategory(SqlFunctionCategory.NUMERIC).build(), druidFunctionName);
    }

    public static DirectOperatorConversion druidBinaryLongFn(String sqlOperator, String druidFunctionName) {
        return new DirectOperatorConversion((SqlOperator)OperatorConversions.operatorBuilder(sqlOperator).requiredOperands(2).operandTypes(SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC).returnTypeNullable(SqlTypeName.BIGINT).functionCategory(SqlFunctionCategory.NUMERIC).build(), druidFunctionName);
    }

    public static DirectOperatorConversion druidUnaryDoubleFn(String sqlOperator, String druidFunctionName) {
        return new DirectOperatorConversion((SqlOperator)OperatorConversions.operatorBuilder(StringUtils.toUpperCase((String)sqlOperator)).requiredOperands(1).operandTypes(SqlTypeFamily.NUMERIC).returnTypeNullable(SqlTypeName.DOUBLE).functionCategory(SqlFunctionCategory.NUMERIC).build(), druidFunctionName);
    }

    @VisibleForTesting
    static class DefaultOperandTypeChecker
    implements SqlOperandTypeChecker {
        private final List<SqlTypeFamily> operandTypes;
        private final int requiredOperands;
        private final IntSet nullableOperands;
        private final IntSet literalOperands;

        @VisibleForTesting
        DefaultOperandTypeChecker(List<SqlTypeFamily> operandTypes, int requiredOperands, IntSet nullableOperands, @Nullable int[] literalOperands) {
            Preconditions.checkArgument((requiredOperands <= operandTypes.size() && requiredOperands >= 0 ? 1 : 0) != 0);
            this.operandTypes = (List)Preconditions.checkNotNull(operandTypes, (Object)"operandTypes");
            this.requiredOperands = requiredOperands;
            this.nullableOperands = (IntSet)Preconditions.checkNotNull((Object)nullableOperands, (Object)"nullableOperands");
            if (literalOperands == null) {
                this.literalOperands = IntSets.EMPTY_SET;
            } else {
                this.literalOperands = new IntArraySet();
                Arrays.stream(literalOperands).forEach(arg_0 -> ((IntSet)this.literalOperands).add(arg_0));
            }
        }

        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            for (int i = 0; i < callBinding.operands().size(); ++i) {
                SqlNode operand = (SqlNode)callBinding.operands().get(i);
                if (this.literalOperands.contains(i) && !SqlUtil.isLiteral((SqlNode)operand)) {
                    return OperatorConversions.throwOrReturn(throwOnFailure, callBinding, cb -> cb.getValidator().newValidationError(operand, Static.RESOURCE.argumentMustBeLiteral(callBinding.getOperator().getName())));
                }
                RelDataType operandType = callBinding.getValidator().deriveType(callBinding.getScope(), operand);
                SqlTypeFamily expectedFamily = this.operandTypes.get(i);
                if (expectedFamily == SqlTypeFamily.ANY || expectedFamily.getTypeNames().contains(operandType.getSqlTypeName())) continue;
                if (operandType.getSqlTypeName() == SqlTypeName.NULL || SqlUtil.isNullLiteral((SqlNode)operand, (boolean)true)) {
                    if (this.nullableOperands.contains(i)) continue;
                    return OperatorConversions.throwOrReturn(throwOnFailure, callBinding, cb -> cb.getValidator().newValidationError(operand, Static.RESOURCE.nullIllegal()));
                }
                return OperatorConversions.throwOrReturn(throwOnFailure, callBinding, SqlCallBinding::newValidationSignatureError);
            }
            return true;
        }

        public SqlOperandCountRange getOperandCountRange() {
            return SqlOperandCountRanges.between((int)this.requiredOperands, (int)this.operandTypes.size());
        }

        public String getAllowedSignatures(SqlOperator op, String opName) {
            return SqlUtil.getAliasedSignature((SqlOperator)op, (String)opName, this.operandTypes);
        }

        public SqlOperandTypeChecker.Consistency getConsistency() {
            return SqlOperandTypeChecker.Consistency.NONE;
        }

        public boolean isOptional(int i) {
            return i + 1 > this.requiredOperands;
        }
    }

    private static class DefaultOperandTypeInference
    implements SqlOperandTypeInference {
        private final List<SqlTypeFamily> operandTypes;
        private final IntSet nullableOperands;

        DefaultOperandTypeInference(List<SqlTypeFamily> operandTypes, IntSet nullableOperands) {
            this.operandTypes = operandTypes;
            this.nullableOperands = nullableOperands;
        }

        public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypesOut) {
            for (int i = 0; i < operandTypesOut.length; ++i) {
                RelDataType derivedType = callBinding.getValidator().deriveType(callBinding.getScope(), callBinding.operand(i));
                RelDataType inferredType = derivedType.getSqlTypeName() != SqlTypeName.NULL ? derivedType : (this.nullableOperands.contains(i) ? Calcites.createSqlTypeWithNullability(callBinding.getTypeFactory(), OperatorConversions.defaultTypeForFamily(this.operandTypes.get(i)), true) : callBinding.getValidator().getUnknownType());
                operandTypesOut[i] = inferredType;
            }
        }
    }

    public static class OperatorBuilder {
        private final String name;
        private SqlKind kind = SqlKind.OTHER_FUNCTION;
        private SqlReturnTypeInference returnTypeInference;
        private SqlFunctionCategory functionCategory = SqlFunctionCategory.USER_DEFINED_FUNCTION;
        private SqlOperandTypeChecker operandTypeChecker;
        private List<SqlTypeFamily> operandTypes;
        private Integer requiredOperands = null;
        private int[] literalOperands = null;
        private SqlOperandTypeInference operandTypeInference;

        private OperatorBuilder(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        }

        public OperatorBuilder returnTypeNonNull(SqlTypeName typeName) {
            Preconditions.checkState((this.returnTypeInference == null ? 1 : 0) != 0, (Object)"Cannot set return type multiple times");
            this.returnTypeInference = ReturnTypes.explicit(factory -> Calcites.createSqlType(factory, typeName));
            return this;
        }

        public OperatorBuilder returnTypeNullable(SqlTypeName typeName) {
            Preconditions.checkState((this.returnTypeInference == null ? 1 : 0) != 0, (Object)"Cannot set return type multiple times");
            this.returnTypeInference = ReturnTypes.explicit(factory -> Calcites.createSqlTypeWithNullability(factory, typeName, true));
            return this;
        }

        public OperatorBuilder returnTypeCascadeNullable(SqlTypeName typeName) {
            Preconditions.checkState((this.returnTypeInference == null ? 1 : 0) != 0, (Object)"Cannot set return type multiple times");
            this.returnTypeInference = ReturnTypes.cascade((SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)typeName), (SqlTypeTransform[])new SqlTypeTransform[]{SqlTypeTransforms.TO_NULLABLE});
            return this;
        }

        public OperatorBuilder returnTypeArrayWithNullableElements(SqlTypeName elementTypeName) {
            Preconditions.checkState((this.returnTypeInference == null ? 1 : 0) != 0, (Object)"Cannot set return type multiple times");
            this.returnTypeInference = ReturnTypes.explicit(factory -> Calcites.createSqlArrayTypeWithNullability(factory, elementTypeName, true));
            return this;
        }

        public OperatorBuilder returnTypeNullableArrayWithNullableElements(SqlTypeName elementTypeName) {
            this.returnTypeInference = ReturnTypes.cascade(opBinding -> Calcites.createSqlArrayTypeWithNullability(opBinding.getTypeFactory(), elementTypeName, true), (SqlTypeTransform[])new SqlTypeTransform[]{SqlTypeTransforms.FORCE_NULLABLE});
            return this;
        }

        public OperatorBuilder returnTypeInference(SqlReturnTypeInference returnTypeInference) {
            Preconditions.checkState((this.returnTypeInference == null ? 1 : 0) != 0, (Object)"Cannot set return type multiple times");
            this.returnTypeInference = returnTypeInference;
            return this;
        }

        public OperatorBuilder functionCategory(SqlFunctionCategory functionCategory) {
            this.functionCategory = functionCategory;
            return this;
        }

        public OperatorBuilder operandTypeChecker(SqlOperandTypeChecker operandTypeChecker) {
            this.operandTypeChecker = operandTypeChecker;
            return this;
        }

        public OperatorBuilder operandTypes(SqlTypeFamily ... operandTypes) {
            this.operandTypes = Arrays.asList(operandTypes);
            return this;
        }

        public OperatorBuilder requiredOperands(int requiredOperands) {
            this.requiredOperands = requiredOperands;
            return this;
        }

        public OperatorBuilder literalOperands(int ... literalOperands) {
            this.literalOperands = literalOperands;
            return this;
        }

        public OperatorBuilder operandTypeInference(SqlOperandTypeInference operandTypeInference) {
            this.operandTypeInference = operandTypeInference;
            return this;
        }

        public SqlFunction build() {
            SqlOperandTypeChecker theOperandTypeChecker;
            IntArraySet nullableOperands = new IntArraySet();
            if (this.requiredOperands != null) {
                IntStream.range(this.requiredOperands, this.operandTypes.size()).forEach(arg_0 -> ((IntSet)nullableOperands).add(arg_0));
            }
            if (this.operandTypeChecker == null) {
                theOperandTypeChecker = new DefaultOperandTypeChecker(this.operandTypes, this.requiredOperands == null ? this.operandTypes.size() : this.requiredOperands.intValue(), (IntSet)nullableOperands, this.literalOperands);
            } else if (this.operandTypes == null && this.requiredOperands == null && this.literalOperands == null) {
                theOperandTypeChecker = this.operandTypeChecker;
            } else {
                throw new ISE("Cannot have both 'operandTypeChecker' and 'operandTypes' / 'requiredOperands' / 'literalOperands'", new Object[0]);
            }
            if (this.operandTypeInference == null) {
                DefaultOperandTypeInference defaultInference = new DefaultOperandTypeInference(this.operandTypes, (IntSet)nullableOperands);
                this.operandTypeInference = (callBinding, returnType, types) -> {
                    for (int i = 0; i < types.length; ++i) {
                        if (callBinding.operand(i).isA((Set)ImmutableSet.of((Object)SqlKind.DYNAMIC_PARAM))) {
                            types[i] = new BasicSqlType((RelDataTypeSystem)DruidTypeSystem.INSTANCE, SqlTypeName.ANY);
                            continue;
                        }
                        defaultInference.inferOperandTypes(callBinding, returnType, types);
                    }
                };
            }
            return new SqlFunction(this.name, this.kind, (SqlReturnTypeInference)Preconditions.checkNotNull((Object)this.returnTypeInference, (Object)"returnTypeInference"), this.operandTypeInference, theOperandTypeChecker, this.functionCategory);
        }
    }
}

