/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.expression.TimestampFloorExprMacro;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.TimeFormatExtractionFn;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.ExpressionDimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.ExtractionFns;
import org.apache.druid.sql.calcite.expression.PostAggregatorVisitor;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.filtration.BoundRefKey;
import org.apache.druid.sql.calcite.filtration.Bounds;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;
import org.apache.druid.sql.calcite.table.RowSignatures;
import org.joda.time.Interval;

public class Expressions {
    private Expressions() {
    }

    public static RexNode fromFieldAccess(RowSignature rowSignature, @Nullable Project project, int fieldNumber) {
        if (project == null) {
            return RexInputRef.of((int)fieldNumber, (RelDataType)RowSignatures.toRelDataType(rowSignature, (RelDataTypeFactory)new JavaTypeFactoryImpl()));
        }
        return (RexNode)project.getChildExps().get(fieldNumber);
    }

    @Nullable
    public static List<DruidExpression> toDruidExpressions(PlannerContext plannerContext, RowSignature rowSignature, List<RexNode> rexNodes) {
        ArrayList<DruidExpression> retVal = new ArrayList<DruidExpression>(rexNodes.size());
        for (RexNode rexNode : rexNodes) {
            DruidExpression druidExpression = Expressions.toDruidExpression(plannerContext, rowSignature, rexNode);
            if (druidExpression == null) {
                return null;
            }
            retVal.add(druidExpression);
        }
        return retVal;
    }

    @Nullable
    public static List<DruidExpression> toDruidExpressionsWithPostAggOperands(PlannerContext plannerContext, RowSignature rowSignature, List<RexNode> rexNodes, PostAggregatorVisitor postAggregatorVisitor) {
        ArrayList<DruidExpression> retVal = new ArrayList<DruidExpression>(rexNodes.size());
        for (RexNode rexNode : rexNodes) {
            DruidExpression druidExpression = Expressions.toDruidExpressionWithPostAggOperands(plannerContext, rowSignature, rexNode, postAggregatorVisitor);
            if (druidExpression == null) {
                return null;
            }
            retVal.add(druidExpression);
        }
        return retVal;
    }

    @Nullable
    public static DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return Expressions.toDruidExpressionWithPostAggOperands(plannerContext, rowSignature, rexNode, null);
    }

    @Nullable
    public static DruidExpression toDruidExpressionWithPostAggOperands(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, @Nullable PostAggregatorVisitor postAggregatorVisitor) {
        SqlKind kind = rexNode.getKind();
        if (kind == SqlKind.INPUT_REF) {
            return Expressions.inputRefToDruidExpression(rowSignature, rexNode);
        }
        if (rexNode instanceof RexCall) {
            return Expressions.rexCallToDruidExpression(plannerContext, rowSignature, rexNode, postAggregatorVisitor);
        }
        if (kind == SqlKind.LITERAL) {
            return Expressions.literalToDruidExpression(plannerContext, rexNode);
        }
        return null;
    }

    private static DruidExpression inputRefToDruidExpression(RowSignature rowSignature, RexNode rexNode) {
        RexInputRef ref = (RexInputRef)rexNode;
        String columnName = rowSignature.getColumnName(ref.getIndex());
        Optional columnType = rowSignature.getColumnType(ref.getIndex());
        if (columnName == null) {
            throw new ISE("Expression referred to nonexistent index[%d]", new Object[]{ref.getIndex()});
        }
        return DruidExpression.ofColumn(columnType.orElse(null), columnName);
    }

    private static DruidExpression rexCallToDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, PostAggregatorVisitor postAggregatorVisitor) {
        PostAggregator postAggregator;
        SqlOperator operator = ((RexCall)rexNode).getOperator();
        SqlOperatorConversion conversion = plannerContext.getOperatorTable().lookupOperatorConversion(operator);
        if (conversion == null) {
            plannerContext.setPlanningError("SQL query requires '%s' operator that is not supported.", operator.getName());
            return null;
        }
        if (postAggregatorVisitor != null && (postAggregator = conversion.toPostAggregator(plannerContext, rowSignature, rexNode, postAggregatorVisitor)) != null) {
            postAggregatorVisitor.addPostAgg(postAggregator);
            String exprName = postAggregator.getName();
            return DruidExpression.ofColumn(postAggregator.getType((ColumnInspector)rowSignature), exprName);
        }
        DruidExpression expression = conversion.toDruidExpressionWithPostAggOperands(plannerContext, rowSignature, rexNode, postAggregatorVisitor);
        return expression;
    }

    @Nullable
    private static DruidExpression literalToDruidExpression(PlannerContext plannerContext, RexNode rexNode) {
        SqlTypeName sqlTypeName = rexNode.getType().getSqlTypeName();
        ColumnType columnType = Calcites.getColumnTypeForRelDataType(rexNode.getType());
        if (RexLiteral.isNullLiteral((RexNode)rexNode)) {
            return DruidExpression.ofLiteral(columnType, DruidExpression.nullLiteral());
        }
        if (SqlTypeName.NUMERIC_TYPES.contains(sqlTypeName)) {
            return DruidExpression.ofLiteral(columnType, DruidExpression.numberLiteral((Number)((Object)RexLiteral.value((RexNode)rexNode))));
        }
        if (SqlTypeFamily.INTERVAL_DAY_TIME == sqlTypeName.getFamily()) {
            long milliseconds = ((Number)((Object)RexLiteral.value((RexNode)rexNode))).longValue();
            return DruidExpression.ofLiteral(columnType, DruidExpression.numberLiteral(milliseconds));
        }
        if (SqlTypeFamily.INTERVAL_YEAR_MONTH == sqlTypeName.getFamily()) {
            long months = ((Number)((Object)RexLiteral.value((RexNode)rexNode))).longValue();
            return DruidExpression.ofLiteral(columnType, DruidExpression.numberLiteral(months));
        }
        if (SqlTypeName.STRING_TYPES.contains(sqlTypeName)) {
            return DruidExpression.ofStringLiteral(RexLiteral.stringValue((RexNode)rexNode));
        }
        if (SqlTypeName.TIMESTAMP == sqlTypeName || SqlTypeName.DATE == sqlTypeName) {
            if (RexLiteral.isNullLiteral((RexNode)rexNode)) {
                return DruidExpression.ofLiteral(columnType, DruidExpression.nullLiteral());
            }
            return DruidExpression.ofLiteral(columnType, DruidExpression.numberLiteral(Calcites.calciteDateTimeLiteralToJoda(rexNode, plannerContext.getTimeZone()).getMillis()));
        }
        if (SqlTypeName.BOOLEAN == sqlTypeName) {
            return DruidExpression.ofLiteral(columnType, DruidExpression.numberLiteral(RexLiteral.booleanValue((RexNode)rexNode) ? 1 : 0));
        }
        return null;
    }

    @Nullable
    public static DimFilter toFilter(PlannerContext plannerContext, RowSignature rowSignature, @Nullable VirtualColumnRegistry virtualColumnRegistry, RexNode expression) {
        SqlKind kind = expression.getKind();
        if (kind == SqlKind.IS_TRUE || kind == SqlKind.IS_NOT_FALSE) {
            return Expressions.toFilter(plannerContext, rowSignature, virtualColumnRegistry, (RexNode)Iterables.getOnlyElement((Iterable)((RexCall)expression).getOperands()));
        }
        if (kind == SqlKind.IS_FALSE || kind == SqlKind.IS_NOT_TRUE) {
            return new NotDimFilter(Expressions.toFilter(plannerContext, rowSignature, virtualColumnRegistry, (RexNode)Iterables.getOnlyElement((Iterable)((RexCall)expression).getOperands())));
        }
        if (kind == SqlKind.CAST && expression.getType().getSqlTypeName() == SqlTypeName.BOOLEAN) {
            return Expressions.toFilter(plannerContext, rowSignature, virtualColumnRegistry, (RexNode)Iterables.getOnlyElement((Iterable)((RexCall)expression).getOperands()));
        }
        if (kind == SqlKind.AND || kind == SqlKind.OR || kind == SqlKind.NOT) {
            ArrayList<DimFilter> filters = new ArrayList<DimFilter>();
            for (RexNode rexNode : ((RexCall)expression).getOperands()) {
                DimFilter nextFilter = Expressions.toFilter(plannerContext, rowSignature, virtualColumnRegistry, rexNode);
                if (nextFilter == null) {
                    return null;
                }
                filters.add(nextFilter);
            }
            if (kind == SqlKind.AND) {
                return new AndDimFilter(filters);
            }
            if (kind == SqlKind.OR) {
                return new OrDimFilter(filters);
            }
            assert (kind == SqlKind.NOT);
            return new NotDimFilter((DimFilter)Iterables.getOnlyElement(filters));
        }
        return Expressions.toLeafFilter(plannerContext, rowSignature, virtualColumnRegistry, expression);
    }

    @Nullable
    private static DimFilter toLeafFilter(PlannerContext plannerContext, RowSignature rowSignature, @Nullable VirtualColumnRegistry virtualColumnRegistry, RexNode rexNode) {
        if (rexNode.isAlwaysTrue()) {
            return Filtration.matchEverything();
        }
        if (rexNode.isAlwaysFalse()) {
            return Filtration.matchNothing();
        }
        DimFilter simpleFilter = Expressions.toSimpleLeafFilter(plannerContext, rowSignature, virtualColumnRegistry, rexNode);
        return simpleFilter != null ? simpleFilter : Expressions.toExpressionLeafFilter(plannerContext, rowSignature, rexNode);
    }

    @Nullable
    private static DimFilter toSimpleLeafFilter(PlannerContext plannerContext, RowSignature rowSignature, @Nullable VirtualColumnRegistry virtualColumnRegistry, RexNode rexNode) {
        block40: {
            BoundDimFilter filter;
            String val;
            Granularity granularity;
            ExtractionFn extractionFn;
            String column;
            SqlKind flippedKind;
            RexNode rhs;
            RexNode lhs;
            block42: {
                SqlKind kind;
                block41: {
                    kind = rexNode.getKind();
                    if (kind == SqlKind.IS_TRUE || kind == SqlKind.IS_NOT_FALSE) {
                        return Expressions.toSimpleLeafFilter(plannerContext, rowSignature, virtualColumnRegistry, (RexNode)Iterables.getOnlyElement((Iterable)((RexCall)rexNode).getOperands()));
                    }
                    if (kind == SqlKind.IS_FALSE || kind == SqlKind.IS_NOT_TRUE) {
                        return new NotDimFilter(Expressions.toSimpleLeafFilter(plannerContext, rowSignature, virtualColumnRegistry, (RexNode)Iterables.getOnlyElement((Iterable)((RexCall)rexNode).getOperands())));
                    }
                    if (kind == SqlKind.IS_NULL || kind == SqlKind.IS_NOT_NULL) {
                        SelectorDimFilter equalFilter;
                        RexNode operand = (RexNode)Iterables.getOnlyElement((Iterable)((RexCall)rexNode).getOperands());
                        DruidExpression druidExpression = Expressions.toDruidExpression(plannerContext, rowSignature, operand);
                        if (druidExpression == null) {
                            return null;
                        }
                        if (druidExpression.isSimpleExtraction()) {
                            equalFilter = new SelectorDimFilter(druidExpression.getSimpleExtraction().getColumn(), NullHandling.defaultStringValue(), druidExpression.getSimpleExtraction().getExtractionFn());
                        } else if (virtualColumnRegistry != null) {
                            String virtualColumn = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(druidExpression, operand.getType());
                            equalFilter = new SelectorDimFilter(virtualColumn, NullHandling.defaultStringValue(), null);
                        } else {
                            return null;
                        }
                        return kind == SqlKind.IS_NOT_NULL ? new NotDimFilter((DimFilter)equalFilter) : equalFilter;
                    }
                    if (kind != SqlKind.EQUALS && kind != SqlKind.NOT_EQUALS && kind != SqlKind.GREATER_THAN && kind != SqlKind.GREATER_THAN_OR_EQUAL && kind != SqlKind.LESS_THAN && kind != SqlKind.LESS_THAN_OR_EQUAL) break block40;
                    List operands = ((RexCall)rexNode).getOperands();
                    Preconditions.checkState((operands.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 operands, got[%,d]", (Object[])new Object[]{operands.size()});
                    boolean flip = false;
                    lhs = (RexNode)operands.get(0);
                    rhs = (RexNode)operands.get(1);
                    if (lhs.getKind() == SqlKind.LITERAL && rhs.getKind() != SqlKind.LITERAL) {
                        RexNode x = lhs;
                        lhs = rhs;
                        rhs = x;
                        flip = true;
                    }
                    if (!flip) break block41;
                    switch (kind) {
                        case EQUALS: 
                        case NOT_EQUALS: {
                            flippedKind = kind;
                            break block42;
                        }
                        case GREATER_THAN: {
                            flippedKind = SqlKind.LESS_THAN;
                            break block42;
                        }
                        case GREATER_THAN_OR_EQUAL: {
                            flippedKind = SqlKind.LESS_THAN_OR_EQUAL;
                            break block42;
                        }
                        case LESS_THAN: {
                            flippedKind = SqlKind.GREATER_THAN;
                            break block42;
                        }
                        case LESS_THAN_OR_EQUAL: {
                            flippedKind = SqlKind.GREATER_THAN_OR_EQUAL;
                            break block42;
                        }
                        default: {
                            throw new ISE("Kind[%s] not expected here", new Object[]{kind});
                        }
                    }
                }
                flippedKind = kind;
            }
            if (rhs.getKind() != SqlKind.LITERAL) {
                return null;
            }
            DruidExpression lhsExpression = Expressions.toDruidExpression(plannerContext, rowSignature, lhs);
            if (lhsExpression == null) {
                return null;
            }
            Granularity queryGranularity = Expressions.toQueryGranularity(lhsExpression, plannerContext.getExprMacroTable());
            if (queryGranularity != null) {
                long rhsMillis = Calcites.calciteDateTimeLiteralToJoda(rhs, plannerContext.getTimeZone()).getMillis();
                return Expressions.buildTimeFloorFilter("__time", queryGranularity, flippedKind, rhsMillis);
            }
            if (lhsExpression.isSimpleExtraction()) {
                column = lhsExpression.getSimpleExtraction().getColumn();
                extractionFn = lhsExpression.getSimpleExtraction().getExtractionFn();
            } else if (virtualColumnRegistry != null) {
                column = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(lhsExpression, lhs.getType());
                extractionFn = null;
            } else {
                return null;
            }
            if (column.equals("__time") && extractionFn instanceof TimeFormatExtractionFn && (granularity = ExtractionFns.toQueryGranularity(extractionFn)) != null) {
                long rhsMillis = Calcites.calciteDateTimeLiteralToJoda(rhs, plannerContext.getTimeZone()).getMillis();
                Interval rhsInterval = granularity.bucket(DateTimes.utc((long)rhsMillis));
                boolean rhsAligned = rhsInterval.getStartMillis() == rhsMillis;
                BoundRefKey boundRefKey = new BoundRefKey(column, null, StringComparators.NUMERIC);
                return Expressions.getBoundTimeDimFilter(flippedKind, boundRefKey, rhsInterval, rhsAligned);
            }
            RexLiteral rhsLiteral = (RexLiteral)rhs;
            if (SqlTypeName.NUMERIC_TYPES.contains(rhsLiteral.getTypeName())) {
                val = String.valueOf(RexLiteral.value((RexNode)rhsLiteral));
            } else if (SqlTypeName.CHAR_TYPES.contains(rhsLiteral.getTypeName())) {
                val = String.valueOf(RexLiteral.stringValue((RexNode)rhsLiteral));
            } else if (SqlTypeName.TIMESTAMP == rhsLiteral.getTypeName() || SqlTypeName.DATE == rhsLiteral.getTypeName()) {
                val = String.valueOf(Calcites.calciteDateTimeLiteralToJoda((RexNode)rhsLiteral, plannerContext.getTimeZone()).getMillis());
            } else {
                return null;
            }
            StringComparator comparator = Calcites.getStringComparatorForRelDataType(lhs.getType());
            BoundRefKey boundRefKey = new BoundRefKey(column, extractionFn, comparator);
            switch (flippedKind) {
                case EQUALS: {
                    filter = Bounds.equalTo(boundRefKey, val);
                    break;
                }
                case NOT_EQUALS: {
                    filter = new NotDimFilter((DimFilter)Bounds.equalTo(boundRefKey, val));
                    break;
                }
                case GREATER_THAN: {
                    filter = Bounds.greaterThan(boundRefKey, val);
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    filter = Bounds.greaterThanOrEqualTo(boundRefKey, val);
                    break;
                }
                case LESS_THAN: {
                    filter = Bounds.lessThan(boundRefKey, val);
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    filter = Bounds.lessThanOrEqualTo(boundRefKey, val);
                    break;
                }
                default: {
                    throw new IllegalStateException("Shouldn't have got here");
                }
            }
            return filter;
        }
        if (rexNode instanceof RexCall) {
            SqlOperator operator = ((RexCall)rexNode).getOperator();
            SqlOperatorConversion conversion = plannerContext.getOperatorTable().lookupOperatorConversion(operator);
            if (conversion == null) {
                return null;
            }
            return conversion.toDruidFilter(plannerContext, rowSignature, virtualColumnRegistry, rexNode);
        }
        return null;
    }

    @Nullable
    private static DimFilter toExpressionLeafFilter(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        DruidExpression druidExpression = Expressions.toDruidExpression(plannerContext, rowSignature, rexNode);
        return druidExpression != null ? new ExpressionDimFilter(druidExpression.getExpression(), plannerContext.getExprMacroTable()) : null;
    }

    @Nullable
    public static Granularity toQueryGranularity(DruidExpression expression, ExprMacroTable macroTable) {
        TimestampFloorExprMacro.TimestampFloorExpr expr = Expressions.asTimestampFloorExpr(expression, macroTable);
        if (expr == null) {
            return null;
        }
        Expr arg = expr.getArg();
        PeriodGranularity granularity = expr.getGranularity();
        if ("__time".equals(arg.getBindingIfIdentifier())) {
            return granularity;
        }
        return null;
    }

    @Nullable
    public static TimestampFloorExprMacro.TimestampFloorExpr asTimestampFloorExpr(DruidExpression expression, ExprMacroTable macroTable) {
        Expr expr = Parser.parse((String)expression.getExpression(), (ExprMacroTable)macroTable);
        if (expr instanceof TimestampFloorExprMacro.TimestampFloorExpr) {
            return (TimestampFloorExprMacro.TimestampFloorExpr)expr;
        }
        return null;
    }

    private static DimFilter buildTimeFloorFilter(String column, Granularity granularity, SqlKind operatorKind, long rhsMillis) {
        BoundRefKey boundRefKey = new BoundRefKey(column, null, StringComparators.NUMERIC);
        Interval rhsInterval = granularity.bucket(DateTimes.utc((long)rhsMillis));
        boolean rhsAligned = rhsInterval.getStartMillis() == rhsMillis;
        return Expressions.getBoundTimeDimFilter(operatorKind, boundRefKey, rhsInterval, rhsAligned);
    }

    private static DimFilter getBoundTimeDimFilter(SqlKind operatorKind, BoundRefKey boundRefKey, Interval interval, boolean isAligned) {
        switch (operatorKind) {
            case EQUALS: {
                return isAligned ? Bounds.interval(boundRefKey, interval) : Filtration.matchNothing();
            }
            case NOT_EQUALS: {
                return isAligned ? new NotDimFilter((DimFilter)Bounds.interval(boundRefKey, interval)) : Filtration.matchEverything();
            }
            case GREATER_THAN: {
                return Bounds.greaterThanOrEqualTo(boundRefKey, String.valueOf(interval.getEndMillis()));
            }
            case GREATER_THAN_OR_EQUAL: {
                return isAligned ? Bounds.greaterThanOrEqualTo(boundRefKey, String.valueOf(interval.getStartMillis())) : Bounds.greaterThanOrEqualTo(boundRefKey, String.valueOf(interval.getEndMillis()));
            }
            case LESS_THAN: {
                return isAligned ? Bounds.lessThan(boundRefKey, String.valueOf(interval.getStartMillis())) : Bounds.lessThan(boundRefKey, String.valueOf(interval.getEndMillis()));
            }
            case LESS_THAN_OR_EQUAL: {
                return Bounds.lessThan(boundRefKey, String.valueOf(interval.getEndMillis()));
            }
        }
        throw new IllegalStateException("Shouldn't have got here");
    }
}

