/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.Aggregations;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public abstract class MultiColumnSqlAggregator
implements SqlAggregator {
    @Override
    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry, RexBuilder rexBuilder, String name, AggregateCall aggregateCall, Project project, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        if (aggregateCall.isDistinct()) {
            return null;
        }
        List<DruidExpression> arguments = Aggregations.getArgumentsForSimpleAggregator(plannerContext, rowSignature, aggregateCall, project);
        if (arguments == null) {
            return null;
        }
        ExprMacroTable macroTable = plannerContext.getExprMacroTable();
        ArrayList<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>();
        for (DruidExpression argument : arguments) {
            if (argument.isDirectColumnAccess()) {
                fieldInfoList.add(FieldInfo.fromFieldName(argument.getDirectColumn()));
                continue;
            }
            fieldInfoList.add(FieldInfo.fromExpression(argument.getExpression()));
        }
        Preconditions.checkArgument((!fieldInfoList.isEmpty() ? 1 : 0) != 0, (Object)"FieldInfoList should not be empty");
        return this.getAggregation(name, aggregateCall, macroTable, fieldInfoList);
    }

    private Aggregation getAggregation(String name, AggregateCall aggregateCall, ExprMacroTable macroTable, List<FieldInfo> fieldInfoList) {
        ColumnType valueType = Calcites.getColumnTypeForRelDataType(aggregateCall.getType());
        ArrayList<AggregatorFactory> aggregatorFactories = new ArrayList<AggregatorFactory>();
        ArrayList<PostAggregator> postAggregators = new ArrayList<PostAggregator>();
        int id = 0;
        for (FieldInfo fieldInfo : fieldInfoList) {
            String prefixedName = Calcites.makePrefixedName(name, String.valueOf(id++));
            postAggregators.add((PostAggregator)new FieldAccessPostAggregator(null, prefixedName));
            aggregatorFactories.add(this.createAggregatorFactory(valueType, prefixedName, fieldInfo, macroTable));
        }
        PostAggregator finalPostAggregator = this.createFinalPostAggregator(valueType, name, postAggregators);
        return Aggregation.create(aggregatorFactories, finalPostAggregator);
    }

    abstract AggregatorFactory createAggregatorFactory(ColumnType var1, String var2, FieldInfo var3, ExprMacroTable var4);

    abstract PostAggregator createFinalPostAggregator(ColumnType var1, String var2, List<PostAggregator> var3);

    protected static class FieldInfo {
        final String fieldName;
        final String expression;

        private FieldInfo(String fieldName, String expression) {
            this.fieldName = fieldName;
            this.expression = expression;
        }

        public static FieldInfo fromFieldName(String fieldName) {
            return new FieldInfo(fieldName, null);
        }

        public static FieldInfo fromExpression(String expression) {
            return new FieldInfo(null, expression);
        }
    }
}

