/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Optionality;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.any.DoubleAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.FloatAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.LongAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.StringAnyAggregatorFactory;
import org.apache.druid.query.aggregation.first.DoubleFirstAggregatorFactory;
import org.apache.druid.query.aggregation.first.FloatFirstAggregatorFactory;
import org.apache.druid.query.aggregation.first.LongFirstAggregatorFactory;
import org.apache.druid.query.aggregation.first.StringFirstAggregatorFactory;
import org.apache.druid.query.aggregation.last.DoubleLastAggregatorFactory;
import org.apache.druid.query.aggregation.last.FloatLastAggregatorFactory;
import org.apache.druid.query.aggregation.last.LongLastAggregatorFactory;
import org.apache.druid.query.aggregation.last.StringLastAggregatorFactory;
import org.apache.druid.query.aggregation.post.FinalizingFieldAccessPostAggregator;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.UnsupportedSQLQueryException;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class EarliestLatestAnySqlAggregator
implements SqlAggregator {
    public static final SqlAggregator EARLIEST = new EarliestLatestAnySqlAggregator(AggregatorType.EARLIEST);
    public static final SqlAggregator LATEST = new EarliestLatestAnySqlAggregator(AggregatorType.LATEST);
    public static final SqlAggregator ANY_VALUE = new EarliestLatestAnySqlAggregator(AggregatorType.ANY_VALUE);
    private final AggregatorType aggregatorType;
    private final SqlAggFunction function;

    private EarliestLatestAnySqlAggregator(AggregatorType aggregatorType) {
        this.aggregatorType = aggregatorType;
        this.function = new EarliestLatestSqlAggFunction(aggregatorType);
    }

    @Override
    public SqlAggFunction calciteFunction() {
        return this.function;
    }

    @Override
    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry, RexBuilder rexBuilder, String name, AggregateCall aggregateCall, Project project, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        AggregatorFactory theAggFactory;
        List<RexNode> rexNodes = aggregateCall.getArgList().stream().map(i -> Expressions.fromFieldAccess(rowSignature, project, i)).collect(Collectors.toList());
        List<DruidExpression> args = Expressions.toDruidExpressions(plannerContext, rowSignature, rexNodes);
        if (args == null) {
            return null;
        }
        String aggregatorName = finalizeAggregations ? Calcites.makePrefixedName(name, "a") : name;
        ColumnType outputType = Calcites.getColumnTypeForRelDataType(aggregateCall.getType());
        if (outputType == null) {
            throw new ISE("Cannot translate output sqlTypeName[%s] to Druid type for aggregator[%s]", new Object[]{aggregateCall.getType().getSqlTypeName(), aggregateCall.getName()});
        }
        String fieldName = EarliestLatestAnySqlAggregator.getColumnName(plannerContext, virtualColumnRegistry, args.get(0), rexNodes.get(0));
        switch (args.size()) {
            case 1: {
                theAggFactory = this.aggregatorType.createAggregatorFactory(aggregatorName, fieldName, null, outputType, -1);
                break;
            }
            case 2: {
                theAggFactory = this.aggregatorType.createAggregatorFactory(aggregatorName, fieldName, null, outputType, RexLiteral.intValue((RexNode)rexNodes.get(1)));
                break;
            }
            default: {
                throw new IAE("aggregation[%s], Invalid number of arguments[%,d] to [%s] operator", new Object[]{aggregatorName, args.size(), this.aggregatorType.name()});
            }
        }
        return Aggregation.create(Collections.singletonList(theAggFactory), (PostAggregator)(finalizeAggregations ? new FinalizingFieldAccessPostAggregator(name, aggregatorName) : null));
    }

    static String getColumnName(PlannerContext plannerContext, VirtualColumnRegistry virtualColumnRegistry, DruidExpression arg, RexNode rexNode) {
        String columnName;
        if (arg.isDirectColumnAccess()) {
            columnName = arg.getDirectColumn();
        } else {
            RelDataType dataType = rexNode.getType();
            columnName = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(arg, dataType);
        }
        return columnName;
    }

    private static class EarliestLatestSqlAggFunction
    extends SqlAggFunction {
        private static final EarliestLatestReturnTypeInference EARLIEST_LATEST_ARG0_RETURN_TYPE_INFERENCE = new EarliestLatestReturnTypeInference(0);

        EarliestLatestSqlAggFunction(AggregatorType aggregatorType) {
            super(aggregatorType.name(), null, SqlKind.OTHER_FUNCTION, (SqlReturnTypeInference)EARLIEST_LATEST_ARG0_RETURN_TYPE_INFERENCE, InferTypes.RETURN_TYPE, OperandTypes.or((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.NUMERIC, OperandTypes.BOOLEAN, OperandTypes.sequence((String)("'" + aggregatorType.name() + "(expr, maxBytesPerString)'\n"), (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY, OperandTypes.and((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.NUMERIC, OperandTypes.LITERAL})})}), SqlFunctionCategory.USER_DEFINED_FUNCTION, false, false, Optionality.FORBIDDEN);
        }
    }

    static class EarliestLatestReturnTypeInference
    implements SqlReturnTypeInference {
        private final int ordinal;

        public EarliestLatestReturnTypeInference(int ordinal) {
            this.ordinal = ordinal;
        }

        public RelDataType inferReturnType(SqlOperatorBinding sqlOperatorBinding) {
            RelDataType type = sqlOperatorBinding.getOperandType(this.ordinal);
            if (!SqlTypeUtil.isNumeric((RelDataType)type) && !SqlTypeUtil.isString((RelDataType)type)) {
                return sqlOperatorBinding.getTypeFactory().createSqlType(SqlTypeName.VARCHAR);
            }
            return type;
        }
    }

    static enum AggregatorType {
        EARLIEST{

            @Override
            AggregatorFactory createAggregatorFactory(String name, String fieldName, String timeColumn, ColumnType type, int maxStringBytes) {
                switch ((ValueType)type.getType()) {
                    case LONG: {
                        return new LongFirstAggregatorFactory(name, fieldName, timeColumn);
                    }
                    case FLOAT: {
                        return new FloatFirstAggregatorFactory(name, fieldName, timeColumn);
                    }
                    case DOUBLE: {
                        return new DoubleFirstAggregatorFactory(name, fieldName, timeColumn);
                    }
                    case STRING: 
                    case COMPLEX: {
                        return new StringFirstAggregatorFactory(name, fieldName, timeColumn, Integer.valueOf(maxStringBytes));
                    }
                }
                throw new UnsupportedSQLQueryException("EARLIEST aggregator is not supported for '%s' type", type);
            }
        }
        ,
        LATEST{

            @Override
            AggregatorFactory createAggregatorFactory(String name, String fieldName, String timeColumn, ColumnType type, int maxStringBytes) {
                switch ((ValueType)type.getType()) {
                    case LONG: {
                        return new LongLastAggregatorFactory(name, fieldName, timeColumn);
                    }
                    case FLOAT: {
                        return new FloatLastAggregatorFactory(name, fieldName, timeColumn);
                    }
                    case DOUBLE: {
                        return new DoubleLastAggregatorFactory(name, fieldName, timeColumn);
                    }
                    case STRING: 
                    case COMPLEX: {
                        return new StringLastAggregatorFactory(name, fieldName, timeColumn, Integer.valueOf(maxStringBytes));
                    }
                }
                throw new UnsupportedSQLQueryException("LATEST aggregator is not supported for '%s' type", type);
            }
        }
        ,
        ANY_VALUE{

            @Override
            AggregatorFactory createAggregatorFactory(String name, String fieldName, String timeColumn, ColumnType type, int maxStringBytes) {
                switch ((ValueType)type.getType()) {
                    case LONG: {
                        return new LongAnyAggregatorFactory(name, fieldName);
                    }
                    case FLOAT: {
                        return new FloatAnyAggregatorFactory(name, fieldName);
                    }
                    case DOUBLE: {
                        return new DoubleAnyAggregatorFactory(name, fieldName);
                    }
                    case STRING: {
                        return new StringAnyAggregatorFactory(name, fieldName, Integer.valueOf(maxStringBytes));
                    }
                }
                throw new UnsupportedSQLQueryException("ANY aggregation is not supported for '%s' type", type);
            }
        };


        abstract AggregatorFactory createAggregatorFactory(String var1, String var2, String var3, ColumnType var4, int var5);
    }
}

