/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.Aggregations;
import org.apache.druid.sql.calcite.aggregation.ApproxCountDistinctSqlAggregator;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class CountSqlAggregator
implements SqlAggregator {
    private final ApproxCountDistinctSqlAggregator approxCountDistinctAggregator;

    @Inject
    public CountSqlAggregator(ApproxCountDistinctSqlAggregator approxCountDistinctAggregator) {
        this.approxCountDistinctAggregator = approxCountDistinctAggregator;
    }

    @Override
    public SqlAggFunction calciteFunction() {
        return SqlStdOperatorTable.COUNT;
    }

    static AggregatorFactory createCountAggregatorFactory(String countName, PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry, RexBuilder rexBuilder, AggregateCall aggregateCall, Project project) {
        RexNode rexNode = Expressions.fromFieldAccess(rowSignature, project, (Integer)Iterables.getOnlyElement((Iterable)aggregateCall.getArgList()));
        if (rexNode.getType().isNullable()) {
            DimFilter nonNullFilter = Expressions.toFilter(plannerContext, rowSignature, virtualColumnRegistry, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, (List)ImmutableList.of((Object)rexNode)));
            if (nonNullFilter == null) {
                throw new ISE("Could not create not-null filter for rexNode[%s]", new Object[]{rexNode});
            }
            return new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory(countName), nonNullFilter);
        }
        return new CountAggregatorFactory(countName);
    }

    @Override
    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry, RexBuilder rexBuilder, String name, AggregateCall aggregateCall, Project project, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        List<DruidExpression> args = Aggregations.getArgumentsForSimpleAggregator(plannerContext, rowSignature, aggregateCall, project);
        if (args == null) {
            return null;
        }
        if (args.isEmpty()) {
            return Aggregation.create((AggregatorFactory)new CountAggregatorFactory(name));
        }
        if (aggregateCall.isDistinct()) {
            if (plannerContext.getPlannerConfig().isUseApproximateCountDistinct()) {
                return this.approxCountDistinctAggregator.toDruidAggregation(plannerContext, rowSignature, virtualColumnRegistry, rexBuilder, name, aggregateCall, project, existingAggregations, finalizeAggregations);
            }
            return null;
        }
        AggregatorFactory theCount = CountSqlAggregator.createCountAggregatorFactory(name, plannerContext, rowSignature, virtualColumnRegistry, rexBuilder, aggregateCall, project);
        return Aggregation.create(theCount);
    }
}

